/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.netbeans.modules.java.source.ActivatedDocumentListener;
import org.netbeans.modules.java.source.JavaSourceTaskFactoryManager;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.LuceneIndexMBeanImpl;
import org.netbeans.modules.java.source.usages.NBLockFactory;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.modules.java.source.util.LowMemoryNotifierMBeanImpl;
import org.openide.ErrorManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class JBrowseModule
extends ModuleInstall {
    private static final boolean ENABLE_MBEANS = Boolean.getBoolean("org.netbeans.modules.java.source.enableMBeans");

    public void restored() {
        super.restored();
        NBLockFactory.clearLocks();
        JavaSourceTaskFactoryManager.register();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RepositoryUpdater.getDefault();
                ActivatedDocumentListener.register();
            }
        });
        if (ENABLE_MBEANS) {
            JBrowseModule.registerMBeans();
        }
    }

    public boolean closing() {
        boolean ret = super.closing();
        RepositoryUpdater.getDefault().close();
        try {
            ClassIndexManager.getDefault().writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    ClassIndexManager.getDefault().close();
                    return null;
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (ENABLE_MBEANS) {
            JBrowseModule.unregisterMBeans();
        }
        return ret;
    }

    private static void registerMBeans() {
        try {
            MBeanServer mgs = ManagementFactory.getPlatformMBeanServer();
            mgs.registerMBean(new LowMemoryNotifierMBeanImpl(), new ObjectName("org.netbeans.modules.java.source:type=LowMemoryNotifier"));
            mgs.registerMBean(LuceneIndexMBeanImpl.getDefault(), new ObjectName("org.netbeans.modules.java.source:type=LuceneIndex"));
        }
        catch (NotCompliantMBeanException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private static void unregisterMBeans() {
        try {
            MBeanServer mgs = ManagementFactory.getPlatformMBeanServer();
            mgs.unregisterMBean(new ObjectName("org.netbeans.modules.java.source:type=LowMemoryNotifier"));
            mgs.unregisterMBean(new ObjectName("org.netbeans.modules.java.source:type=LuceneIndex"));
        }
        catch (MalformedObjectNameException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }
}

