/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ParameterNameResolver;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Iterator;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementScanner6;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.SymbolDumper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ParamNameResolver
extends ParameterNameResolver {
    private Context context;
    private ClasspathInfo cpInfo;

    public static void preRegister(Context context, ClasspathInfo cpInfo) {
        context.put(parameterNameResolverKey, new ParamNameResolver(context, cpInfo));
    }

    private ParamNameResolver(Context context, ClasspathInfo cpInfo) {
        this.context = context;
        this.cpInfo = cpInfo;
    }

    public void resolveNames(final Symbol.ClassSymbol clazz) {
        try {
            JavaSource js;
            FileObject fo = SourceUtils.getFile(clazz, this.cpInfo);
            JavaSource javaSource = js = fo != null ? JavaSource.forFileObject(fo) : null;
            if (js != null) {
                js.runUserActionTask(new CancellableTask<CompilationController>(){

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        new Scanner(controller).scan(clazz);
                    }
                }, true);
            } else {
                new Scanner(null).scan(clazz);
            }
            this.dumpSymFile(clazz);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSymFile(Symbol.ClassSymbol clazz) throws IOException {
        PrintWriter writer = null;
        try {
            File outputFile;
            String name;
            String pkg;
            JavaFileManager fm = ClasspathInfoAccessor.INSTANCE.getFileManager(this.cpInfo);
            String binaryName = fm.inferBinaryName(StandardLocation.PLATFORM_CLASS_PATH, clazz.classfile);
            if (binaryName == null) {
                binaryName = fm.inferBinaryName(StandardLocation.CLASS_PATH, clazz.classfile);
            }
            assert (binaryName != null);
            String surl = clazz.classfile.toUri().toURL().toExternalForm();
            int index = surl.lastIndexOf(FileObjects.convertPackage2Folder(binaryName));
            assert (index > 0);
            File classes = Index.getClassFolder(new URL(surl.substring(0, index)));
            index = binaryName.lastIndexOf(46);
            if (index < 0) {
                pkg = null;
                name = binaryName;
            } else {
                pkg = binaryName.substring(0, index);
                assert (binaryName.length() > index);
                name = binaryName.substring(index + 1);
            }
            if (pkg != null && !(classes = new File(classes, pkg.replace('.', File.separatorChar))).exists()) {
                classes.mkdirs();
            }
            if (!(outputFile = new File(classes, name + '.' + "sig")).exists()) {
                outputFile.createNewFile();
            }
            writer = new PrintWriter(outputFile);
            SymbolDumper.dump(writer, Types.instance(this.context), clazz, clazz.owner.kind != true ? clazz.owner : null);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Scanner
    extends ElementScanner6<Void, Void> {
        private CompilationController controller;

        public Scanner(CompilationController controller) {
            this.controller = controller;
        }

        @Override
        public Void visitExecutable(ExecutableElement originalMethod, Void p) {
            Iterator<Symbol.VarSymbol> origIt = ((Symbol.MethodSymbol)originalMethod).params().iterator();
            if (origIt.hasNext()) {
                ExecutableElement method;
                if (this.controller != null && (method = ElementHandle.create(originalMethod).resolve(this.controller)) != null) {
                    Iterator<Symbol.VarSymbol> it = ((Symbol.MethodSymbol)method).params().iterator();
                    while (origIt.hasNext() && it.hasNext()) {
                        Symbol.VarSymbol originalParam = origIt.next();
                        Symbol.VarSymbol param = it.next();
                        originalParam.setName(param.name);
                    }
                }
                while (origIt.hasNext()) {
                    Symbol.VarSymbol originalParam = origIt.next();
                    originalParam.setName(originalParam.name);
                }
            }
            return (Void)super.visitExecutable(originalMethod, p);
        }
    }
}

