/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import org.netbeans.modules.java.source.builder.UndoListService;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.ReattributionException;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.engine.TreeFinder;
import org.netbeans.modules.java.source.transform.UndoEntry;
import org.netbeans.modules.java.source.transform.UndoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASTService
implements ASTModel {
    private RootTree root;
    private UndoList undoList;
    private Map<JavaFileObject, Map<JCTree, Integer>> endPosTables;
    private static final Context.Key<ASTService> treeKey = new Context.Key();

    public static synchronized ASTService instance(Context context) {
        ASTService instance = context.get(treeKey);
        if (instance == null) {
            instance = new ASTService(context);
        }
        return instance;
    }

    protected ASTService(Context context) {
        context.put(treeKey, this);
        this.undoList = UndoListService.instance(context);
        this.endPosTables = new HashMap<JavaFileObject, Map<JCTree, Integer>>();
    }

    @Override
    public Tree getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(final RootTree tree) throws ReattributionException {
        if (tree == this.root) {
            return;
        }
        this.undoList.addAndApply(new UndoEntry(){
            private final RootTree old;
            {
                this.old = ASTService.this.root;
            }

            @Override
            public void undo() {
                ASTService.this.root = this.old;
            }

            @Override
            public void redo() {
                ASTService.this.root = tree;
            }

            @Override
            public <T> T getOld(T o) {
                return (T)(o == tree ? this.old : null);
            }
        });
    }

    @Override
    public CompilationUnitTree getTopLevel(Tree tree) {
        if (tree == null) {
            return null;
        }
        Tree[] path = this.makePath(this.root, tree);
        for (int i = 0; i < path.length; ++i) {
            if (!(path[i] instanceof CompilationUnitTree)) continue;
            return (CompilationUnitTree)path[i];
        }
        assert (tree instanceof RootTree);
        return null;
    }

    @Override
    public Element getElement(Tree tree) {
        if (tree == null) {
            return null;
        }
        switch (tree.getKind()) {
            case COMPILATION_UNIT: {
                return ((JCTree.JCCompilationUnit)tree).packge;
            }
            case CLASS: {
                return ((JCTree.JCClassDecl)tree).sym;
            }
            case METHOD: {
                return ((JCTree.JCMethodDecl)tree).sym;
            }
            case VARIABLE: {
                return ((JCTree.JCVariableDecl)tree).sym;
            }
            case MEMBER_SELECT: {
                return ((JCTree.JCFieldAccess)tree).sym;
            }
            case IDENTIFIER: {
                return ((JCTree.JCIdent)tree).sym;
            }
            case NEW_CLASS: {
                return ((JCTree.JCNewClass)tree).constructor;
            }
        }
        return null;
    }

    @Override
    public TypeMirror getType(Tree tree) {
        Element e;
        if (tree == null || tree instanceof RootTree) {
            return null;
        }
        TypeMirror type = ((JCTree)tree).type;
        if (type == null && (e = this.getElement(tree)) != null) {
            type = e.asType();
        }
        return type;
    }

    @Override
    public void setElement(Tree tree, Element element) {
        switch (((JCTree)tree).tag) {
            case 1: {
                ((JCTree.JCCompilationUnit)tree).packge = (Symbol.PackageSymbol)element;
                break;
            }
            case 3: {
                ((JCTree.JCClassDecl)tree).sym = (Symbol.ClassSymbol)element;
                break;
            }
            case 4: {
                ((JCTree.JCMethodDecl)tree).sym = (Symbol.MethodSymbol)element;
                break;
            }
            case 5: {
                ((JCTree.JCVariableDecl)tree).sym = (Symbol.VarSymbol)element;
                break;
            }
            case 34: {
                ((JCTree.JCFieldAccess)tree).sym = (Symbol)element;
                break;
            }
            case 35: {
                ((JCTree.JCIdent)tree).sym = (Symbol)element;
                break;
            }
            case 27: {
                ((JCTree.JCNewClass)tree).constructor = (Symbol)element;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tree type: " + (Object)((Object)tree.getKind()));
            }
        }
    }

    @Override
    public void setType(Tree tree, TypeMirror type) {
        ((JCTree)tree).type = (Type)type;
    }

    @Override
    public boolean isThis(IdentifierTree t) {
        return t instanceof IdentifierTree && ASTService.isThis(((JCTree.JCIdent)t).name);
    }

    private static boolean isThis(Name nm) {
        return nm == nm.table._this;
    }

    @Override
    public boolean isSynthetic(Tree tree) {
        if (tree == null) {
            return false;
        }
        long flags = 0L;
        JCTree t = (JCTree)tree;
        switch (t.tag) {
            case 3: {
                flags = ((JCTree.JCClassDecl)t).mods.flags;
                break;
            }
            case 4: {
                flags = ((JCTree.JCMethodDecl)t).mods.flags;
                break;
            }
            case 5: {
                flags = ((JCTree.JCVariableDecl)t).mods.flags;
                break;
            }
            case 7: {
                if (t.pos == -1) {
                    return true;
                }
                flags = ((JCTree.JCBlock)t).flags;
                break;
            }
            case 44: {
                if (t.pos != -1) break;
                return true;
            }
        }
        return (flags & 0x1000L) != 0L;
    }

    @Override
    public Tree[] makePath(Tree root, Tree target) {
        final Stack stack = new Stack();
        root.accept(new TreeFinder(target){

            public Boolean scan(Tree tree, Object o) {
                super.scan(tree, o);
                if (this.found) {
                    stack.push(tree);
                }
                return this.found;
            }
        }, null);
        Tree[] path = new Tree[stack.size()];
        for (int i = 0; i < path.length; ++i) {
            path[i] = (Tree)stack.pop();
        }
        return path;
    }

    @Override
    public int getPos(Tree tree) {
        if (tree == null) {
            return -1;
        }
        return ((JCTree)tree).pos;
    }

    @Override
    public int getStartPos(Tree tree) {
        if (tree == null) {
            return -1;
        }
        switch (((JCTree)tree).tag) {
            case 26: {
                return this.getStartPos(((JCTree.JCMethodInvocation)tree).meth);
            }
            case 30: {
                return this.getStartPos(((JCTree.JCAssign)tree).lhs);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.getStartPos(((JCTree.JCAssignOp)tree).lhs);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.getStartPos(((JCTree.JCBinary)tree).lhs);
            }
            case 3: {
                JCTree.JCClassDecl node = (JCTree.JCClassDecl)tree;
                if (node.mods.pos == -1) break;
                return node.mods.pos;
            }
            case 18: {
                return this.getStartPos(((JCTree.JCConditional)tree).cond);
            }
            case 20: {
                return this.getStartPos(((JCTree.JCExpressionStatement)tree).expr);
            }
            case 33: {
                return this.getStartPos(((JCTree.JCArrayAccess)tree).indexed);
            }
            case 4: {
                JCTree.JCMethodDecl node = (JCTree.JCMethodDecl)tree;
                if (node.mods.pos != -1) {
                    return node.mods.pos;
                }
                if (node.restype != null) {
                    return this.getStartPos(node.restype);
                }
                return node.pos;
            }
            case 34: {
                return this.getStartPos(((JCTree.JCFieldAccess)tree).selected);
            }
            case 39: {
                return this.getStartPos(((JCTree.JCTypeApply)tree).clazz);
            }
            case 38: {
                return this.getStartPos(((JCTree.JCArrayTypeTree)tree).elemtype);
            }
            case 32: {
                return this.getStartPos(((JCTree.JCInstanceOf)tree).expr);
            }
            case 52: 
            case 53: {
                return this.getStartPos(((JCTree.JCUnary)tree).arg);
            }
            case 5: {
                JCTree.JCVariableDecl node = (JCTree.JCVariableDecl)tree;
                if (node.mods.pos != -1) {
                    return node.mods.pos;
                }
                return this.getStartPos(node.vartype);
            }
        }
        return ((JCTree)tree).pos;
    }

    @Override
    public int getEndPos(Tree tree, CompilationUnitTree topLevel) {
        Map<JCTree, Integer> endPositions;
        Map<JCTree, Integer> map = endPositions = topLevel != null ? this.endPosTables.get(topLevel.getSourceFile()) : null;
        if (tree == null || endPositions == null) {
            return -1;
        }
        Integer mapPos = endPositions.get(tree);
        if (mapPos != null) {
            return mapPos;
        }
        JCTree t = (JCTree)tree;
        switch (t.tag) {
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.getEndPos(((JCTree.JCAssignOp)tree).rhs, topLevel);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.getEndPos(((JCTree.JCBinary)tree).rhs, topLevel);
            }
            case 14: {
                return this.getEndPos(((JCTree.JCCase)tree).stats.last(), topLevel);
            }
            case 17: {
                return this.getEndPos(((JCTree.JCCatch)tree).body, topLevel);
            }
            case 20: {
                return this.getEndPos(((JCTree.JCExpressionStatement)tree).expr, topLevel);
            }
            case 18: {
                return this.getEndPos(((JCTree.JCConditional)tree).falsepart, topLevel);
            }
            case 10: {
                if (tree instanceof JCTree.JCForLoop) {
                    return this.getEndPos(((JCTree.JCForLoop)tree).body, topLevel);
                }
                return this.getEndPos(((JCTree.JCEnhancedForLoop)tree).body, topLevel);
            }
            case 35: {
                return t.pos + ((JCTree.JCIdent)tree).name.len;
            }
            case 19: {
                JCTree.JCIf node = (JCTree.JCIf)tree;
                if (node.elsepart == null) {
                    return this.getEndPos(node.thenpart, topLevel);
                }
                return this.getEndPos(node.elsepart, topLevel);
            }
            case 11: {
                return this.getEndPos(((JCTree.JCEnhancedForLoop)tree).body, topLevel);
            }
            case 12: {
                return this.getEndPos(((JCTree.JCLabeledStatement)tree).body, topLevel);
            }
            case 44: {
                return this.getEndPos(((JCTree.JCModifiers)tree).annotations.last(), topLevel);
            }
            case 34: {
                JCTree.JCFieldAccess select = (JCTree.JCFieldAccess)tree;
                return this.getEndPos(select.selected, topLevel) + 1 + select.name.len;
            }
            case 15: {
                return this.getEndPos(((JCTree.JCSynchronized)tree).body, topLevel);
            }
            case 1: {
                return this.getEndPos(((JCTree.JCCompilationUnit)tree).defs.last(), topLevel);
            }
            case 16: {
                JCTree.JCTry node = (JCTree.JCTry)tree;
                if (node.finalizer == null) {
                    return this.getEndPos(node.catchers.last(), topLevel);
                }
                return this.getEndPos(node.finalizer, topLevel);
            }
            case 31: {
                return this.getEndPos(((JCTree.JCTypeCast)tree).expr, topLevel);
            }
            case 32: {
                return this.getEndPos(((JCTree.JCInstanceOf)tree).clazz, topLevel);
            }
            case 41: {
                return this.getEndPos(((JCTree.JCWildcard)tree).inner, topLevel);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                return this.getEndPos(((JCTree.JCUnary)tree).arg, topLevel);
            }
            case 9: {
                return this.getEndPos(((JCTree.JCWhileLoop)tree).body, topLevel);
            }
        }
        return -1;
    }

    @Override
    public void setPos(Tree tree, int newPos) {
        ((JCTree)tree).pos = newPos;
    }

    public void setEndPosTable(JavaFileObject name, Map<JCTree, Integer> table) {
        this.endPosTables.put(name, table);
    }

    public List<? extends Tree> getChildren(Tree tree) {
        if (tree instanceof RootTree) {
            return ((RootTree)tree).getCompilationUnits();
        }
        if (tree instanceof CompilationUnitTree) {
            return ((CompilationUnitTree)tree).getTypeDecls();
        }
        if (tree instanceof ClassTree) {
            return ((ClassTree)tree).getMembers();
        }
        return Collections.emptyList();
    }
}

