/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.java.source.builder.BufferRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferRunQueue
implements Iterable<BufferRun> {
    private ArrayList<BufferRun> runs = new ArrayList();
    private SortedMap<Integer, Integer> positionMap = new TreeMap<Integer, Integer>();
    private SortedMap<Integer, Integer> endPositionMap = new TreeMap<Integer, Integer>();
    private int next;

    void add(BufferRun br) {
        this.runs.add(br);
        int lastRun = this.runs.size() - 1;
        this.positionMap.put(br.start, lastRun);
        this.endPositionMap.put(br.end, lastRun);
    }

    void addCoallescing(BufferRun br) {
        int sz;
        if (br.kind == BufferRun.Kind.WHITESPACE && (sz = this.runs.size()) > 0) {
            BufferRun last = this.runs.get(sz - 1);
            if (last.kind == BufferRun.Kind.WHITESPACE && last.end == br.start) {
                last.end = br.end;
                return;
            }
        }
        this.runs.add(br);
    }

    @Override
    public Iterator<BufferRun> iterator() {
        return new Iterator<BufferRun>(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < BufferRunQueue.this.runs.size();
            }

            @Override
            public BufferRun next() {
                return BufferRunQueue.this.get(this.next++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.runs.size();
    }

    public BufferRun get(int i) {
        return this.runs.get(i);
    }

    public int findRunStartingAt(int start) {
        Integer index = (Integer)this.positionMap.get(start);
        return index == null ? -1 : index;
    }

    public int findRunEndingWith(int end) {
        Integer index = (Integer)this.endPositionMap.get(end);
        return index == null ? -1 : index;
    }

    public BufferRun[] toArray() {
        return this.runs.toArray(new BufferRun[0]);
    }

    public void reset() {
        this.next = 0;
    }

    public int getPos() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next < this.runs.size();
    }

    public BufferRun peekNext() {
        return this.next < this.runs.size() ? this.runs.get(this.next) : null;
    }

    public BufferRun getNext() {
        return this.next < this.runs.size() ? this.runs.get(this.next++) : null;
    }

    public BufferRun getNextBefore(int offset) {
        BufferRun br;
        if (this.next < this.runs.size() && (br = this.runs.get(this.next)).getEnd() <= offset) {
            ++this.next;
            return br;
        }
        return null;
    }

    public void unget() {
        if (this.next > 0) {
            --this.next;
        }
    }
}

