/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.HashMap;

class VariableCharacterization {
    public static final int ASSIGN = 1;
    public static final int REFERENCE = 2;
    public static final int PARAMETER = 32;
    final HashMap<Object, CNode> map = new HashMap();

    public VariableCharacterization(Tree t) {
        new TreeScanner<Void, Tree>(){
            Symbol.TypeSymbol owner = null;

            @Override
            public Void visitIdentifier(IdentifierTree tree, Tree parent) {
                JCTree.JCIdent t = (JCTree.JCIdent)tree;
                Symbol sym = t.sym;
                this.checkBoth(t.name, sym, this.parentContext(tree, parent));
                return null;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Tree parent) {
                JCTree.JCFieldAccess t = (JCTree.JCFieldAccess)tree;
                this.checkBoth(t.name, t.sym, this.parentContext(tree, parent));
                super.visitMemberSelect(tree, parent);
                return null;
            }

            @Override
            public Void visitNewClass(NewClassTree tree, Tree parent) {
                this.checkBoth(null, ((JCTree.JCNewClass)tree).constructor, 0);
                super.visitNewClass(tree, parent);
                return null;
            }

            @Override
            public Void visitVariable(VariableTree tree, Tree parent) {
                int flags = 0;
                if (parent != null && (parent.getKind() == Tree.Kind.METHOD || parent.getKind() == Tree.Kind.CATCH)) {
                    flags |= 0x20;
                }
                JCTree.JCVariableDecl t = (JCTree.JCVariableDecl)tree;
                this.checkBoth(t.name, t.sym, flags);
                super.visitVariable(tree, parent);
                return null;
            }

            @Override
            public Void visitMethod(MethodTree tree, Tree parent) {
                Symbol.TypeSymbol oldOwner = this.owner;
                JCTree.JCMethodDecl t = (JCTree.JCMethodDecl)tree;
                if (t.sym != null) {
                    this.owner = (Symbol.TypeSymbol)t.sym.owner;
                }
                super.visitMethod(tree, parent);
                this.owner = oldOwner;
                return null;
            }

            @Override
            public Void visitClass(ClassTree tree, Tree parent) {
                Symbol.TypeSymbol oldOwner = this.owner;
                JCTree.JCClassDecl t = (JCTree.JCClassDecl)tree;
                if (t.sym != null && t.sym.owner instanceof Symbol.TypeSymbol) {
                    this.owner = (Symbol.TypeSymbol)t.sym.owner;
                }
                super.visitClass(tree, parent);
                this.owner = oldOwner;
                return null;
            }

            int parentContext(Tree tree, Tree parent) {
                if (parent == null) {
                    return 0;
                }
                int tag = ((JCTree)parent).tag;
                if (74 <= tag && tag <= 90 ? ((JCTree.JCAssignOp)parent).lhs == tree : tag == 30 && ((JCTree.JCAssign)parent).lhs == tree) {
                    return 1;
                }
                return 2;
            }

            private void checkBoth(Name name, Symbol sym, int flags) {
                if (name != null) {
                    this.checkOne(name, flags);
                }
                if (sym != null) {
                    this.checkOne(sym, flags);
                }
            }

            private boolean checkOne(Object key, int flags) {
                CNode c = VariableCharacterization.this.map.get(key);
                if (c == null) {
                    c = new CNode();
                    VariableCharacterization.this.map.put(key, c);
                    c.usage |= flags;
                    return true;
                }
                c.usage |= flags;
                return false;
            }
        }.scan(t, null);
    }

    private int usage(Object s) {
        CNode cn = this.map.get(s);
        return cn == null ? 0 : cn.usage;
    }

    public final boolean assigned(Object s) {
        return (this.usage(s) & 1) != 0;
    }

    public final boolean referenced(Object s) {
        return (this.usage(s) & 2) != 0;
    }

    public final boolean parameter(Object s) {
        return (this.usage(s) & 0x20) != 0;
    }

    private static class CNode {
        int usage;

        private CNode() {
        }
    }
}

