/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.source.classpath.GlobalSourcePath;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheClassPath
implements ClassPathImplementation,
PropertyChangeListener {
    private final ClassPath cp;
    private final boolean translate;
    private final boolean isBoot;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private List<PathResourceImplementation> cache;

    private CacheClassPath(ClassPath cp, boolean translate, boolean isBoot) {
        this.cp = cp;
        this.translate = translate;
        this.isBoot = isBoot;
        this.cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cp));
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("entries".equals(event.getPropertyName())) {
            CacheClassPath cacheClassPath = this;
            synchronized (cacheClassPath) {
                this.cache = null;
            }
            this.listeners.firePropertyChange("resources", null, null);
        }
    }

    public synchronized List<? extends PathResourceImplementation> getResources() {
        block17: {
            if (this.cache != null) break block17;
            List entries = this.cp.entries();
            this.cache = new LinkedList<PathResourceImplementation>();
            if (this.isBoot && entries.size() == 0) {
                JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
                assert (defaultPlatform != null);
                entries = defaultPlatform.getBootstrapLibraries().entries();
                assert (entries.size() > 0);
                for (ClassPath.Entry entry : entries) {
                    this.cache.add(ClassPathSupport.createResource((URL)entry.getURL()));
                }
            } else {
                GlobalSourcePath gsp = GlobalSourcePath.getDefault();
                for (ClassPath.Entry entry : entries) {
                    URL foo;
                    FileObject fo;
                    URL url = entry.getURL();
                    URL[] sourceUrls = this.translate ? gsp.getSourceRootForBinaryRoot(url, this.cp, true) : new URL[]{url};
                    if (sourceUrls != null) {
                        for (URL sourceUrl : sourceUrls) {
                            try {
                                File cacheFolder = Index.getClassFolder(sourceUrl);
                                URL cacheUrl = cacheFolder.toURI().toURL();
                                if (!cacheFolder.exists()) {
                                    cacheUrl = new URL(cacheUrl.toExternalForm() + "/");
                                }
                                this.cache.add(ClassPathSupport.createResource((URL)cacheUrl));
                            }
                            catch (IOException ioe) {
                                ErrorManager.getDefault().notify((Throwable)ioe);
                            }
                        }
                        continue;
                    }
                    if ("jar".equals(url.getProtocol())) {
                        FileObject fo2;
                        URL foo2 = FileUtil.getArchiveFile((URL)url);
                        if (!"file".equals(foo2.getProtocol()) && (fo2 = URLMapper.findFileObject((URL)foo2)) != null && "file".equals((foo2 = URLMapper.findURL((FileObject)fo2, (int)1)).getProtocol())) {
                            url = FileUtil.getArchiveRoot((URL)foo2);
                        }
                    } else if (!"file".equals(url.getProtocol()) && (fo = URLMapper.findFileObject((URL)url)) != null && "file".equals((foo = URLMapper.findURL((FileObject)fo, (int)1)).getProtocol())) {
                        url = foo;
                    }
                    try {
                        File sigs = Index.getClassFolder(url);
                        this.cache.add(ClassPathSupport.createResource((URL)sigs.toURI().toURL()));
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    this.cache.add(ClassPathSupport.createResource((URL)url));
                }
            }
        }
        return this.cache;
    }

    public static ClassPath forClassPath(ClassPath cp) {
        assert (cp != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(cp, true, false));
    }

    public static ClassPath forBootPath(ClassPath cp) {
        assert (cp != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(cp, true, true));
    }

    public static ClassPath forSourcePath(ClassPath sourcePath) {
        assert (sourcePath != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(sourcePath, false, false));
    }
}

