/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.FileObjects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderArchive
implements Archive {
    final File root;

    public FolderArchive(File root) {
        assert (root != null);
        this.root = root;
    }

    @Override
    public Iterable<JavaFileObject> getFiles(String folderName, ClassPath.Entry entry, JavaFileFilterImplementation filter) throws IOException {
        File[] content;
        File folder;
        assert (folderName != null);
        if (folderName.length() > 0) {
            folderName = folderName + '/';
        }
        if ((entry == null || entry.includes(folderName)) && (folder = new File(this.root, folderName.replace('/', File.separatorChar))).canRead() && (content = folder.listFiles()) != null) {
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>(content.length);
            for (File f : content) {
                if (!f.isFile() || entry != null && !entry.includes(f.toURI().toURL())) continue;
                result.add(FileObjects.fileFileObject(f, this.root, filter));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    @Override
    public void clear() {
    }
}

