/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.OutputFileObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class OutputFileManager
extends CachingFileManager {
    private static boolean debug = Boolean.getBoolean("org.netbeans.modules.java.source.parsing.OutputFileManager.debug");
    private ClassPath scp;

    public OutputFileManager(CachingArchiveProvider provider, ClassPath outputClassPath, ClassPath sourcePath) {
        super(provider, outputClassPath, false, true);
        assert (sourcePath != null && outputClassPath != null);
        this.scp = sourcePath;
    }

    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, javax.tools.FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        if (kind != JavaFileObject.Kind.CLASS) {
            throw new IllegalArgumentException();
        }
        int index = sibling != null ? this.getActiveRoot(sibling) : this.getActiveRoot(FileObjects.convertPackage2Folder(className));
        assert (index >= 0) : "class: " + className + " sibling: " + sibling + " srcRoots: " + this.scp + " cacheRoots: " + this.cp;
        assert (index < this.cp.entries().size()) : "index " + index + " class: " + className + " sibling: " + sibling + " srcRoots: " + this.scp + " cacheRoots: " + this.cp;
        File activeRoot = new File(URI.create(((ClassPath.Entry)this.cp.entries().get(index)).getURL().toExternalForm()));
        String baseName = className.replace('.', File.separatorChar);
        String nameStr = baseName + '.' + "sig";
        int nameComponentIndex = nameStr.lastIndexOf(File.separatorChar);
        if (nameComponentIndex != -1) {
            String pathComponent = nameStr.substring(0, nameComponentIndex);
            new File(activeRoot, pathComponent).mkdirs();
        } else {
            activeRoot.mkdirs();
        }
        File f = FileUtil.normalizeFile((File)new File(activeRoot, nameStr));
        return OutputFileObject.create(activeRoot, f);
    }

    public javax.tools.FileObject getFileForOutput(JavaFileManager.Location l, String pkgName, String relativeName, javax.tools.FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        assert (pkgName != null);
        assert (relativeName != null);
        if (sibling == null) {
            throw new IllegalArgumentException("sibling == null");
        }
        int index = this.getActiveRoot(sibling);
        assert (index >= 0 && index < this.cp.entries().size());
        File activeRoot = new File(URI.create(((ClassPath.Entry)this.cp.entries().get(index)).getURL().toExternalForm()));
        File folder = pkgName.length() == 0 ? activeRoot : new File(activeRoot, FileObjects.convertPackage2Folder(pkgName));
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IOException();
        }
        File file = new File(folder, relativeName);
        return OutputFileObject.create(activeRoot, file);
    }

    private int getActiveRoot(javax.tools.FileObject file) throws IOException {
        if (this.scp.entries().size() == 1) {
            return 0;
        }
        Iterator it = this.scp.entries().iterator();
        int i = 0;
        while (it.hasNext()) {
            URL rootUrl = ((ClassPath.Entry)it.next()).getURL();
            if (this.isParentOf(rootUrl, file.toUri().toURL())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isParentOf(URL folder, URL file) throws IOException {
        assert (folder != null && file != null);
        return file.toExternalForm().startsWith(folder.toExternalForm());
    }

    private int getActiveRoot(String baseName) {
        String name;
        if (this.scp.entries().size() == 1) {
            return 0;
        }
        String parent = null;
        int index = baseName.lastIndexOf(47);
        if (index < 0) {
            name = baseName;
        } else {
            parent = baseName.substring(0, index);
            name = baseName.substring(index + 1);
        }
        index = name.indexOf(36);
        if (index > 0) {
            name = name.substring(0, index);
        }
        Iterator it = this.scp.entries().iterator();
        int i = 0;
        while (it.hasNext()) {
            FileObject parentFile;
            FileObject root = ((ClassPath.Entry)it.next()).getRoot();
            if (root != null && (parentFile = root.getFileObject(parent)) != null && parentFile.getFileObject(name, "java") != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean debug(String message) {
        if (debug) {
            Logger.getLogger("global").log(Level.INFO, message);
        }
        return true;
    }
}

