/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.query;

import com.sun.source.tree.Tree;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.source.query.Command;
import org.netbeans.modules.java.source.query.NodeScanner;
import org.netbeans.modules.java.source.query.QueryEnvironment;
import org.netbeans.modules.java.source.query.QueryException;
import org.netbeans.modules.java.source.query.ResultTableModel;
import org.netbeans.modules.java.source.query.SearchResult;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query<R, P>
extends NodeScanner<R, P>
implements Command {
    protected SearchResult result = null;
    protected String queryDescription = null;
    static final Logger logger = Logger.getLogger("org.netbeans.modules.java.source");
    public static final int NOPOS = -2;

    @Override
    public void init() {
        this.result = new SearchResult(this, this.getQueryDescription());
    }

    @Override
    public void attach(QueryEnvironment env) {
        super.attach(env);
        this.result.attach(env);
    }

    @Override
    public void release() {
        super.release();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.result = null;
    }

    @Override
    public void apply() {
        this.apply(this.getRootNode());
        this.show(this.result, this.getQueryDescription());
    }

    public void apply(Tree t) {
        if (t != null) {
            t.accept(this, null);
        }
    }

    private void showNoResults() {
        String fmt = this.getString("Query.noResults");
        String msg = MessageFormat.format(fmt, this.queryDescription);
        logger.log(Level.INFO, msg);
        this.env.setStatusMessage(msg);
    }

    private String getString(String key) {
        return NbBundle.getBundle(Query.class).getString(key);
    }

    public final void error(Object o) {
        throw new QueryException(o.toString());
    }

    public final void error(Throwable t) {
        throw new QueryException(t);
    }

    public final void note(String s) {
        this.env.setStatusMessage(s);
    }

    public final void show(SearchResult sr, String title) {
        if (this.result != null && this.result.size() > 0) {
            this.env.setResult(sr, title);
        } else {
            this.showNoResults();
        }
    }

    public final void show(ResultTableModel[] result, String title) {
        if (result != null && result.length > 0) {
            this.env.setResult(result, title);
        } else {
            this.showNoResults();
        }
    }

    public String getQueryDescription() {
        return this.queryDescription != null ? this.queryDescription : "Unnamed Query";
    }

    public void setQueryDescription(String description) {
        this.queryDescription = description;
    }

    protected Tree getRootNode() {
        return this.env.getRootNode();
    }
}

