/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.query;

import com.sun.source.tree.Tree;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.java.source.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchEntry
implements Comparable<SearchEntry> {
    public Query query;
    public Tree tree;
    private int pos;
    public Element sym;
    public String className;
    public String methName;
    public String symName;
    public String note;
    public int flags;

    public SearchEntry(Query q, Element e, Tree t, int pos) {
        this(q, e, t, pos, null);
    }

    public SearchEntry(Query q, Element e, Tree t, int pos, String n) {
        this(q, e, t, pos, n, 0);
    }

    public SearchEntry(Query q, Element e, Tree t, int pos, String n, int f) {
        this.query = q;
        this.flags = f;
        this.sym = e;
        this.tree = t;
        this.pos = pos;
        if (n != null && n.length() > 0) {
            this.note = n;
        }
        if (e == null) {
            this.className = "Unknown";
            this.methName = "Unknown";
        } else if (e instanceof TypeElement) {
            this.className = this.classSymbolName(this.sym);
        } else {
            while (e.getEnclosingElement() != null && !(e.getEnclosingElement() instanceof TypeElement)) {
                e = e.getEnclosingElement();
            }
            this.className = e.getEnclosingElement() == null ? "NULL PARENT" : this.classSymbolName(e);
            this.methName = e.getSimpleName().toString();
            if (e != this.sym) {
                this.symName = this.sym.getSimpleName().toString();
            }
        }
    }

    private String classSymbolName(Element e) {
        if (e == null || e instanceof PackageElement) {
            return "";
        }
        if (!(e instanceof TypeElement)) {
            return this.classSymbolName(e.getEnclosingElement());
        }
        String owner = this.classSymbolName(e.getEnclosingElement());
        String name = e.getSimpleName().toString();
        if (name.length() == 0) {
            name = ((Object)e.asType()).toString();
        }
        return owner.length() > 0 ? owner + '.' + name : name;
    }

    @Override
    public int compareTo(SearchEntry oe) {
        int ret = this.className.compareTo(oe.className);
        if (ret == 0 && (this.methName == null || oe.methName == null || (ret = this.methName.compareTo(oe.methName)) == 0) && this.tree != null) {
            ret = this.pos - oe.pos;
        }
        return ret;
    }

    public String getSymName() {
        return this.symName == null ? "" : this.symName;
    }

    public String getNote() {
        return this.note == null ? "" : this.note;
    }

    public Element getElement() {
        return this.sym;
    }
}

