/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.query;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.ListSelectionModel;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.DefaultSourceSelection;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.engine.TreeFinder;
import org.netbeans.modules.java.source.query.Query;
import org.netbeans.modules.java.source.query.QueryEnvironment;
import org.netbeans.modules.java.source.query.QueryResult;
import org.netbeans.modules.java.source.query.QueryResultTableModel;
import org.netbeans.modules.java.source.query.SearchEntry;
import org.netbeans.modules.java.source.query.SourceSelection;
import org.netbeans.modules.java.source.save.SourceBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResult
extends QueryResultTableModel {
    protected QueryEnvironment env;
    protected ASTModel model;
    private SearchEntry[] results;
    protected List<SearchEntry> sorted = new ArrayList<SearchEntry>();
    private boolean changed;
    boolean hasmeth = false;
    boolean hasnote = false;
    boolean hassym = false;
    private int ncols = -1;
    private String[] columnNames;
    static final long serialVersionUID = -4851462993177602438L;

    private void changed() {
        this.results = null;
        this.changed = true;
    }

    public SearchResult(Query query, String t) {
        super(query, t);
    }

    public void attach(QueryEnvironment env) {
        this.env = env;
        this.model = ((EngineEnvironment)env).getModel();
    }

    public void release() {
        this.env = null;
        this.model = null;
    }

    public SearchEntry[] getResults() {
        if (this.results == null) {
            Collections.sort(this.sorted);
            this.results = this.sorted.toArray(new SearchEntry[this.sorted.size()]);
        }
        return this.results;
    }

    public final boolean add(SearchEntry e) {
        this.sorted.add(e);
        this.changed();
        return true;
    }

    public String asLogMessage(SearchEntry se) {
        StringBuffer sb = new StringBuffer();
        sb.append(se.className);
        if (se.methName != null) {
            sb.append('.');
            sb.append(se.methName);
        }
        if (se.note != null) {
            sb.append(" \"");
            sb.append(se.note);
            sb.append('\"');
        }
        return sb.toString();
    }

    public final void clear() {
        this.sorted.clear();
        this.changed();
    }

    public Iterator<SearchEntry> iterator() {
        return new Iterator<SearchEntry>(){
            private int pos = 0;
            private boolean deleted = false;
            {
                SearchResult.this.getResults();
            }

            @Override
            public boolean hasNext() {
                if (this.pos < SearchResult.this.results.length) {
                    return true;
                }
                if (this.deleted) {
                    SearchResult.access$002(SearchResult.this, null);
                }
                return false;
            }

            @Override
            public SearchEntry next() {
                return SearchResult.this.results[this.pos++];
            }

            @Override
            public void remove() {
                this.deleted = true;
                SearchResult.this.sorted.remove(SearchResult.this.results[this.pos - 1]);
            }
        };
    }

    public int getFlagsOr() {
        int flags = 0;
        SearchEntry[] r = this.getResults();
        int i = r.length;
        while (--i >= 0) {
            flags |= r[i].flags;
        }
        return flags;
    }

    public Element getSymbol(int row) {
        if (row < 0) {
            return null;
        }
        SearchEntry[] results = this.getResults();
        if (results == null || row >= results.length) {
            return null;
        }
        return results[row].sym;
    }

    public int getFlagsMask() {
        int mask = 0;
        SearchEntry[] r = this.getResults();
        int i = r.length;
        while (--i >= 0) {
            mask |= 1 << r[i].flags;
        }
        return mask;
    }

    public final void done() {
        if (this.changed) {
            this.changed = false;
            this.results = null;
            this.fireTableStructureChanged();
        }
    }

    @Override
    public final int getRowCount() {
        return this.getResults().length;
    }

    @Override
    public final int getResultCount() {
        return this.getRowCount();
    }

    @Override
    public QueryResult getResult(ListSelectionModel lsm) {
        int selectedRow = lsm.getMinSelectionIndex();
        return selectedRow < this.getRowCount() ? this.getResult(selectedRow) : null;
    }

    @Override
    public QueryResult getResult(int row) {
        final SearchEntry se = this.getResults()[row];
        return new QueryResult(){

            public String getQueryDescription() {
                return se.query.getQueryDescription();
            }

            public SourceSelection getSourceSelection() {
                return SearchResult.this.makeSelection(se.getElement(), se.tree, SearchResult.this.env.getRootNode());
            }

            public String getNote() {
                return se.getNote();
            }
        };
    }

    protected SourceSelection makeSelection(Element sym, Tree tree, Tree root) {
        if (tree == null) {
            tree = this.env.getTrees().getTree(sym);
        }
        final CompilationUnitTree topL = this.getTopLevel(sym, tree, root);
        int start = this.model.getStartPos(tree);
        int end = this.model.getEndPos(tree, topL);
        String path = topL.getSourceFile().toUri().getPath();
        return new DefaultSourceSelection(sym, start, this.model.getPos(tree), end, path){

            public String getSource() {
                return SearchResult.this.fromSource(topL);
            }
        };
    }

    protected String fromSource(CompilationUnitTree tl) {
        String srcFile = tl.getSourceFile().toUri().getPath();
        try {
            SourceBuffer src = new SourceBuffer(srcFile);
            return src.getString(0, src.length());
        }
        catch (IOException e) {
            assert (false) : "source file not found: " + srcFile;
            return "";
        }
    }

    protected CompilationUnitTree getTopLevel(Element sym, Tree tree, Tree root) {
        final TypeElement outerClass = this.env.getElementUtilities().outermostTypeElement(sym);
        if (outerClass == null) {
            return this.model.getTopLevel(tree);
        }
        Element pkg = outerClass.getEnclosingElement();
        assert (pkg != null);
        final CompilationUnitTree[] rtn = new CompilationUnitTree[1];
        root.accept(new TreeFinder(tree){

            public Boolean visitCompilationUnit(CompilationUnitTree tree, Object o) {
                if (!this.found && ((Boolean)this.scan(tree.getTypeDecls(), o)).booleanValue()) {
                    rtn[0] = tree;
                }
                return this.found;
            }

            public Boolean visitClass(ClassTree tree, Object o) {
                if (!this.found && ((Object)SearchResult.this.model.getElement(tree)).equals(outerClass)) {
                    this.found = true;
                }
                return this.found;
            }
        }, null);
        assert (rtn[0] != null);
        return rtn[0];
    }

    @Override
    public int getColumnCount() {
        if (this.ncols == -1) {
            SearchEntry[] r = this.getResults();
            int i = r.length;
            while (--i >= 0) {
                if (r[i].methName != null) {
                    this.hasmeth = true;
                }
                if (r[i].note != null) {
                    this.hasnote = true;
                    continue;
                }
                if (r[i].symName == null) continue;
                this.hassym = true;
            }
            this.ncols = 1;
            if (this.hasmeth) {
                ++this.ncols;
            }
            if (this.hasnote) {
                ++this.ncols;
            }
            if (this.hassym) {
                ++this.ncols;
            }
        }
        return this.ncols;
    }

    @Override
    public String getColumnName(int column) {
        if (this.columnNames == null) {
            this.columnNames = new String[this.ncols];
            this.columnNames[0] = "Class";
            int i = 1;
            if (this.hasmeth) {
                this.columnNames[i++] = "Member";
            }
            if (this.hassym) {
                this.columnNames[i++] = "Symbol";
            }
            if (this.hasnote) {
                this.columnNames[i] = "Notes";
            }
        }
        assert (column < this.columnNames.length) : "column=" + Integer.toString(column);
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        SearchEntry e = this.getResults()[row];
        switch (column) {
            case 0: {
                return e.className;
            }
            case 1: {
                if (this.hasmeth) {
                    return e.methName;
                }
                if (this.hassym) {
                    return e.getSymName();
                }
                if (!this.hasnote) break;
                return e.getNote();
            }
            case 2: {
                if (this.hassym) {
                    return e.getSymName();
                }
                if (!this.hasnote) break;
                return e.getNote();
            }
            case 3: {
                return e.getNote();
            }
        }
        return "Bug!!";
    }

    public String toString() {
        int cols = this.getColumnCount();
        int rows = this.getRowCount();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                sb.append(this.getColumnName(j));
                sb.append('=');
                sb.append(this.getValueAt(i, j));
                if (j + 1 >= cols) continue;
                sb.append(", ");
            }
            if (i + 1 >= rows) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public int size() {
        return this.getResults().length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object e) {
        return this.sorted.contains(e);
    }

    public Object[] toArray() {
        return this.getResults();
    }

    public <E> boolean containsAll(Collection<E> c) {
        return this.sorted.containsAll(c);
    }

    public boolean remove(Object e) {
        this.changed();
        return this.sorted.remove(e);
    }

    public <E> boolean removeAll(Collection<E> c) {
        this.changed();
        return this.sorted.removeAll(c);
    }

    public <E> boolean retainAll(Collection<E> c) {
        this.changed();
        return this.sorted.retainAll(c);
    }

    public <E extends SearchEntry> boolean addAll(Collection<E> c) {
        Iterator<E> i = c.iterator();
        while (i.hasNext()) {
            this.add((SearchEntry)i.next());
        }
        return true;
    }

    static /* synthetic */ SearchEntry[] access$002(SearchResult x0, SearchEntry[] x1) {
        x0.results = x1;
        return x1;
    }

    static interface SourceMaker {
        public String getSource();
    }
}

