/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.query;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import java.util.List;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.query.QueryEnvironment;
import org.netbeans.modules.java.source.transform.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMatcher
implements TreeVisitor<Void, Tree> {
    protected boolean matches;
    protected ASTModel model;

    public TreeMatcher(QueryEnvironment env) {
        this.model = ((EngineEnvironment)env).getModel();
    }

    public boolean matches(Tree a, Tree b) {
        this.matches = true;
        this.match(a, b);
        return this.matches;
    }

    public boolean matches(List<? extends Tree> a, List<? extends Tree> b) {
        this.matches = true;
        int n = a.size();
        if (n != b.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.matches(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    private void match(Tree tree, Tree other) {
        if (this.matches) {
            if ((tree = Transformer.deblock(tree)) != null && (other = Transformer.deblock(other)) != null) {
                if (tree.getKind() != other.getKind()) {
                    this.matches = false;
                } else {
                    tree.accept(this, other);
                }
            } else if (other != tree) {
                this.matches = false;
            }
        }
    }

    private void match(List<? extends Tree> a, List<? extends Tree> b) {
        if (!this.matches) {
            return;
        }
        if (a == null && b == null) {
            return;
        }
        if (a == null || b == null) {
            this.matches = false;
            return;
        }
        int n = a.size();
        if (n != b.size()) {
            this.matches = false;
            return;
        }
        for (int i = 0; i < n && this.matches; ++i) {
            this.match(a.get(i), b.get(i));
        }
    }

    private void match(CharSequence s1, CharSequence s2) {
        this.matches = this.matches && s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree tree, Tree p) {
        CompilationUnitTree other = (CompilationUnitTree)p;
        this.match(tree.getPackageAnnotations(), other.getPackageAnnotations());
        this.match(tree.getPackageName(), other.getPackageName());
        this.match(tree.getImports(), other.getImports());
        this.match(tree.getTypeDecls(), other.getTypeDecls());
        return null;
    }

    @Override
    public Void visitImport(ImportTree tree, Tree p) {
        ImportTree other = (ImportTree)p;
        this.match(tree.getQualifiedIdentifier(), other.getQualifiedIdentifier());
        return null;
    }

    @Override
    public Void visitClass(ClassTree tree, Tree p) {
        ClassTree other = (ClassTree)p;
        this.match(tree.getSimpleName(), other.getSimpleName());
        this.match(tree.getModifiers(), other.getModifiers());
        this.match(tree.getTypeParameters(), other.getTypeParameters());
        this.match(tree.getExtendsClause(), other.getExtendsClause());
        this.match(tree.getImplementsClause(), other.getImplementsClause());
        this.match(tree.getMembers(), other.getMembers());
        return null;
    }

    @Override
    public Void visitMethod(MethodTree tree, Tree p) {
        MethodTree other = (MethodTree)p;
        this.match(tree.getName(), other.getName());
        this.match(tree.getModifiers(), other.getModifiers());
        this.match(tree.getTypeParameters(), other.getTypeParameters());
        this.match(tree.getParameters(), other.getParameters());
        this.match(tree.getReturnType(), other.getReturnType());
        this.match(tree.getThrows(), other.getThrows());
        this.match(tree.getDefaultValue(), other.getDefaultValue());
        this.match(tree.getBody(), other.getBody());
        return null;
    }

    @Override
    public Void visitVariable(VariableTree tree, Tree p) {
        VariableTree other = (VariableTree)p;
        this.match(tree.getName(), other.getName());
        this.match(tree.getModifiers(), other.getModifiers());
        this.match(tree.getType(), other.getType());
        this.match(tree.getInitializer(), other.getInitializer());
        return null;
    }

    @Override
    public Void visitAnnotation(AnnotationTree tree, Tree p) {
        AnnotationTree other = (AnnotationTree)p;
        this.match(tree.getAnnotationType(), other.getAnnotationType());
        this.match(tree.getArguments(), other.getArguments());
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree tree, Tree p) {
        MethodInvocationTree other = (MethodInvocationTree)p;
        this.match(tree.getMethodSelect(), other.getMethodSelect());
        this.match(tree.getTypeArguments(), other.getTypeArguments());
        this.match(tree.getArguments(), other.getArguments());
        return null;
    }

    @Override
    public Void visitAssert(AssertTree tree, Tree p) {
        AssertTree other = (AssertTree)p;
        this.match(tree.getCondition(), other.getCondition());
        this.match(tree.getDetail(), other.getDetail());
        return null;
    }

    @Override
    public Void visitAssignment(AssignmentTree tree, Tree p) {
        AssignmentTree other = (AssignmentTree)p;
        this.match(tree.getVariable(), other.getVariable());
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree tree, Tree p) {
        CompoundAssignmentTree other = (CompoundAssignmentTree)p;
        this.match(tree.getVariable(), other.getVariable());
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitBinary(BinaryTree tree, Tree p) {
        BinaryTree other = (BinaryTree)p;
        this.match(tree.getLeftOperand(), other.getLeftOperand());
        this.match(tree.getRightOperand(), other.getRightOperand());
        return null;
    }

    @Override
    public Void visitBlock(BlockTree tree, Tree p) {
        BlockTree other = (BlockTree)p;
        this.match(tree.getStatements(), other.getStatements());
        this.matches = this.matches && tree.isStatic() == other.isStatic();
        return null;
    }

    @Override
    public Void visitBreak(BreakTree tree, Tree p) {
        BreakTree other = (BreakTree)p;
        this.match(tree.getLabel(), other.getLabel());
        return null;
    }

    @Override
    public Void visitCase(CaseTree tree, Tree p) {
        CaseTree other = (CaseTree)p;
        this.match(tree.getExpression(), other.getExpression());
        this.match(tree.getStatements(), other.getStatements());
        return null;
    }

    @Override
    public Void visitCatch(CatchTree tree, Tree p) {
        CatchTree other = (CatchTree)p;
        this.match(tree.getParameter(), other.getParameter());
        this.match(tree.getBlock(), other.getBlock());
        return null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree tree, Tree p) {
        ConditionalExpressionTree other = (ConditionalExpressionTree)p;
        this.match(tree.getCondition(), other.getCondition());
        this.match(tree.getFalseExpression(), other.getFalseExpression());
        this.match(tree.getTrueExpression(), other.getTrueExpression());
        return null;
    }

    @Override
    public Void visitContinue(ContinueTree tree, Tree p) {
        ContinueTree other = (ContinueTree)p;
        this.match(tree.getLabel(), other.getLabel());
        return null;
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree tree, Tree p) {
        DoWhileLoopTree other = (DoWhileLoopTree)p;
        this.match(tree.getCondition(), other.getCondition());
        this.match(tree.getStatement(), other.getStatement());
        return null;
    }

    @Override
    public Void visitErroneous(ErroneousTree tree, Tree p) {
        return null;
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree tree, Tree p) {
        ExpressionStatementTree other = (ExpressionStatementTree)p;
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree tree, Tree p) {
        EnhancedForLoopTree other = (EnhancedForLoopTree)p;
        this.match(tree.getVariable(), other.getVariable());
        this.match(tree.getExpression(), other.getExpression());
        this.match(tree.getStatement(), other.getStatement());
        return null;
    }

    @Override
    public Void visitForLoop(ForLoopTree tree, Tree p) {
        ForLoopTree other = (ForLoopTree)p;
        this.match(tree.getInitializer(), other.getInitializer());
        this.match(tree.getCondition(), other.getCondition());
        this.match(tree.getUpdate(), other.getUpdate());
        this.match(tree.getStatement(), other.getStatement());
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree tree, Tree p) {
        IdentifierTree other = (IdentifierTree)p;
        this.match(tree.getName(), other.getName());
        return null;
    }

    @Override
    public Void visitIf(IfTree tree, Tree p) {
        IfTree other = (IfTree)p;
        this.match(tree.getCondition(), other.getCondition());
        this.match(tree.getThenStatement(), other.getThenStatement());
        this.match(tree.getElseStatement(), other.getElseStatement());
        return null;
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree tree, Tree p) {
        ArrayAccessTree other = (ArrayAccessTree)p;
        this.match(tree.getExpression(), other.getExpression());
        this.match(tree.getIndex(), other.getIndex());
        return null;
    }

    @Override
    public Void visitLabeledStatement(LabeledStatementTree tree, Tree p) {
        LabeledStatementTree other = (LabeledStatementTree)p;
        this.match(tree.getLabel(), other.getLabel());
        this.match(tree.getStatement(), other.getStatement());
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree tree, Tree p) {
        LiteralTree other = (LiteralTree)p;
        Object v1 = tree.getValue();
        Object v2 = other.getValue();
        this.matches = this.matches && (v1 == null && v2 == null || v1 != null && v1.equals(v2));
        return null;
    }

    @Override
    public Void visitModifiers(ModifiersTree tree, Tree p) {
        ModifiersTree other = (ModifiersTree)p;
        this.matches = this.matches && ((Object)tree.getFlags()).equals(other.getFlags());
        this.match(tree.getAnnotations(), other.getAnnotations());
        return null;
    }

    @Override
    public Void visitNewArray(NewArrayTree tree, Tree p) {
        NewArrayTree other = (NewArrayTree)p;
        this.match(tree.getType(), other.getType());
        this.match(tree.getDimensions(), other.getDimensions());
        this.match(tree.getInitializers(), other.getInitializers());
        return null;
    }

    @Override
    public Void visitNewClass(NewClassTree tree, Tree p) {
        NewClassTree other = (NewClassTree)p;
        this.match(tree.getIdentifier(), other.getIdentifier());
        this.match(tree.getTypeArguments(), other.getTypeArguments());
        this.match(tree.getArguments(), other.getArguments());
        this.match(tree.getClassBody(), other.getClassBody());
        this.match(tree.getEnclosingExpression(), other.getEnclosingExpression());
        return null;
    }

    @Override
    public Void visitParenthesized(ParenthesizedTree tree, Tree p) {
        ParenthesizedTree other = (ParenthesizedTree)p;
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitReturn(ReturnTree tree, Tree p) {
        ReturnTree other = (ReturnTree)p;
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree tree, Tree p) {
        MemberSelectTree other = (MemberSelectTree)p;
        this.match(tree.getIdentifier(), other.getIdentifier());
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitEmptyStatement(EmptyStatementTree tree, Tree p) {
        return null;
    }

    @Override
    public Void visitSwitch(SwitchTree tree, Tree p) {
        SwitchTree other = (SwitchTree)p;
        this.match(tree.getCases(), other.getCases());
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitSynchronized(SynchronizedTree tree, Tree p) {
        SynchronizedTree other = (SynchronizedTree)p;
        this.match(tree.getBlock(), other.getBlock());
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitThrow(ThrowTree tree, Tree p) {
        ThrowTree other = (ThrowTree)p;
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitTry(TryTree tree, Tree p) {
        TryTree other = (TryTree)p;
        this.match(tree.getBlock(), other.getBlock());
        this.match(tree.getCatches(), other.getCatches());
        this.match(tree.getFinallyBlock(), other.getFinallyBlock());
        return null;
    }

    @Override
    public Void visitParameterizedType(ParameterizedTypeTree tree, Tree p) {
        ParameterizedTypeTree other = (ParameterizedTypeTree)p;
        this.match(tree.getType(), other.getType());
        this.match(tree.getTypeArguments(), other.getTypeArguments());
        return null;
    }

    @Override
    public Void visitArrayType(ArrayTypeTree tree, Tree p) {
        ArrayTypeTree other = (ArrayTypeTree)p;
        this.match(tree.getType(), other.getType());
        return null;
    }

    @Override
    public Void visitTypeCast(TypeCastTree tree, Tree p) {
        TypeCastTree other = (TypeCastTree)p;
        this.match(tree.getType(), other.getType());
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitPrimitiveType(PrimitiveTypeTree tree, Tree p) {
        PrimitiveTypeTree other = (PrimitiveTypeTree)p;
        this.matches = this.matches && tree.getPrimitiveTypeKind() == other.getPrimitiveTypeKind();
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree tree, Tree p) {
        TypeParameterTree other = (TypeParameterTree)p;
        this.match(tree.getName(), other.getName());
        this.match(tree.getBounds(), other.getBounds());
        return null;
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree tree, Tree p) {
        InstanceOfTree other = (InstanceOfTree)p;
        this.match(tree.getType(), other.getType());
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitUnary(UnaryTree tree, Tree p) {
        UnaryTree other = (UnaryTree)p;
        this.match(tree.getExpression(), other.getExpression());
        return null;
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree tree, Tree p) {
        WhileLoopTree other = (WhileLoopTree)p;
        this.match(tree.getCondition(), other.getCondition());
        this.match(tree.getStatement(), other.getStatement());
        return null;
    }

    @Override
    public Void visitWildcard(WildcardTree tree, Tree p) {
        WildcardTree other = (WildcardTree)p;
        this.match(tree.getBound(), other.getBound());
        return null;
    }

    @Override
    public Void visitOther(Tree tree, Tree p) {
        return null;
    }
}

