/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;

class Measure {
    static final Measure DEFAULT = new Measure();
    static final MethodMeasure METHOD = new MethodMeasure();
    static final VariableMeasure FIELD = new VariableMeasure();
    static final MemberMeasure MEMBER = new MemberMeasure();
    static final VariableMeasure PARAMETER = FIELD;
    static final ClassNameMeasure CLASS_NAME = new ClassNameMeasure();
    static final int INFINITE_DISTANCE = 1000;
    static final int OBJECTS_MATCH = 0;
    private static final StringMeasure STRING = new StringMeasure();

    Measure() {
    }

    int getDistance(Object first, Object second) {
        assert (first != null && second != null) : "Shouldn't pass null value!";
        if (first == second || first.equals(second)) {
            return 0;
        }
        return 1000;
    }

    private static final class ClassNameMeasure
    extends Measure {
        private ClassNameMeasure() {
        }

        public int getDistance(Object first, Object second) {
            if (first == second) {
                return 0;
            }
            if (first == null || second == null) {
                return 1000;
            }
            Tree t1 = (Tree)first;
            Tree t2 = (Tree)second;
            if (t1.getKind() == t2.getKind()) {
                return STRING.getDistance(t1.toString(), t2.toString());
            }
            return 1000;
        }
    }

    private static final class MemberMeasure
    extends Measure {
        private MemberMeasure() {
        }

        int getDistance(Object first, Object second) {
            int distance = DEFAULT.getDistance(first, second);
            if (distance == 1000) {
                JCTree t1 = (JCTree)first;
                JCTree t2 = (JCTree)second;
                if (t1.getKind() == t2.getKind() && t1.pos == t2.pos) {
                    return 500;
                }
            }
            return distance;
        }
    }

    private static final class MethodMeasure
    extends Measure {
        private static final int NAME_WEIGHT = 60;
        private static final int PARAMETERS_WEIGHT = 40;

        private MethodMeasure() {
        }

        int getDistance(Object first, Object second) {
            if (super.getDistance(first, second) == 0) {
                return 0;
            }
            int result = 100;
            Tree t1 = (Tree)first;
            Tree t2 = (Tree)second;
            if (t1.getKind() != Tree.Kind.METHOD || t2.getKind() != Tree.Kind.METHOD) {
                return 1000;
            }
            MethodTree tree1 = (MethodTree)first;
            MethodTree tree2 = (MethodTree)second;
            result = !"<init>".contentEquals(tree1.getName()) && !"<init>".contentEquals(tree2.getName()) ? (result += STRING.getDistance(tree1.getName().toString(), tree2.getName().toString()) * 60) : (result += 60000);
            Tree[] types1 = new Tree[tree1.getParameters().size()];
            Tree[] types2 = new Tree[tree2.getParameters().size()];
            int i = 0;
            for (VariableTree variableTree : tree1.getParameters()) {
                types1[i++] = variableTree.getType();
            }
            i = 0;
            for (VariableTree variableTree : tree2.getParameters()) {
                types2[i++] = variableTree.getType();
            }
            result += new OrderedArrayMeasure(CLASS_NAME).getDistance(types1, types2) * 40;
            return (result /= 100) > 1000 ? 1000 : result;
        }
    }

    private static final class OrderedArrayMeasure
    extends Measure {
        private final Measure measure;

        OrderedArrayMeasure(Measure elementsMeasure) {
            this.measure = elementsMeasure;
        }

        public int getDistance(Object first, Object second) {
            Object[] array1 = (Object[])first;
            Object[] array2 = (Object[])second;
            int minSize = Math.min(array1.length, array2.length);
            int difference = Math.abs(array1.length - array2.length);
            int result = 0;
            if (minSize == 0) {
                if (difference != 0) {
                    result = 1000;
                }
                return result;
            }
            for (int i = 0; i < minSize; ++i) {
                result += this.measure.getDistance(array1[i], array2[i]);
            }
            result += difference * 1000;
            return (result /= minSize + difference) > 1000 ? 1000 : result;
        }
    }

    private static final class StringMeasure
    extends Measure {
        private static final int SAME = 0;
        private static final int CASE_SAME = 1;
        private static final int DIFFERENT = 10;

        private StringMeasure() {
        }

        public final int getDistance(Object first, Object second) {
            if (first == second) {
                return 0;
            }
            if (first == null || second == null) {
                return 1000;
            }
            String x = (String)first;
            String y = (String)second;
            int xlen = x.length();
            int ylen = y.length();
            int errors = 0;
            int xindex = 0;
            int yindex = 0;
            char[] xarr = new char[xlen + 1];
            char[] yarr = new char[ylen + 1];
            x.getChars(0, xlen, xarr, 0);
            y.getChars(0, ylen, yarr, 0);
            while (xindex < xlen && yindex < ylen) {
                char xchar = xarr[xindex];
                char ychar = yarr[yindex];
                int cherr = StringMeasure.compareChars(xchar, ychar);
                if (cherr != 10) {
                    errors += cherr;
                    ++xindex;
                    ++yindex;
                    continue;
                }
                char xchar1 = xarr[xindex + 1];
                char ychar1 = yarr[yindex + 1];
                if (xchar1 != '\u0000' && ychar1 != '\u0000') {
                    int cherr1 = StringMeasure.compareChars(xchar1, ychar1);
                    if (cherr1 != 10) {
                        errors += 10 + cherr1;
                        xindex += 2;
                        yindex += 2;
                        continue;
                    }
                    int xerr = StringMeasure.compareChars(xchar, ychar1);
                    int xerr1 = StringMeasure.compareChars(xchar1, ychar);
                    if (xerr != 10 && xerr1 != 10) {
                        errors += 10 + xerr + xerr1;
                        xindex += 2;
                        yindex += 2;
                        continue;
                    }
                }
                if (xlen - xindex > ylen - yindex) {
                    ++xindex;
                } else if (xlen - xindex < ylen - yindex) {
                    ++yindex;
                } else {
                    ++xindex;
                    ++yindex;
                }
                errors += 10;
            }
            return 1000 * (errors += (xlen - xindex + ylen - yindex) * 10) / Math.max(ylen, xlen) / 10;
        }

        private static final int compareChars(char xc, char yc) {
            char ylower;
            if (xc == yc) {
                return 0;
            }
            char xlower = Character.toLowerCase(xc);
            return xlower == (ylower = Character.toLowerCase(yc)) ? 1 : 10;
        }
    }

    private static final class VariableMeasure
    extends Measure {
        private static final int NAME_WEIGHT = 40;
        private static final int TYPE_WEIGHT = 60;

        private VariableMeasure() {
        }

        public int getDistance(Object first, Object second) {
            if (super.getDistance(first, second) == 0) {
                return 0;
            }
            int result = 100;
            Tree t1 = (Tree)first;
            Tree t2 = (Tree)second;
            if (t1.getKind() != Tree.Kind.VARIABLE || t2.getKind() != Tree.Kind.VARIABLE) {
                return 1000;
            }
            VariableTree vt1 = (VariableTree)first;
            VariableTree vt2 = (VariableTree)second;
            int nameDist = STRING.getDistance(vt1.getName().toString(), vt2.getName().toString());
            int typeDist = CLASS_NAME.getDistance(vt1.getType(), vt2.getType());
            if (nameDist > 0 && typeDist > 0) {
                return 1000;
            }
            result += nameDist * 40;
            result += typeDist * 60;
            return (result /= 100) > 1000 ? 1000 : result;
        }
    }
}

