/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;

public class ModifiedTreeChecker
extends TreeScanner {
    boolean changed = false;
    private Symbol rootPackage;
    private CommentHandler comments;

    public ModifiedTreeChecker(Context context) {
        this.rootPackage = Symtab.instance((Context)context).rootPackage;
        this.comments = CommentHandlerService.instance(context);
    }

    public boolean isModified() {
        return this.changed;
    }

    private boolean checkTree(JCTree tree) {
        if (this.changed) {
            return false;
        }
        boolean bl = this.changed = tree.pos == -2;
        if (!this.changed && this.comments.hasComments(tree)) {
            CommentSet cs = this.comments.getComments(tree);
            this.changed = cs.hasChanges();
        }
        return !this.changed;
    }

    private boolean checkSymbol(Symbol sym) {
        if (this.changed) {
            return false;
        }
        this.changed = sym != null && ModifiedTreeChecker.symbolChanged(sym, this.rootPackage);
        return !this.changed;
    }

    private static boolean symbolChanged(Symbol sym, Symbol rootPackage) {
        Symbol owner;
        if (sym instanceof Symbol.PackageSymbol && (owner = sym.owner) != null && owner != rootPackage) {
            return ModifiedTreeChecker.symbolChanged(owner, rootPackage);
        }
        return false;
    }

    public void visitTopLevel(JCTree.JCCompilationUnit that) {
        if (this.checkTree(that) && this.checkSymbol(that.packge)) {
            super.visitTopLevel(that);
        }
    }

    public void visitImport(JCTree.JCImport that) {
        if (this.checkTree(that)) {
            super.visitImport(that);
        }
    }

    public void visitClassDef(JCTree.JCClassDecl that) {
        if (this.checkTree(that) && this.checkSymbol(that.sym)) {
            super.visitClassDef(that);
        }
    }

    public void visitMethodDef(JCTree.JCMethodDecl that) {
        if (this.checkTree(that) && this.checkSymbol(that.sym)) {
            super.visitMethodDef(that);
        }
    }

    public void visitVarDef(JCTree.JCVariableDecl that) {
        if (this.checkTree(that) && this.checkSymbol(that.sym)) {
            super.visitVarDef(that);
        }
    }

    public void visitSkip(JCTree.JCSkip that) {
        if (this.checkTree(that)) {
            super.visitSkip(that);
        }
    }

    public void visitBlock(JCTree.JCBlock that) {
        if (this.checkTree(that)) {
            super.visitBlock(that);
        }
    }

    public void visitDoLoop(JCTree.JCDoWhileLoop that) {
        if (this.checkTree(that)) {
            super.visitDoLoop(that);
        }
    }

    public void visitWhileLoop(JCTree.JCWhileLoop that) {
        if (this.checkTree(that)) {
            super.visitWhileLoop(that);
        }
    }

    public void visitForLoop(JCTree.JCForLoop that) {
        if (this.checkTree(that)) {
            super.visitForLoop(that);
        }
    }

    public void visitLabelled(JCTree.JCLabeledStatement that) {
        if (this.checkTree(that)) {
            super.visitLabelled(that);
        }
    }

    public void visitSwitch(JCTree.JCSwitch that) {
        if (this.checkTree(that)) {
            super.visitSwitch(that);
        }
    }

    public void visitCase(JCTree.JCCase that) {
        if (this.checkTree(that)) {
            super.visitCase(that);
        }
    }

    public void visitSynchronized(JCTree.JCSynchronized that) {
        if (this.checkTree(that)) {
            super.visitSynchronized(that);
        }
    }

    public void visitTry(JCTree.JCTry that) {
        if (this.checkTree(that)) {
            super.visitTry(that);
        }
    }

    public void visitCatch(JCTree.JCCatch that) {
        if (this.checkTree(that)) {
            super.visitCatch(that);
        }
    }

    public void visitConditional(JCTree.JCConditional that) {
        if (this.checkTree(that)) {
            super.visitConditional(that);
        }
    }

    public void visitIf(JCTree.JCIf that) {
        if (this.checkTree(that)) {
            super.visitIf(that);
        }
    }

    public void visitExec(JCTree.JCExpressionStatement that) {
        if (this.checkTree(that)) {
            super.visitExec(that);
        }
    }

    public void visitBreak(JCTree.JCBreak that) {
        if (this.checkTree(that)) {
            super.visitBreak(that);
        }
    }

    public void visitContinue(JCTree.JCContinue that) {
        if (this.checkTree(that)) {
            super.visitContinue(that);
        }
    }

    public void visitReturn(JCTree.JCReturn that) {
        if (this.checkTree(that)) {
            super.visitReturn(that);
        }
    }

    public void visitThrow(JCTree.JCThrow that) {
        if (this.checkTree(that)) {
            super.visitThrow(that);
        }
    }

    public void visitAssert(JCTree.JCAssert that) {
        if (this.checkTree(that)) {
            super.visitAssert(that);
        }
    }

    public void visitApply(JCTree.JCMethodInvocation that) {
        if (this.checkTree(that)) {
            super.visitApply(that);
        }
    }

    public void visitNewClass(JCTree.JCNewClass that) {
        if (this.checkTree(that) && this.checkSymbol(that.constructor)) {
            super.visitNewClass(that);
        }
    }

    public void visitNewArray(JCTree.JCNewArray that) {
        if (this.checkTree(that)) {
            super.visitNewArray(that);
        }
    }

    public void visitParens(JCTree.JCParens that) {
        if (this.checkTree(that)) {
            super.visitParens(that);
        }
    }

    public void visitAssign(JCTree.JCAssign that) {
        if (this.checkTree(that)) {
            super.visitAssign(that);
        }
    }

    public void visitAssignop(JCTree.JCAssignOp that) {
        if (this.checkTree(that)) {
            super.visitAssignop(that);
        }
    }

    public void visitUnary(JCTree.JCUnary that) {
        if (this.checkTree(that)) {
            super.visitUnary(that);
        }
    }

    public void visitBinary(JCTree.JCBinary that) {
        if (this.checkTree(that)) {
            super.visitBinary(that);
        }
    }

    public void visitTypeCast(JCTree.JCTypeCast that) {
        if (this.checkTree(that)) {
            super.visitTypeCast(that);
        }
    }

    public void visitTypeTest(JCTree.JCInstanceOf that) {
        if (this.checkTree(that)) {
            super.visitTypeTest(that);
        }
    }

    public void visitIndexed(JCTree.JCArrayAccess that) {
        if (this.checkTree(that)) {
            super.visitIndexed(that);
        }
    }

    public void visitSelect(JCTree.JCFieldAccess that) {
        if (this.checkTree(that) && this.checkSymbol(that.sym)) {
            super.visitSelect(that);
        }
    }

    public void visitIdent(JCTree.JCIdent that) {
        if (this.checkTree(that) && this.checkSymbol(that.sym)) {
            super.visitIdent(that);
        }
    }

    public void visitLiteral(JCTree.JCLiteral that) {
        if (this.checkTree(that)) {
            super.visitLiteral(that);
        }
    }

    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree that) {
        if (this.checkTree(that)) {
            super.visitTypeIdent(that);
        }
    }

    public void visitTypeArray(JCTree.JCArrayTypeTree that) {
        if (this.checkTree(that)) {
            super.visitTypeArray(that);
        }
    }

    public void visitTypeApply(JCTree.JCTypeApply that) {
        if (this.checkTree(that)) {
            super.visitTypeApply(that);
        }
    }

    public void visitTypeParameter(JCTree.JCTypeParameter that) {
        if (this.checkTree(that)) {
            super.visitTypeParameter(that);
        }
    }

    public void visitWildcard(JCTree.JCWildcard that) {
        if (this.checkTree(that)) {
            super.visitWildcard(that);
        }
    }

    public void visitErroneous(JCTree.JCErroneous that) {
        if (this.checkTree(that)) {
            super.visitErroneous(that);
        }
    }
}

