/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.source.tasklist.TaskCache;
import org.netbeans.modules.java.source.tasklist.TasklistSettings;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorAnnotator
extends AnnotationProvider {
    private Set<FileObject> knownFiles = new WeakSet();

    public String annotateName(String name, Set files) {
        return null;
    }

    public synchronized Image annotateIcon(Image icon, int iconType, Set files) {
        Project p;
        if (!TasklistSettings.isTasklistEnabled() || !TasklistSettings.isBadgesEnabled()) {
            return null;
        }
        boolean inError = false;
        if (files instanceof NonRecursiveFolder) {
            FileObject folder = ((NonRecursiveFolder)files).getFolder();
            inError = TaskCache.getDefault().isInError(folder, false);
            this.knownFiles.add(folder);
        } else {
            for (Object o : files) {
                if (!(o instanceof FileObject)) continue;
                FileObject f = (FileObject)o;
                if (f.isFolder()) {
                    this.knownFiles.add(f);
                    if (inError) continue;
                    if (TaskCache.getDefault().isInError(f, true)) {
                        inError = true;
                        continue;
                    }
                    p = FileOwnerQuery.getOwner((FileObject)f);
                    if (p == null) continue;
                    for (SourceGroup sg : ProjectUtils.getSources((Project)p).getSourceGroups("java")) {
                        FileObject sgRoot = sg.getRootFolder();
                        if (!FileUtil.isParentOf((FileObject)f, (FileObject)sgRoot) && f != sgRoot || !TaskCache.getDefault().isInError(sgRoot, true)) continue;
                        inError = true;
                        break;
                    }
                    if (!inError) continue;
                    break;
                }
                if (!f.isData() || !"java".equals(f.getExt())) continue;
                this.knownFiles.add(f);
                if (inError || !TaskCache.getDefault().isInError(f, true)) continue;
                inError = true;
            }
        }
        Logger.getLogger(ErrorAnnotator.class.getName()).log(Level.FINE, "files={0}, in error={1}", new Object[]{files, inError});
        if (inError) {
            Image i = Utilities.mergeImages((Image)icon, (Image)Utilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/error-badge.gif"), (int)0, (int)8);
            Iterator it = Lookup.getDefault().lookupAll(AnnotationProvider.class).iterator();
            boolean found = false;
            while (it.hasNext()) {
                p = (AnnotationProvider)it.next();
                if (found) {
                    Image res = p.annotateIcon(i, iconType, files);
                    if (res == null) continue;
                    return res;
                }
                found = p == this;
            }
            return i;
        }
        return null;
    }

    public String annotateNameHtml(String name, Set files) {
        return null;
    }

    public Action[] actions(Set files) {
        return null;
    }

    public InterceptionListener getInterceptionListener() {
        return null;
    }

    public void updateAllInError() {
        try {
            File[] roots;
            for (File root : roots = File.listRoots()) {
                FileObject rootFO = FileUtil.toFileObject((File)root);
                if (rootFO == null) continue;
                this.fireFileStatusChanged(new FileStatusEvent(rootFO.getFileSystem(), true, false));
            }
        }
        catch (FileStateInvalidException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public synchronized void updateInError(Set<URL> urls) {
        HashSet<FileObject> toRefresh = new HashSet<FileObject>();
        for (FileObject f : this.knownFiles) {
            try {
                if (!urls.contains(f.getURL())) continue;
                toRefresh.add(f);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        this.fireFileStatusChanged(toRefresh);
    }

    public void fireFileStatusChanged(Set<FileObject> fos) {
        if (fos.isEmpty()) {
            return;
        }
        try {
            this.fireFileStatusChanged(new FileStatusEvent(fos.iterator().next().getFileSystem(), fos, true, false));
        }
        catch (FileStateInvalidException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public static ErrorAnnotator getAnnotator() {
        for (AnnotationProvider ap : Lookup.getDefault().lookupAll(AnnotationProvider.class)) {
            if (ap.getClass() != ErrorAnnotator.class) continue;
            return (ErrorAnnotator)ap;
        }
        return null;
    }
}

