/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.source.tasklist.TaskCache;
import org.netbeans.modules.java.source.tasklist.TasklistSettings;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaTaskProvider
extends PushTaskScanner {
    private static final Logger LOG = Logger.getLogger(JavaTaskProvider.class.getName());
    private static JavaTaskProvider INSTANCE;
    private TaskScanningScope scope;
    private PushTaskScanner.Callback callback;
    private static final LinkedHashSet<Work> WORK_QUEUE;
    private static Map<FileObject, Set<FileObject>> root2FilesWithAttachedErrors;

    public JavaTaskProvider() {
        super("Java Errors", "Java compiler errors and warnings", null);
        INSTANCE = this;
    }

    private synchronized void refreshImpl(FileObject file) {
        LOG.log(Level.FINE, "refresh: {0}", file);
        if (this.scope == null || this.callback == null) {
            return;
        }
        if (!this.scope.isInScope(file)) {
            return;
        }
        LOG.log(Level.FINE, "enqueing work for: {0}", file);
        JavaTaskProvider.enqueue(new Work(file, this.callback));
    }

    public static void refresh(FileObject file) {
        if (INSTANCE != null) {
            INSTANCE.refreshImpl(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAll() {
        if (INSTANCE != null) {
            JavaTaskProvider javaTaskProvider = INSTANCE;
            synchronized (javaTaskProvider) {
                INSTANCE.setScope(JavaTaskProvider.INSTANCE.scope, JavaTaskProvider.INSTANCE.callback);
            }
        }
    }

    public synchronized void setScope(TaskScanningScope scope, PushTaskScanner.Callback callback) {
        JavaTaskProvider.cancelAllCurrent();
        this.scope = scope;
        this.callback = callback;
        if (scope == null || callback == null) {
            return;
        }
        for (FileObject file : scope.getLookup().lookupAll(FileObject.class)) {
            JavaTaskProvider.enqueue(new Work(file, callback));
        }
        for (Project p : scope.getLookup().lookupAll(Project.class)) {
            for (SourceGroup sg : ProjectUtils.getSources((Project)p).getSourceGroups("java")) {
                JavaTaskProvider.enqueue(new Work(sg.getRootFolder(), callback));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enqueue(Work w) {
        LinkedHashSet<Work> linkedHashSet = WORK_QUEUE;
        synchronized (linkedHashSet) {
            WORK_QUEUE.add(w);
            WORK_QUEUE.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelAllCurrent() {
        Object object = WORK_QUEUE;
        synchronized (object) {
            for (Work w : WORK_QUEUE) {
                w.cancel();
            }
            WORK_QUEUE.clear();
        }
        object = JavaTaskProvider.class;
        synchronized (JavaTaskProvider.class) {
            root2FilesWithAttachedErrors.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitWorkFinished() throws Exception {
        while (true) {
            LinkedHashSet<Work> linkedHashSet = WORK_QUEUE;
            synchronized (linkedHashSet) {
                if (WORK_QUEUE.isEmpty()) {
                    return;
                }
            }
            Thread.sleep(50L);
        }
    }

    private static Set<FileObject> getFilesWithAttachedErrors(FileObject root) {
        WeakSet result = root2FilesWithAttachedErrors.get(root);
        if (result == null) {
            result = new WeakSet();
            root2FilesWithAttachedErrors.put(root, (Set<FileObject>)result);
        }
        return result;
    }

    private static synchronized void updateErrorsInRoot(PushTaskScanner.Callback callback, FileObject root) {
        Set<FileObject> filesWithErrors = JavaTaskProvider.getFilesWithAttachedErrors(root);
        HashSet<FileObject> fixedFiles = new HashSet<FileObject>(filesWithErrors);
        HashSet<FileObject> nueFilesWithErrors = new HashSet<FileObject>();
        try {
            if (TasklistSettings.isTasklistEnabled()) {
                for (URL u : TaskCache.getDefault().getAllFilesWithRecord(root.getURL())) {
                    FileObject file = URLMapper.findFileObject((URL)u);
                    if (file == null) continue;
                    List<Task> result = TaskCache.getDefault().getErrors(file);
                    LOG.log(Level.FINE, "Setting {1} for {0}\n", new Object[]{file, result});
                    callback.setTasks(file, result);
                    if (fixedFiles.remove(file)) continue;
                    nueFilesWithErrors.add(file);
                }
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        for (FileObject f : fixedFiles) {
            LOG.log(Level.FINE, "Clearing errors for {0}", f);
            callback.setTasks(f, Collections.emptyList());
        }
        filesWithErrors.addAll(nueFilesWithErrors);
    }

    static {
        WORK_QUEUE = new LinkedHashSet();
        root2FilesWithAttachedErrors = new WeakHashMap<FileObject, Set<FileObject>>();
        new RequestProcessor("Java Task Provider").post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Work w = null;
                    LinkedHashSet linkedHashSet = WORK_QUEUE;
                    synchronized (linkedHashSet) {
                        while (WORK_QUEUE.isEmpty()) {
                            try {
                                WORK_QUEUE.wait();
                            }
                            catch (InterruptedException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                        Iterator it = WORK_QUEUE.iterator();
                        w = (Work)it.next();
                        it.remove();
                    }
                    FileObject file = w.getFileOrRoot();
                    LOG.log(Level.FINE, "dequeued work for: {0}", file);
                    ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
                    if (cp == null) {
                        LOG.log(Level.FINE, "cp == null");
                        return;
                    }
                    FileObject root = cp.findOwnerRoot(file);
                    if (file.isData()) {
                        List<Task> tasks = TaskCache.getDefault().getErrors(file);
                        Set filesWithErrors = JavaTaskProvider.getFilesWithAttachedErrors(root);
                        if (tasks.isEmpty()) {
                            filesWithErrors.remove(file);
                        } else {
                            filesWithErrors.add(file);
                        }
                        LOG.log(Level.FINE, "setting {1} for {0}", new Object[]{file, tasks});
                        w.getCallback().setTasks(file, tasks);
                        continue;
                    }
                    JavaTaskProvider.updateErrorsInRoot(w.getCallback(), root);
                }
            }
        });
    }

    private static final class Work {
        private FileObject fileOrRoot;
        private PushTaskScanner.Callback callback;
        private AtomicBoolean cancelled;

        public Work(FileObject fileOrRoot, PushTaskScanner.Callback callback) {
            this.fileOrRoot = fileOrRoot;
            this.callback = callback;
            this.cancelled = new AtomicBoolean(false);
        }

        public void cancel() {
            this.cancelled.set(true);
        }

        public boolean isCancelled() {
            return this.cancelled.get();
        }

        public FileObject getFileOrRoot() {
            return this.fileOrRoot;
        }

        public PushTaskScanner.Callback getCallback() {
            return this.callback;
        }
    }
}

