/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskCache {
    private static final Logger LOG = Logger.getLogger(TaskCache.class.getName());
    private static TaskCache theInstance;

    private TaskCache() {
    }

    public static TaskCache getDefault() {
        if (null == theInstance) {
            theInstance = new TaskCache();
        }
        return theInstance;
    }

    private String getTaskType(Diagnostic.Kind k) {
        switch (k) {
            case ERROR: {
                return "nb-tasklist-error";
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return "nb-tasklist-warning";
            }
        }
        return null;
    }

    public List<Task> getErrors(FileObject file) {
        return this.getErrors(file, false);
    }

    private List<Task> getErrors(FileObject file, boolean onlyErrors) {
        LOG.log(Level.FINE, "getErrors, file={0}", FileUtil.getFileDisplayName((FileObject)file));
        ArrayList<Task> result = new ArrayList<Task>();
        try {
            String line;
            File input = this.computePersistentFile(file);
            LOG.log(Level.FINE, "getErrors, error file={0}", input == null ? "null" : input.getAbsolutePath());
            if (input == null || !input.canRead()) {
                return Collections.emptyList();
            }
            input.getParentFile().mkdirs();
            BufferedReader pw = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8"));
            while ((line = pw.readLine()) != null) {
                String[] parts = line.split(":");
                Diagnostic.Kind kind = Diagnostic.Kind.valueOf(parts[0]);
                if (kind == null) continue;
                int lineNumber = Integer.parseInt(parts[1]);
                String message = parts[2];
                message = message.replaceAll("\\\\d", ":");
                message = message.replaceAll("\\\\n", " ");
                message = message.replaceAll("\\\\\\\\", "\\\\");
                String severity = this.getTaskType(kind);
                if (null == severity || onlyErrors && kind != Diagnostic.Kind.ERROR) continue;
                Task err = Task.create((FileObject)file, (String)severity, (String)message, (int)lineNumber);
                result.add(err);
            }
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Set<URL> dumpErrors(URL root, URL file, File fileFile, List<? extends Diagnostic> errors) throws IOException {
        Project p;
        void var9_11;
        File[] output = this.computePersistentFile(root, file);
        boolean containsErrors = false;
        if (!errors.isEmpty()) {
            output[1].getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output[1]), "UTF-8"));
            for (Diagnostic diagnostic : errors) {
                if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                    containsErrors = true;
                }
                pw.print((Object)diagnostic.getKind());
                pw.print(':');
                pw.print(diagnostic.getLineNumber());
                pw.print(':');
                String description = diagnostic.getMessage(null);
                description = description.replaceAll("\\\\", "\\\\\\\\");
                description = description.replaceAll("\n", "\\\\n");
                description = description.replaceAll(":", "\\\\d");
                pw.println(description);
            }
            pw.close();
        } else {
            output[1].delete();
        }
        HashSet<URL> toRefresh = new HashSet<URL>();
        toRefresh.add(file);
        File current = output[1].getParentFile();
        File file2 = fileFile.getParentFile();
        while (!output[0].equals(current)) {
            if (this.updateInErrorFolder(current, file, containsErrors, true)) {
                toRefresh.add(var9_11.toURL());
            }
            current = current.getParentFile();
            File file3 = var9_11.getParentFile();
        }
        if (this.updateInErrorFolder(current, file, containsErrors, true)) {
            toRefresh.add(var9_11.toURL());
        }
        this.updateInErrorFolder(output[1].getParentFile(), file, containsErrors, false);
        FileObject rootFO = URLMapper.findFileObject((URL)root);
        if (rootFO != null && (p = FileOwnerQuery.getOwner((FileObject)rootFO)) != null) {
            FileObject projectDirectory = p.getProjectDirectory();
            if (FileUtil.isParentOf((FileObject)projectDirectory, (FileObject)rootFO)) {
                for (FileObject currentFO = rootFO; currentFO != null && currentFO != projectDirectory; currentFO = currentFO.getParent()) {
                    toRefresh.add(currentFO.getURL());
                }
            }
            toRefresh.add(projectDirectory.getURL());
        }
        return toRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateInErrorFolder(File current, URL file, boolean inError, boolean recursive) throws IOException {
        boolean modified;
        File dep = this.getDep(current, recursive);
        if (!dep.canRead() && !inError) {
            return false;
        }
        HashSet<URL> read = new HashSet<URL>();
        if (dep.canRead()) {
            BufferedReader pw = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dep), "UTF-8"));
            try {
                String line;
                while ((line = pw.readLine()) != null) {
                    read.add(new URL(line));
                }
            }
            finally {
                pw.close();
            }
        }
        if (modified = inError ? read.add(file) : read.remove(file)) {
            if (read.isEmpty()) {
                dep.delete();
            } else {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dep), "UTF-8"));
                try {
                    for (URL u : read) {
                        pw.println(u.toExternalForm());
                    }
                }
                finally {
                    pw.close();
                }
            }
        }
        return modified;
    }

    public List<URL> getAllFilesWithRecord(URL root) throws IOException {
        try {
            LinkedList<URL> result = new LinkedList<URL>();
            URI rootURI = root.toURI();
            File[] cacheRoot = this.computePersistentFile(root, root);
            URI cacheRootURI = cacheRoot[0].toURI();
            LinkedList<File> todo = new LinkedList<File>();
            todo.add(cacheRoot[0]);
            while (!todo.isEmpty()) {
                File f = (File)todo.poll();
                assert (f != null);
                if (f.isFile()) {
                    if (!f.getName().endsWith("err")) continue;
                    String relative = cacheRootURI.relativize(f.toURI()).getPath();
                    relative = relative.replaceAll("err$", "java");
                    result.add(rootURI.resolve(relative).toURL());
                    continue;
                }
                File[] files = f.listFiles();
                if (files == null) continue;
                for (File children : files) {
                    todo.offer(children);
                }
            }
            return result;
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> getAllFilesInError(URL root) throws IOException {
        File[] cacheRoot = this.computePersistentFile(root, root);
        File dep = this.getDep(cacheRoot[0], true);
        LinkedList<URL> result = new LinkedList<URL>();
        if (dep.canRead()) {
            BufferedReader pw = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dep), "UTF-8"));
            try {
                String line;
                while ((line = pw.readLine()) != null) {
                    result.add(new URL(line));
                }
            }
            finally {
                pw.close();
            }
        }
        return result;
    }

    private File getDep(File folder, boolean recursive) {
        return new File(folder, recursive ? "recursive.dep" : "nonrecursive.dep");
    }

    public boolean isInError(FileObject file, boolean recursive) {
        LOG.log(Level.FINE, "file={0}, recursive={1}", new Object[]{file, recursive});
        if (file.isData()) {
            return !this.getErrors(file, true).isEmpty();
        }
        try {
            ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
            if (cp == null) {
                return false;
            }
            FileObject root = cp.findOwnerRoot(file);
            if (root == null) {
                LOG.log(Level.FINE, "file={0} does not have a root on its own source classpath", file);
                return false;
            }
            String resourceName = cp.getResourceName(file, File.separatorChar, false);
            File cacheRoot = Index.getClassFolder(root.getURL(), true);
            if (cacheRoot == null) {
                return false;
            }
            File cacheFile = this.getDep(new File(new File(cacheRoot.getParentFile(), "errors"), resourceName), recursive);
            LOG.log(Level.FINE, "cache file={0}, canRead={1}", new Object[]{cacheFile, cacheFile.canRead()});
            return cacheFile.canRead();
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.WARNING, null, e);
            return false;
        }
    }

    private File[] computePersistentFile(URL root, URL file) throws IOException {
        try {
            URI fileURI = file.toURI();
            URI u = root.toURI();
            String resourceName = u.relativize(fileURI).getPath();
            int lastDot = resourceName.lastIndexOf(46);
            if (lastDot != -1) {
                resourceName = resourceName.substring(0, lastDot);
            }
            File cacheRoot = Index.getClassFolder(root);
            File errorsRoot = new File(cacheRoot.getParentFile(), "errors");
            File cacheFile = new File(errorsRoot, resourceName + ".err");
            return new File[]{errorsRoot, cacheFile};
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    private File computePersistentFile(FileObject file) throws IOException {
        ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        FileObject root = cp.findOwnerRoot(file);
        if (root == null) {
            LOG.log(Level.FINE, "file={0} does not have a root on its own source classpath", file);
            return null;
        }
        String resourceName = cp.getResourceName(file, File.separatorChar, false);
        File cacheRoot = Index.getClassFolder(root.getURL());
        File cacheFile = new File(new File(cacheRoot.getParentFile(), "errors"), resourceName + ".err");
        return cacheFile;
    }
}

