/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.source.tasklist.TasklistOptionsPanel;
import org.netbeans.modules.java.source.tasklist.TasklistSettings;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TasklistOptions
extends AdvancedOption {
    public String getDisplayName() {
        return NbBundle.getMessage(TasklistOptions.class, (String)"DN_Tasklist");
    }

    public String getTooltip() {
        return NbBundle.getMessage(TasklistOptions.class, (String)"TP_Tasklist");
    }

    public OptionsPanelController create() {
        return new TasklistOptionsPanelController();
    }

    private static class TasklistOptionsPanelController
    extends OptionsPanelController
    implements ChangeListener {
        private TasklistOptionsPanel panel;
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        private TasklistOptionsPanelController() {
        }

        public void update() {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.panel == null) {
                this.getComponent(null);
            }
            this.panel.setDependenciesEnabled(TasklistSettings.isDependencyTrackingEnabled());
            this.panel.setBadgesEnabled(TasklistSettings.isBadgesEnabled());
            this.panel.setTasklistEnabled(TasklistSettings.isTasklistEnabled());
            this.panel.fillInCompilerSettings();
        }

        public void applyChanges() {
            if (this.panel == null) {
                return;
            }
            TasklistSettings.setTasklistsEnabled(this.panel.getTasklistEnabled());
            TasklistSettings.setDependencyTrackingEnabled(this.panel.getDependenciesEnabled());
            TasklistSettings.setBadgesEnabled(this.panel.getBadgesEnabled());
            if (this.panel.isCompilerSettingsChanged()) {
                this.panel.storeCompilerSettings();
            }
        }

        public void cancel() {
            if (this.panel == null) {
                return;
            }
            this.panel.setTasklistEnabled(TasklistSettings.isTasklistEnabled());
            this.panel.setDependenciesEnabled(TasklistSettings.isDependencyTrackingEnabled());
            this.panel.setBadgesEnabled(TasklistSettings.isBadgesEnabled());
            this.panel.fillInCompilerSettings();
        }

        public boolean isValid() {
            return true;
        }

        public boolean isChanged() {
            if (this.panel == null) {
                return false;
            }
            return TasklistSettings.isTasklistEnabled() != this.panel.getTasklistEnabled() || TasklistSettings.isDependencyTrackingEnabled() != this.panel.getDependenciesEnabled() || TasklistSettings.isBadgesEnabled() != this.panel.getBadgesEnabled() || this.panel.isCompilerSettingsChanged();
        }

        public JComponent getComponent(Lookup masterLookup) {
            if (this.panel == null) {
                this.panel = new TasklistOptionsPanel();
                this.panel.addChangeListener(this);
            }
            return this.panel;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public void stateChanged(ChangeEvent e) {
            this.pcs.firePropertyChange("changed", null, null);
        }
    }
}

