/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.source.tasklist.CompilerSettings;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class TasklistOptionsPanel
extends JPanel {
    private ChangeSupport cs = new ChangeSupport((Object)this);
    private Map<JCheckBox, String> compilerSettings;
    private JCheckBox enableBadges;
    private JCheckBox enableDependencies;
    private JCheckBox enableLint;
    private JCheckBox enableLintCast;
    private JCheckBox enableLintDeprecated;
    private JCheckBox enableLintDivZero;
    private JCheckBox enableLintEmpty;
    private JCheckBox enableLintFallThrough;
    private JCheckBox enableLintFinally;
    private JCheckBox enableLintOverrides;
    private JCheckBox enableLintSerial;
    private JCheckBox enableLintUnchecked;
    private JCheckBox enableTasklist;

    public TasklistOptionsPanel() {
        this.initComponents();
        this.compilerSettings = new HashMap<JCheckBox, String>();
        this.compilerSettings.put(this.enableLint, "enable_lint");
        this.compilerSettings.put(this.enableLintDeprecated, "enable_lint_deprecation");
        this.compilerSettings.put(this.enableLintFallThrough, "enable_lint_fallthrough");
        this.compilerSettings.put(this.enableLintFinally, "enable_lint_finally");
        this.compilerSettings.put(this.enableLintSerial, "enable_lint_serial");
        this.compilerSettings.put(this.enableLintUnchecked, "enable_lint_unchecked");
        this.compilerSettings.put(this.enableLintCast, "enable_lint_cast");
        this.compilerSettings.put(this.enableLintDivZero, "enable_lint_dvizero");
        this.compilerSettings.put(this.enableLintEmpty, "enable_lint_empty");
        this.compilerSettings.put(this.enableLintOverrides, "enable_lint_overrides");
    }

    void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    private void initComponents() {
        this.enableTasklist = new JCheckBox();
        this.enableDependencies = new JCheckBox();
        this.enableBadges = new JCheckBox();
        this.enableLint = new JCheckBox();
        this.enableLintDeprecated = new JCheckBox();
        this.enableLintUnchecked = new JCheckBox();
        this.enableLintFallThrough = new JCheckBox();
        this.enableLintSerial = new JCheckBox();
        this.enableLintFinally = new JCheckBox();
        this.enableLintCast = new JCheckBox();
        this.enableLintEmpty = new JCheckBox();
        this.enableLintOverrides = new JCheckBox();
        this.enableLintDivZero = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.enableTasklist, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("jCheckBox1.text"));
        this.enableTasklist.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableTasklist.setMargin(new Insets(0, 0, 0, 0));
        this.enableTasklist.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TasklistOptionsPanel.this.enableTasklistStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.enableTasklist, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableDependencies, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("jCheckBox2.text"));
        this.enableDependencies.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableDependencies.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.enableDependencies, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableBadges, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("jCheckBox1.text_1"));
        this.enableBadges.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableBadges.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.enableBadges, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableLint, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("enableLint.text"));
        this.enableLint.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableLint.setMargin(new Insets(0, 0, 0, 0));
        this.enableLint.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TasklistOptionsPanel.this.enableLintStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 12, 0);
        this.add((Component)this.enableLint, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableLintDeprecated, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("enableLintDeprecated.text"));
        this.enableLintDeprecated.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableLintDeprecated.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.enableLintDeprecated, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableLintUnchecked, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("enableLintUnchecked.text"));
        this.enableLintUnchecked.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableLintUnchecked.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.enableLintUnchecked, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableLintFallThrough, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("enableLintFallThrough.text"));
        this.enableLintFallThrough.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableLintFallThrough.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.enableLintFallThrough, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableLintSerial, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("enableLintSerial.text"));
        this.enableLintSerial.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableLintSerial.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.enableLintSerial, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableLintFinally, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("enableLintFinally.text"));
        this.enableLintFinally.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableLintFinally.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.enableLintFinally, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableLintCast, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("enableLintCast.text"));
        this.enableLintCast.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableLintCast.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.enableLintCast, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableLintEmpty, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("enableLintEmpty.text"));
        this.enableLintEmpty.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableLintEmpty.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.enableLintEmpty, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableLintOverrides, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("enableLintOverrides.text"));
        this.enableLintOverrides.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableLintOverrides.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.enableLintOverrides, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.enableLintDivZero, (String)NbBundle.getBundle(TasklistOptionsPanel.class).getString("enableLintDivZero.text"));
        this.enableLintDivZero.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableLintDivZero.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.enableLintDivZero, gridBagConstraints);
    }

    private void enableLintStateChanged(ChangeEvent evt) {
        this.updateCompilerSettingsEnabled();
    }

    private void enableTasklistStateChanged(ChangeEvent evt) {
        this.updateEnabled();
    }

    public void setTasklistEnabled(boolean enabled) {
        this.enableTasklist.setSelected(enabled);
        this.updateEnabled();
    }

    public void setDependenciesEnabled(boolean enabled) {
        this.enableDependencies.setSelected(enabled);
    }

    public void setBadgesEnabled(boolean enabled) {
        this.enableBadges.setSelected(enabled);
    }

    public boolean getTasklistEnabled() {
        return this.enableTasklist.isSelected();
    }

    public boolean getDependenciesEnabled() {
        return this.enableDependencies.isSelected();
    }

    public boolean getBadgesEnabled() {
        return this.enableBadges.isSelected();
    }

    private void updateEnabled() {
        this.enableDependencies.setEnabled(this.enableTasklist.isSelected());
        this.enableBadges.setEnabled(this.enableTasklist.isSelected());
    }

    public void fillInCompilerSettings() {
        Preferences p = CompilerSettings.getNode();
        for (Map.Entry<JCheckBox, String> e : this.compilerSettings.entrySet()) {
            e.getKey().setSelected(CompilerSettings.get(p, e.getValue()));
        }
        this.updateCompilerSettingsEnabled();
    }

    public boolean isCompilerSettingsChanged() {
        Preferences p = CompilerSettings.getNode();
        for (Map.Entry<JCheckBox, String> e : this.compilerSettings.entrySet()) {
            if (e.getKey().isSelected() == CompilerSettings.get(p, e.getValue())) continue;
            return true;
        }
        return false;
    }

    public void storeCompilerSettings() {
        Preferences p = CompilerSettings.getNode();
        for (Map.Entry<JCheckBox, String> e : this.compilerSettings.entrySet()) {
            p.putBoolean(e.getValue(), e.getKey().isSelected());
        }
        RepositoryUpdater.getDefault().rebuildAll(false);
    }

    private void updateCompilerSettingsEnabled() {
        boolean enable = this.enableLint.isSelected();
        for (JCheckBox b : this.compilerSettings.keySet()) {
            if (b == this.enableLint) continue;
            b.setEnabled(enable);
        }
    }
}

