/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.util.prefs.Preferences;
import org.netbeans.modules.java.source.tasklist.ErrorAnnotator;
import org.netbeans.modules.java.source.tasklist.JavaTaskProvider;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.openide.util.NbPreferences;

public class TasklistSettings {
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_ERROR_BADGES = "error-badges";
    private static final String KEY_DEPENDENCY_TRACKING = "dependency-tracking";
    private static final boolean DEFAULT_ENABLED = true;
    private static final boolean DEFAULT_ERROR_BADGES = true;
    private static final boolean DEFAULT_DEPENDENCY_TRACKING = true;

    private TasklistSettings() {
    }

    public static boolean isTasklistEnabled() {
        return TasklistSettings.getPreferencesNode().getBoolean(KEY_ENABLED, true);
    }

    public static void setTasklistsEnabled(boolean enabled) {
        if (TasklistSettings.isTasklistEnabled() != enabled) {
            ErrorAnnotator an;
            TasklistSettings.getPreferencesNode().putBoolean(KEY_ENABLED, enabled);
            if (enabled) {
                RepositoryUpdater.getDefault().rebuildAll(true);
            }
            if ((an = ErrorAnnotator.getAnnotator()) != null) {
                an.updateAllInError();
            }
            JavaTaskProvider.refreshAll();
        }
    }

    public static boolean isBadgesEnabled() {
        return TasklistSettings.getPreferencesNode().getBoolean(KEY_ERROR_BADGES, true);
    }

    public static void setBadgesEnabled(boolean enabled) {
        if (TasklistSettings.isBadgesEnabled() != enabled) {
            TasklistSettings.getPreferencesNode().putBoolean(KEY_ERROR_BADGES, enabled);
            ErrorAnnotator an = ErrorAnnotator.getAnnotator();
            if (an != null) {
                an.updateAllInError();
            }
        }
    }

    public static boolean isDependencyTrackingEnabled() {
        return TasklistSettings.getPreferencesNode().getBoolean(KEY_DEPENDENCY_TRACKING, true);
    }

    public static void setDependencyTrackingEnabled(boolean enabled) {
        if (TasklistSettings.isDependencyTrackingEnabled() != enabled) {
            ErrorAnnotator an;
            TasklistSettings.getPreferencesNode().putBoolean(KEY_DEPENDENCY_TRACKING, enabled);
            if (enabled) {
                RepositoryUpdater.getDefault().rebuildAll(true);
            }
            if ((an = ErrorAnnotator.getAnnotator()) != null) {
                an.updateAllInError();
            }
        }
    }

    private static Preferences getPreferencesNode() {
        return NbPreferences.forModule(TasklistSettings.class).node("tasklist");
    }
}

