/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.transform;

import com.sun.source.tree.Tree;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.query.QueryEnvironment;
import org.netbeans.modules.java.source.query.SearchEntry;
import org.netbeans.modules.java.source.transform.Change;
import org.netbeans.modules.java.source.transform.ChangeList;
import org.netbeans.modules.java.source.transform.ImmutableTreeTranslator;
import org.netbeans.modules.java.source.transform.TreeChange;
import org.netbeans.modules.java.source.transform.UndoEntry;
import org.netbeans.modules.java.source.transform.UndoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangeSet
extends ChangeList {
    private Translator translator = new Translator();
    private UndoList undo;

    public ChangeSet(String refactoring) {
        super(refactoring);
    }

    public void attach(QueryEnvironment env) {
        this.translator.attach(env);
        this.undo = env.getUndoList();
    }

    public void release() {
        this.translator.release();
        this.undo = null;
    }

    public void rewrite(final Tree oldTree, final Tree newTree) {
        if (newTree != oldTree) {
            final Tree lastChange = this.getChange(oldTree);
            if (lastChange != null) {
                final TreeChange lastTreeChange = new TreeChange(lastChange, newTree);
                this.undo.addAndApply(new UndoEntry(){

                    @Override
                    public void undo() {
                        ChangeSet.this.remove(lastTreeChange);
                    }

                    @Override
                    public void redo() {
                        ChangeSet.this.addLast(lastTreeChange);
                    }

                    @Override
                    public <T> T getOld(T o) {
                        return (T)(o == newTree ? lastChange : null);
                    }
                });
            }
            final TreeChange change = new TreeChange(oldTree, newTree);
            this.undo.addAndApply(new UndoEntry(){

                @Override
                public void undo() {
                    ChangeSet.this.remove(change);
                }

                @Override
                public void redo() {
                    ChangeSet.this.addLast(change);
                }

                @Override
                public <T> T getOld(T o) {
                    return (T)(o == newTree ? oldTree : null);
                }
            });
            this.addFirst(new TreeChange(oldTree, newTree));
        }
    }

    public void rewrite(Change changes) {
        this.addFirst(changes);
    }

    public boolean hasChanges() {
        return this.size() > 0;
    }

    public RootTree commit(RootTree oldRoot) {
        if (this.hasChanges()) {
            HashMap<Tree, Tree> changeMap = new HashMap<Tree, Tree>();
            this.addToMap(changeMap);
            RootTree newRoot = (RootTree)this.translator.translate(oldRoot, changeMap);
            return newRoot;
        }
        return oldRoot;
    }

    public RootTree rollback(RootTree newRoot) {
        if (this.hasChanges()) {
            HashMap<Tree, Tree> changeMap = new HashMap<Tree, Tree>();
            this.addToMap(changeMap);
            RootTree oldRoot = (RootTree)this.untranslate(newRoot, changeMap);
            return oldRoot;
        }
        return newRoot;
    }

    private Tree untranslate(Tree tree, Map<Tree, Tree> changeMap) {
        if (tree == null) {
            return null;
        }
        Tree repl = this.getOriginal(tree);
        return this.translator.translate(repl != null ? repl : tree, changeMap);
    }

    Change getResultChanges(SearchEntry se) {
        for (Change change : this) {
            if (!change.hasOriginal(se.tree)) continue;
            return change;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Translator
    extends ImmutableTreeTranslator {
        private Map<Tree, Tree> changeMap;

        Translator() {
        }

        Tree translate(Tree tree, Map<Tree, Tree> changeMap) {
            this.changeMap = new HashMap<Tree, Tree>(changeMap);
            return this.translate(tree);
        }

        @Override
        public Tree translate(Tree tree) {
            assert (this.changeMap != null);
            if (tree == null) {
                return null;
            }
            Tree repl = this.changeMap.remove(tree);
            Tree newRepl = super.translate(repl != null ? repl : tree);
            return newRepl;
        }
    }
}

