/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.transform;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.logging.Logger;
import javax.lang.model.util.Types;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.engine.ReattributionException;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.engine.TreeMakerInt;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.Query;
import org.netbeans.modules.java.source.query.QueryEnvironment;
import org.netbeans.modules.java.source.transform.ChangeSet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transformer<R, P>
extends Query<R, P> {
    protected ASTModel model;
    public TreeMakerInt make;
    protected ChangeSet changes;
    protected String refactoringDescription;
    protected Types types;
    private String failureMessage;
    static final Logger logger = Logger.getLogger("org.netbeans.modules.java.source");

    @Override
    public void init() {
        super.init();
        this.changes = new ChangeSet(this.getQueryDescription());
    }

    @Override
    public void attach(QueryEnvironment env) {
        this.model = ((EngineEnvironment)env).getModel();
        this.make = env.getTreeMaker();
        this.types = env.getTypes();
        this.changes.attach(env);
        this.result.attach(env);
        super.attach(env);
    }

    @Override
    public void release() {
        super.release();
        this.make = null;
        this.types = null;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.changes = null;
        this.result = null;
    }

    public String getRefactoringDescription() {
        return this.refactoringDescription != null ? this.refactoringDescription : "Unnamed Refactoring";
    }

    public void setRefactoringDescription(String description) {
        this.refactoringDescription = description;
    }

    @Override
    public void apply(Tree t) {
        try {
            t.accept(this, null);
            RootTree newRoot = this.commit((RootTree)this.model.getRoot());
            if (!this.translationSuccessful()) {
                this.result.clear();
                String errTitle = this.queryDescription != null ? this.queryDescription : this.getString("Transformer.failure");
                this.env.setErrorMessage(this.failureMessage, errTitle);
            } else if (this.changes.hasChanges()) {
                this.model.setRoot(newRoot);
            }
        }
        catch (ReattributionException e) {
            this.error(e);
        }
    }

    String getString(String key) {
        return NbBundle.getBundle(Transformer.class).getString(key);
    }

    public ChangeSet getChanges() {
        return this.changes;
    }

    public void setChanges(ChangeSet changes) {
        this.changes = changes;
    }

    public RootTree commit(RootTree oldRoot) {
        return this.changes.commit(oldRoot);
    }

    protected boolean translationSuccessful() {
        return this.failureMessage == null;
    }

    public static Tree deblock(Tree t) {
        block4: while (t != null) {
            switch (t.getKind()) {
                case BLOCK: {
                    BlockTree b = (BlockTree)t;
                    if (b.isStatic()) {
                        return t;
                    }
                    List<? extends StatementTree> stats = b.getStatements();
                    if (stats.size() == 1) {
                        t = stats.get(0);
                        continue block4;
                    }
                    return t;
                }
                case PARENTHESIZED: {
                    t = ((ParenthesizedTree)t).getExpression();
                    continue block4;
                }
            }
            return t;
        }
        return null;
    }

    public final void copyCommentTo(Tree from, Tree to) {
        if (from != null && to != null) {
            CommentHandler commentHandler = this.env.getCommentHandler();
            commentHandler.copyComments(from, to);
        }
    }
}

