/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.model.JavacElements;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.JComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPFieldInfo;
import org.netbeans.modules.classfile.CPInterfaceMethodInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.Code;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.classfile.LocalVariableTableEntry;
import org.netbeans.modules.classfile.LocalVariableTypeTableEntry;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.classfile.Parameter;
import org.netbeans.modules.classfile.Variable;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.ParamNameResolver;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.netbeans.modules.java.source.util.LowMemoryNotifier;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryAnalyser
implements LowMemoryListener {
    static final String OBJECT = Object.class.getName();
    private final Index index;
    private final Map<String, List<String>> refs = new HashMap<String, List<String>>();
    private final Set<String> toDelete = new HashSet<String>();
    private final AtomicBoolean lowMemory;
    private Continuation cont;

    public BinaryAnalyser(Index index) {
        assert (index != null);
        this.index = index;
        this.lowMemory = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean start(URL root, ProgressHandle handle, AtomicBoolean cancel) throws IOException, IllegalArgumentException {
        assert (root != null);
        assert (this.cont == null);
        LowMemoryNotifier.getDefault().addLowMemoryListener(this);
        try {
            String mainP = root.getProtocol();
            if ("jar".equals(mainP)) {
                URL innerURL = FileUtil.getArchiveFile((URL)root);
                if ("file".equals(innerURL.getProtocol())) {
                    File archive = new File(URI.create(innerURL.toExternalForm()));
                    if (archive.exists() && archive.canRead()) {
                        if (handle != null) {
                            handle.setDisplayName(String.format(NbBundle.getMessage(BinaryAnalyser.class, (String)"MSG_Scannig"), archive.getAbsolutePath()));
                        }
                        if (!this.isUpToDate(null, archive.lastModified())) {
                            this.index.clear();
                            if (handle != null) {
                                handle.setDisplayName(String.format(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing"), archive.getAbsolutePath()));
                            }
                            ZipFile zipFile = new ZipFile(archive);
                            BinaryAnalyser.prebuildArgs(zipFile, root);
                            Enumeration<? extends ZipEntry> e = zipFile.entries();
                            this.cont = new ZipContinuation(zipFile, e, cancel);
                            boolean bl = this.cont.execute();
                            return bl;
                        }
                    }
                } else {
                    FileObject rootFo = URLMapper.findFileObject((URL)root);
                    if (rootFo != null) {
                        if (handle != null) {
                            handle.setDisplayName(String.format(NbBundle.getMessage(BinaryAnalyser.class, (String)"MSG_Scannig"), FileUtil.getFileDisplayName((FileObject)rootFo)));
                        }
                        if (!this.isUpToDate(null, rootFo.lastModified().getTime())) {
                            this.index.clear();
                            if (handle != null) {
                                handle.setDisplayName(String.format(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing"), FileUtil.getFileDisplayName((FileObject)rootFo)));
                            }
                            Enumeration todo = rootFo.getData(true);
                            this.cont = new FileObjectContinuation(todo, cancel);
                            boolean e = this.cont.execute();
                            return e;
                        }
                    }
                }
            } else if ("file".equals(mainP)) {
                File rootFile = new File(URI.create(root.toExternalForm()));
                if (rootFile.isDirectory()) {
                    File[] children;
                    String path = rootFile.getAbsolutePath();
                    if (path.charAt(path.length() - 1) != File.separatorChar) {
                        path = path + File.separatorChar;
                    }
                    if (handle != null) {
                        handle.setDisplayName(String.format(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing"), rootFile.getAbsolutePath()));
                    }
                    LinkedList<File> todo = new LinkedList<File>();
                    if (rootFile.isDirectory() && rootFile.canRead() && (children = rootFile.listFiles()) != null) {
                        todo.addAll(Arrays.asList(children));
                    }
                    this.cont = new FolderContinuation(todo, path, cancel);
                    boolean bl = this.cont.execute();
                    return bl;
                }
            } else {
                FileObject rootFo = URLMapper.findFileObject((URL)root);
                if (rootFo != null) {
                    if (handle != null) {
                        handle.setDisplayName(String.format(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing"), FileUtil.getFileDisplayName((FileObject)rootFo)));
                    }
                    this.index.clear();
                    Enumeration todo = rootFo.getData(true);
                    this.cont = new FileObjectContinuation(todo, cancel);
                    boolean bl = this.cont.execute();
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            LowMemoryNotifier.getDefault().removeLowMemoryListener(this);
        }
    }

    public boolean resume() throws IOException {
        assert (this.cont != null);
        return this.cont.execute();
    }

    public void finish() throws IOException {
        if (this.cont != null) {
            this.cont.finish();
            this.cont = null;
        }
        this.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean analyseFolder(LinkedList<File> todo, String rootPath, AtomicBoolean cancel) throws IOException {
        while (!todo.isEmpty()) {
            File file = todo.removeFirst();
            if (file.isDirectory() && file.canRead()) {
                File[] c = file.listFiles();
                if (c != null) {
                    todo.addAll(Arrays.asList(c));
                }
            } else if (this.accepts(file.getName())) {
                int slashIndex;
                String filePath = file.getAbsolutePath();
                long fileMTime = file.lastModified();
                int dotIndex = filePath.lastIndexOf(46);
                int endPos = dotIndex > (slashIndex = filePath.lastIndexOf(47)) ? dotIndex : filePath.length();
                String relativePath = FileObjects.convertFolder2Package(filePath.substring(rootPath.length(), endPos));
                if (this.accepts(file.getName()) && !this.isUpToDate(relativePath, fileMTime)) {
                    this.toDelete.add(relativePath);
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                    try {
                        this.analyse(in);
                    }
                    catch (InvalidClassFormatException icf) {
                        Logger.getLogger(BinaryAnalyser.class.getName()).info("Invalid class file format: " + file.getAbsolutePath());
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                    if (this.lowMemory.getAndSet(false)) {
                        this.store();
                    }
                }
            }
            if (!cancel.getAndSet(false)) continue;
            this.store();
            return false;
        }
        return true;
    }

    private boolean analyseArchive(ZipFile zipFile, Enumeration<? extends ZipEntry> e, AtomicBoolean cancel) throws IOException {
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            if (!ze.isDirectory() && this.accepts(ze.getName())) {
                InputStream in = zipFile.getInputStream(ze);
                try {
                    this.analyse(in);
                }
                catch (InvalidClassFormatException icf) {
                    Logger.getLogger(BinaryAnalyser.class.getName()).info("Invalid class file format: " + new File(zipFile.getName()).toURI() + "!/" + ze.getName());
                }
                catch (IOException x) {
                    Exceptions.attachMessage((Throwable)x, (String)("While scanning: " + ze.getName()));
                    throw x;
                }
                finally {
                    in.close();
                }
                if (this.lowMemory.getAndSet(false)) {
                    this.store();
                }
            }
            if (!cancel.getAndSet(false)) continue;
            this.store();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean analyseFileObjects(Enumeration<? extends FileObject> todo, AtomicBoolean cancel) throws IOException {
        while (todo.hasMoreElements()) {
            FileObject fo = todo.nextElement();
            if (this.accepts(fo.getName())) {
                BufferedInputStream in = new BufferedInputStream(fo.getInputStream());
                try {
                    this.analyse(in);
                }
                catch (InvalidClassFormatException icf) {
                    Logger.getLogger(BinaryAnalyser.class.getName()).info("Invalid class file format: " + FileUtil.getFileDisplayName((FileObject)fo));
                }
                finally {
                    ((InputStream)in).close();
                }
                if (this.lowMemory.getAndSet(false)) {
                    this.store();
                }
            }
            if (!cancel.getAndSet(false)) continue;
            this.store();
            return false;
        }
        return true;
    }

    private final void delete(String className) throws IOException {
        assert (className != null);
        if (!this.index.isValid(false)) {
            return;
        }
        this.toDelete.add(className);
    }

    @Override
    public void lowMemory(LowMemoryEvent event) {
        this.lowMemory.set(true);
    }

    private boolean accepts(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1 || index + 1 == name.length()) {
            return false;
        }
        return "CLASS".equalsIgnoreCase(name.substring(index + 1));
    }

    private void analyse(InputStream inputStream) throws IOException {
        ClassFile classFile = new ClassFile(inputStream);
        ClassName className = classFile.getName();
        String classNameStr = BinaryAnalyser.nameToString(className);
        this.delete(classNameStr);
        Map<ClassName, Set<ClassIndexImpl.UsageType>> usages = this.performAnalyse(classFile, classNameStr);
        ElementKind kind = ElementKind.CLASS;
        if (classFile.isEnum()) {
            kind = ElementKind.ENUM;
        } else if (classFile.isAnnotation()) {
            kind = ElementKind.ANNOTATION_TYPE;
        } else if ((classFile.getAccess() & 0x200) == 512) {
            kind = ElementKind.INTERFACE;
        }
        String classNameType = classNameStr + DocumentUtil.encodeKind(kind);
        List<String> references = this.getClassReferences(classNameType);
        for (Map.Entry<ClassName, Set<ClassIndexImpl.UsageType>> entry : usages.entrySet()) {
            ClassName name = entry.getKey();
            Set<ClassIndexImpl.UsageType> usage = entry.getValue();
            references.add(DocumentUtil.encodeUsage(BinaryAnalyser.nameToString(name), usage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        try {
            if (this.refs.size() > 0 || this.toDelete.size() > 0) {
                this.index.store(this.refs, this.toDelete);
            }
        }
        finally {
            this.refs.clear();
            this.toDelete.clear();
        }
    }

    private final boolean isUpToDate(String resourceName, long resourceMTime) throws IOException {
        return this.index.isUpToDate(resourceName, resourceMTime);
    }

    /*
     * WARNING - void declaration
     */
    private Map<ClassName, Set<ClassIndexImpl.UsageType>> performAnalyse(ClassFile classFile, String className) throws IOException {
        ClassName name;
        ClassName scName;
        HashMap<ClassName, Set<ClassIndexImpl.UsageType>> usages = new HashMap<ClassName, Set<ClassIndexImpl.UsageType>>();
        String signature = classFile.getTypeSignature();
        if (signature != null) {
            try {
                ClassName[] typeSigNames;
                for (ClassName typeSigName : typeSigNames = ClassFileUtil.getTypesFromClassTypeSignature(signature)) {
                    BinaryAnalyser.addUsage(usages, typeSigName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
            }
            catch (RuntimeException re) {
                StackTraceElement[] elements;
                StringBuilder message = new StringBuilder("BinaryAnalyser: Cannot read type: " + signature + " cause: " + re.getLocalizedMessage() + '\n');
                for (StackTraceElement e : elements = re.getStackTrace()) {
                    message.append(e.toString());
                    message.append('\n');
                }
                Logger.getLogger("global").log(Level.INFO, message.toString());
            }
        }
        if ((scName = classFile.getSuperClass()) != null) {
            BinaryAnalyser.addUsage(usages, scName, ClassIndexImpl.UsageType.SUPER_CLASS);
        }
        Collection interfaces = classFile.getInterfaces();
        for (ClassName ifaceName : interfaces) {
            BinaryAnalyser.addUsage(usages, ifaceName, ClassIndexImpl.UsageType.SUPER_INTERFACE);
        }
        ConstantPool constantPool = classFile.getConstantPool();
        Collection fields = constantPool.getAllConstants(CPFieldInfo.class);
        for (CPFieldInfo field : fields) {
            ClassName name2 = ClassFileUtil.getType(constantPool.getClass(field.getClassID()));
            if (name2 == null) continue;
            BinaryAnalyser.addUsage(usages, name2, ClassIndexImpl.UsageType.FIELD_REFERENCE);
        }
        Collection methodCalls = constantPool.getAllConstants(CPMethodInfo.class);
        for (CPMethodInfo method : methodCalls) {
            name = ClassFileUtil.getType(constantPool.getClass(method.getClassID()));
            if (name == null) continue;
            BinaryAnalyser.addUsage(usages, name, ClassIndexImpl.UsageType.METHOD_REFERENCE);
        }
        methodCalls = constantPool.getAllConstants(CPInterfaceMethodInfo.class);
        for (CPMethodInfo method : methodCalls) {
            name = ClassFileUtil.getType(constantPool.getClass(method.getClassID()));
            if (name == null) continue;
            BinaryAnalyser.addUsage(usages, name, ClassIndexImpl.UsageType.METHOD_REFERENCE);
        }
        Collection methods = classFile.getMethods();
        for (Method method : methods) {
            LocalVariableTypeTableEntry[] varTypes;
            LocalVariableTableEntry[] vars;
            Code code;
            CPClassInfo[] classInfos;
            String jvmTypeId = method.getReturnType();
            ClassName type = ClassFileUtil.getType(jvmTypeId);
            if (type != null) {
                BinaryAnalyser.addUsage(usages, type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            List params = method.getParameters();
            for (Parameter param : params) {
                jvmTypeId = param.getDescriptor();
                type = ClassFileUtil.getType(jvmTypeId);
                if (type == null) continue;
                BinaryAnalyser.addUsage(usages, type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            for (CPClassInfo cPClassInfo : classInfos = method.getExceptionClasses()) {
                type = cPClassInfo.getClassName();
                if (type == null) continue;
                BinaryAnalyser.addUsage(usages, type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            jvmTypeId = method.getTypeSignature();
            if (jvmTypeId != null) {
                try {
                    void var20_38;
                    ClassName[] typeSigNames;
                    ClassName[] arr$ = typeSigNames = ClassFileUtil.getTypesFromMethodTypeSignature(jvmTypeId);
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var20_38 < len$) {
                        ClassName typeSigName = arr$[var20_38];
                        BinaryAnalyser.addUsage(usages, typeSigName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        ++var20_38;
                    }
                }
                catch (IllegalStateException is) {
                    Logger.getLogger("global").warning("Invalid method signature: " + className + "::" + method.getName() + " signature is:" + jvmTypeId);
                }
            }
            if ((code = method.getCode()) == null) continue;
            for (LocalVariableTableEntry var : vars = code.getLocalVariableTable()) {
                type = ClassFileUtil.getType(var.getDescription());
                if (type == null) continue;
                BinaryAnalyser.addUsage(usages, type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            for (LocalVariableTypeTableEntry varType : varTypes = method.getCode().getLocalVariableTypeTable()) {
                try {
                    ClassName[] typeSigNames;
                    for (ClassName typeSigName : typeSigNames = ClassFileUtil.getTypesFromFiledTypeSignature(varType.getSignature())) {
                        BinaryAnalyser.addUsage(usages, typeSigName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                }
                catch (IllegalStateException is) {
                    Logger.getLogger("global").warning("Invalid local variable signature: " + className + "::" + method.getName());
                }
            }
        }
        Collection vars = classFile.getVariables();
        for (Variable var : vars) {
            String jvmTypeId = var.getDescriptor();
            ClassName type = ClassFileUtil.getType(jvmTypeId);
            if (type != null) {
                BinaryAnalyser.addUsage(usages, type, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            if ((jvmTypeId = var.getTypeSignature()) == null) continue;
            try {
                ClassName[] typeSigNames = ClassFileUtil.getTypesFromFiledTypeSignature(jvmTypeId);
                for (CPClassInfo cPClassInfo : typeSigNames) {
                    BinaryAnalyser.addUsage(usages, (ClassName)cPClassInfo, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
            }
            catch (IllegalStateException is) {
                Logger.getLogger("global").warning("Invalid field signature: " + className + "::" + var.getName() + " signature is: " + jvmTypeId);
            }
        }
        Collection cis = constantPool.getAllConstants(CPClassInfo.class);
        for (CPClassInfo ci : cis) {
            ClassName ciName = ClassFileUtil.getType(ci);
            if (ciName == null || usages.keySet().contains(ciName)) continue;
            BinaryAnalyser.addUsage(usages, ciName, ClassIndexImpl.UsageType.TYPE_REFERENCE);
        }
        return usages;
    }

    private List<String> getClassReferences(String className) {
        assert (className != null);
        List<String> cr = this.refs.get(className);
        if (cr == null) {
            cr = new ArrayList<String>();
            this.refs.put(className, cr);
        }
        return cr;
    }

    private static String nameToString(ClassName name) {
        return name.getInternalName().replace('/', '.');
    }

    private static void addUsage(Map<ClassName, Set<ClassIndexImpl.UsageType>> usages, ClassName name, ClassIndexImpl.UsageType usage) {
        if (OBJECT.equals(name.getExternalName())) {
            return;
        }
        Set<ClassIndexImpl.UsageType> uset = usages.get(name);
        if (uset == null) {
            uset = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
            usages.put(name, uset);
        }
        uset.add(usage);
    }

    private static void prebuildArgs(ZipFile archiveFile, URL archiveUrl) {
        ZipEntry e = archiveFile.getEntry(FileObjects.convertPackage2Folder(JComponent.class.getName()) + '.' + "class");
        if (e != null) {
            ClasspathInfo cpInfo = ClasspathInfo.create(ClassPathSupport.createClassPath((URL[])new URL[]{archiveUrl}), ClassPathSupport.createClassPath((URL[])new URL[0]), ClassPathSupport.createClassPath((URL[])new URL[0]));
            JavacTaskImpl jt = JavaSourceAccessor.INSTANCE.createJavacTask(cpInfo, null, null);
            ParamNameResolver.preRegister(jt.getContext(), cpInfo);
            Symbol.ClassSymbol jc = ((JavacElements)jt.getElements()).getTypeElement(JComponent.class.getName());
            if (jc != null) {
                List<ExecutableElement> methods = ElementFilter.methodsIn(jc.getEnclosedElements());
                for (ExecutableElement method : methods) {
                    List<? extends VariableElement> params = method.getParameters();
                    if (params.isEmpty()) continue;
                    params.get(0).getSimpleName();
                    break;
                }
            }
        }
    }

    private static interface Continuation {
        public boolean execute() throws IOException;

        public void finish() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileObjectContinuation
    implements Continuation {
        private final Enumeration<? extends FileObject> todo;
        private final AtomicBoolean cancel;

        public FileObjectContinuation(Enumeration<? extends FileObject> todo, AtomicBoolean cancel) {
            assert (todo != null);
            assert (cancel != null);
            this.todo = todo;
            this.cancel = cancel;
        }

        @Override
        public boolean execute() throws IOException {
            return BinaryAnalyser.this.analyseFileObjects(this.todo, this.cancel);
        }

        @Override
        public void finish() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FolderContinuation
    implements Continuation {
        private final LinkedList<File> todo;
        private final String rootPath;
        private final AtomicBoolean cancel;

        public FolderContinuation(LinkedList<File> todo, String rootPath, AtomicBoolean cancel) {
            assert (todo != null);
            assert (rootPath != null);
            assert (cancel != null);
            this.todo = todo;
            this.rootPath = rootPath;
            this.cancel = cancel;
        }

        @Override
        public boolean execute() throws IOException {
            return BinaryAnalyser.this.analyseFolder(this.todo, this.rootPath, this.cancel);
        }

        @Override
        public void finish() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ZipContinuation
    implements Continuation {
        private final ZipFile zipFile;
        private final Enumeration<? extends ZipEntry> entries;
        private final AtomicBoolean cancel;

        public ZipContinuation(ZipFile zipFile, Enumeration<? extends ZipEntry> entries, AtomicBoolean cancel) {
            assert (zipFile != null);
            assert (entries != null);
            assert (cancel != null);
            this.zipFile = zipFile;
            this.entries = entries;
            this.cancel = cancel;
        }

        @Override
        public boolean execute() throws IOException {
            return BinaryAnalyser.this.analyseArchive(this.zipFile, this.entries, this.cancel);
        }

        @Override
        public void finish() throws IOException {
            this.zipFile.close();
        }
    }
}

