/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManagerEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManagerListener;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.PersistentClassIndex;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassIndexManager {
    private static final byte OP_ADD = 1;
    private static final byte OP_REMOVE = 2;
    private static ClassIndexManager instance;
    private final Map<URL, ClassIndexImpl> instances = new HashMap<URL, ClassIndexImpl>();
    private final ReadWriteLock lock;
    private final List<ClassIndexManagerListener> listeners = new CopyOnWriteArrayList<ClassIndexManagerListener>();
    private boolean invalid;
    private Set<URL> added;
    private Set<URL> removed;
    private int depth = 0;

    private ClassIndexManager() {
        this.lock = new ReentrantReadWriteLock(false);
    }

    public void addClassIndexManagerListener(ClassIndexManagerListener listener) {
        assert (listener != null);
        this.listeners.add(listener);
    }

    public void removeClassIndexManagerListener(ClassIndexManagerListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    /*
     * Exception decompiling
     */
    public <T> T writeLock(ExceptionAction<T> r) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readLock(ExceptionAction<T> r) throws IOException {
        this.lock.readLock().lock();
        try {
            T t = r.run();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public synchronized ClassIndexImpl getUsagesQuery(URL root) throws IOException {
        assert (root != null);
        if (this.invalid) {
            return null;
        }
        return this.instances.get(root);
    }

    public synchronized ClassIndexImpl createUsagesQuery(URL root, boolean source) throws IOException {
        assert (root != null);
        if (this.invalid) {
            return null;
        }
        ClassIndexImpl qi = this.instances.get(root);
        if (qi == null) {
            qi = PersistentClassIndex.create(root, Index.getDataFolder(root), source);
            this.instances.put(root, qi);
            if (this.added != null) {
                this.added.add(root);
            }
        }
        return qi;
    }

    synchronized void removeRoot(URL root) throws IOException {
        ClassIndexImpl ci = this.instances.remove(root);
        if (ci != null) {
            ci.close();
            if (this.removed != null) {
                this.removed.add(root);
            }
        }
    }

    public synchronized void close() {
        this.invalid = true;
        for (ClassIndexImpl ci : this.instances.values()) {
            try {
                ci.close();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private void fire(Set<? extends URL> roots, byte op) {
        ClassIndexManagerEvent event = new ClassIndexManagerEvent(this, roots);
        for (ClassIndexManagerListener listener : this.listeners) {
            if (op == 1) {
                listener.classIndexAdded(event);
                continue;
            }
            if (op == 2) {
                listener.classIndexRemoved(event);
                continue;
            }
            assert (false) : "Unknown op: " + op;
        }
    }

    public static synchronized ClassIndexManager getDefault() {
        if (instance == null) {
            instance = new ClassIndexManager();
        }
        return instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExceptionAction<T> {
        public T run() throws IOException;
    }
}

