/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Index {
    private static final int VERSION = 0;
    private static final int SUBVERSION = 3;
    private static final String NB_USER_DIR = "netbeans.user";
    private static final String SEGMENTS_FILE = "segments";
    private static final String CLASSES = "classes";
    private static final String SLICE_PREFIX = "s";
    private static final String INDEX_DIR = "var" + File.separatorChar + "cache" + File.separatorChar + "index" + File.separatorChar + 0 + '.' + 3;
    private static Properties segments;
    private static Map<String, String> invertedSegments;
    private static File cacheFolder;
    private static File segmentsFile;
    private static int index;

    public abstract boolean isValid(boolean var1) throws IOException;

    public abstract List<String> getUsagesData(String var1, Set<ClassIndexImpl.UsageType> var2, BooleanOperator var3) throws IOException;

    public abstract List<String> getUsagesFQN(String var1, Set<ClassIndexImpl.UsageType> var2, BooleanOperator var3) throws IOException;

    public abstract List<String> getReferencesData(String var1) throws IOException;

    public abstract <T> void getDeclaredTypes(String var1, ClassIndex.NameKind var2, ResultConvertor<T> var3, Set<? super T> var4) throws IOException;

    public abstract void getPackageNames(String var1, boolean var2, Set<String> var3) throws IOException;

    public abstract void store(Map<String, List<String>> var1, Set<String> var2) throws IOException;

    public abstract void store(Map<String, List<String>> var1, List<String> var2) throws IOException;

    public abstract boolean isUpToDate(String var1, long var2) throws IOException;

    public abstract void clear() throws IOException;

    public abstract void close() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSegments() throws IOException {
        if (segments == null) {
            File cacheFolder = Index.getCacheFolder();
            assert (cacheFolder != null);
            segments = new Properties();
            invertedSegments = new HashMap<String, String>();
            segmentsFile = FileUtil.normalizeFile((File)new File(cacheFolder, SEGMENTS_FILE));
            if (segmentsFile.exists()) {
                FileInputStream in = new FileInputStream(segmentsFile);
                try {
                    segments.load(in);
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            for (Map.Entry<Object, Object> entry : segments.entrySet()) {
                String segment = (String)entry.getKey();
                String root = (String)entry.getValue();
                invertedSegments.put(root, segment);
                try {
                    index = Math.max(index, Integer.parseInt(segment.substring(SLICE_PREFIX.length())));
                }
                catch (NumberFormatException nfe) {
                    ErrorManager.getDefault().notify((Throwable)nfe);
                }
            }
            assert (segmentsFile != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeSegments() throws IOException {
        assert (segmentsFile != null);
        FileOutputStream out = new FileOutputStream(segmentsFile);
        try {
            segments.store(out, null);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static URL getSourceRootForClassFolder(URL classFolder) {
        if ("file".equals(classFolder.getProtocol())) {
            try {
                File file = FileUtil.normalizeFile((File)new File(classFolder.toURI()));
                File segFolder = file.getParentFile();
                if (segFolder == null) {
                    return null;
                }
                File cFolder = segFolder.getParentFile();
                if (cFolder == null || !((Object)cFolder).equals(cacheFolder)) {
                    return null;
                }
                String source = segments.getProperty(segFolder.getName());
                if (source != null) {
                    try {
                        return new URL(source);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
            catch (URISyntaxException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return null;
    }

    public static synchronized File getDataFolder(URL root) throws IOException {
        return Index.getDataFolder(root, false);
    }

    public static synchronized File getDataFolder(URL root, boolean onlyIfAlreadyExists) throws IOException {
        File result;
        Index.loadSegments();
        String rootName = root.toExternalForm();
        String slice = invertedSegments.get(rootName);
        if (slice == null) {
            if (onlyIfAlreadyExists) {
                return null;
            }
            slice = SLICE_PREFIX + ++index;
            while (segments.getProperty(slice) != null) {
                slice = SLICE_PREFIX + ++index;
            }
            segments.put(slice, rootName);
            invertedSegments.put(rootName, slice);
            Index.storeSegments();
        }
        if (!(result = FileUtil.normalizeFile((File)new File(cacheFolder, slice))).exists()) {
            if (onlyIfAlreadyExists) {
                return null;
            }
            result.mkdir();
        }
        return result;
    }

    public static File getClassFolder(URL url, boolean onlyIfAlreadyExists) throws IOException {
        return Index.getClassFolderImpl(url, onlyIfAlreadyExists);
    }

    public static File getClassFolder(URL url) throws IOException {
        return Index.getClassFolder(url, false);
    }

    public static File getClassFolder(File root) throws IOException {
        return Index.getClassFolderImpl(root.toURI().toURL(), false);
    }

    private static File getClassFolderImpl(URL url, boolean onlyIfAlreadyExists) throws IOException {
        File dataFolder = Index.getDataFolder(url, onlyIfAlreadyExists);
        if (onlyIfAlreadyExists && dataFolder == null) {
            return null;
        }
        File result = FileUtil.normalizeFile((File)new File(dataFolder, CLASSES));
        if (!result.exists()) {
            if (onlyIfAlreadyExists) {
                return null;
            }
            result.mkdir();
        }
        return result;
    }

    static String getNbUserDir() {
        String nbUserProp = System.getProperty(NB_USER_DIR);
        return nbUserProp;
    }

    public static synchronized File getCacheFolder() {
        if (cacheFolder == null) {
            String nbUserDirProp = Index.getNbUserDir();
            assert (nbUserDirProp != null);
            File nbUserDir = new File(nbUserDirProp);
            cacheFolder = FileUtil.normalizeFile((File)new File(nbUserDir, INDEX_DIR));
            if (!cacheFolder.exists()) {
                boolean created = cacheFolder.mkdirs();
                assert (created) : "Cannot create cache folder";
            } else assert (cacheFolder.isDirectory() && cacheFolder.canRead() && cacheFolder.canWrite());
        }
        return cacheFolder;
    }

    public static boolean isTest() {
        return Index.getNbUserDir() == null;
    }

    static synchronized void setCacheFolder(File folder) {
        assert (folder != null && folder.exists() && folder.canRead() && folder.canWrite());
        cacheFolder = folder;
    }

    static {
        index = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanOperator {
        AND,
        OR;

    }
}

