/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.LuceneIndexMBeanImpl;
import org.netbeans.modules.java.source.usages.NBLockFactory;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.netbeans.modules.java.source.util.LowMemoryNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneIndex
extends Index {
    private static final boolean debugIndexMerging = Boolean.getBoolean("LuceneIndex.debugIndexMerge");
    private static final String REFERENCES = "refs";
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class.getName());
    private final Directory directory;
    private Long rootTimeStamp;
    private IndexReader reader;
    private Set<String> rootPkgCache;

    public static Index create(File cacheRoot) throws IOException {
        assert (cacheRoot != null && cacheRoot.exists() && cacheRoot.canRead() && cacheRoot.canWrite());
        return new LuceneIndex(LuceneIndex.getReferencesCacheFolder(cacheRoot));
    }

    private LuceneIndex(File refCacheRoot) throws IOException {
        assert (refCacheRoot != null);
        this.directory = FSDirectory.getDirectory(refCacheRoot, Index.isTest() ? NoLockFactory.getNoLockFactory() : new NBLockFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUsagesData(String resourceName, Set<ClassIndexImpl.UsageType> mask, Index.BooleanOperator operator) throws IOException {
        if (!this.isValid(false)) {
            return null;
        }
        IndexSearcher searcher = new IndexSearcher(this.getReader());
        try {
            LinkedList<String> result = new LinkedList<String>();
            Query query = null;
            if (mask == null) {
                query = new WildcardQuery(DocumentUtil.referencesTerm(resourceName, null));
            } else {
                assert (operator != null);
                switch (operator) {
                    case AND: {
                        query = new WildcardQuery(DocumentUtil.referencesTerm(resourceName, mask));
                        break;
                    }
                    case OR: {
                        BooleanQuery booleanQuery = new BooleanQuery();
                        for (ClassIndexImpl.UsageType ut : mask) {
                            WildcardQuery subQuery = new WildcardQuery(DocumentUtil.referencesTerm(resourceName, EnumSet.of(ut)));
                            booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
                        }
                        query = booleanQuery;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(operator.toString());
                    }
                }
            }
            assert (query != null);
            Hits hits = searcher.search(query);
            Iterator it = hits.iterator();
            while (it.hasNext()) {
                Hit hit = (Hit)it.next();
                Document doc = hit.getDocument();
                String user = DocumentUtil.getBinaryName(doc);
                String map = DocumentUtil.getRefereneType(doc, resourceName);
                if (map == null) continue;
                result.add(DocumentUtil.encodeUsage(user, map));
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        finally {
            ((Searcher)searcher).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUsagesFQN(String resourceName, Set<ClassIndexImpl.UsageType> mask, Index.BooleanOperator operator) throws IOException {
        if (!this.isValid(false)) {
            return null;
        }
        assert (resourceName != null);
        assert (mask != null);
        assert (operator != null);
        IndexSearcher searcher = new IndexSearcher(this.getReader());
        try {
            Query query;
            LinkedList<String> result = new LinkedList<String>();
            switch (operator) {
                case AND: {
                    query = new WildcardQuery(DocumentUtil.referencesTerm(resourceName, mask));
                    break;
                }
                case OR: {
                    BooleanQuery booleanQuery = new BooleanQuery();
                    for (ClassIndexImpl.UsageType ut : mask) {
                        WildcardQuery subQuery = new WildcardQuery(DocumentUtil.referencesTerm(resourceName, EnumSet.of(ut)));
                        booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
                    }
                    query = booleanQuery;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(operator.toString());
                }
            }
            Hits hits = searcher.search(query);
            Iterator it = hits.iterator();
            while (it.hasNext()) {
                Hit hit = (Hit)it.next();
                Document doc = hit.getDocument();
                String user = DocumentUtil.getBinaryName(doc);
                result.add(user);
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        finally {
            ((Searcher)searcher).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getReferencesData(String resourceName) throws IOException {
        if (!this.isValid(false)) {
            return null;
        }
        IndexSearcher searcher = new IndexSearcher(this.getReader());
        try {
            Hits hits = searcher.search(DocumentUtil.binaryNameQuery(resourceName));
            assert (hits.length() <= 1);
            if (hits.length() == 0) {
                List<String> list = null;
                return list;
            }
            Hit hit = (Hit)hits.iterator().next();
            List<String> list = DocumentUtil.getReferences(hit.getDocument());
            return list;
        }
        finally {
            ((Searcher)searcher).close();
        }
    }

    @Override
    public <T> void getDeclaredTypes(String name, ClassIndex.NameKind kind, ResultConvertor<T> convertor, Set<? super T> result) throws IOException {
        if (!this.isValid(false)) {
            LOGGER.fine(String.format("LuceneIndex[%s] is invalid!\n", this.toString()));
            return;
        }
        assert (name != null);
        TreeSet<Term> toSearch = new TreeSet<Term>(new Comparator<Term>(){

            @Override
            public int compare(Term t1, Term t2) {
                int ret = t1.field().compareTo(t2.field());
                if (ret == 0) {
                    ret = t1.text().compareTo(t2.text());
                }
                return ret;
            }
        });
        IndexReader in = this.getReader();
        switch (kind) {
            case SIMPLE_NAME: {
                toSearch.add(DocumentUtil.simpleNameTerm(name));
                break;
            }
            case PREFIX: {
                if (name.length() == 0) {
                    this.emptyPrefixSearch(in, convertor, result);
                    return;
                }
                Term nameTerm = DocumentUtil.simpleNameTerm(name);
                this.prefixSearh(nameTerm, in, toSearch);
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                if (name.length() == 0) {
                    this.emptyPrefixSearch(in, convertor, result);
                    return;
                }
                Term nameTerm = DocumentUtil.caseInsensitiveNameTerm(name.toLowerCase());
                this.prefixSearh(nameTerm, in, toSearch);
                break;
            }
            case CAMEL_CASE: {
                if (name.length() == 0) {
                    throw new IllegalArgumentException();
                }
                StringBuilder patternString = new StringBuilder();
                char startChar = '\u0000';
                for (int i = 0; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    if (i == 0) {
                        startChar = c;
                    }
                    patternString.append(c);
                    if (i == name.length() - 1) {
                        patternString.append("\\w*");
                        continue;
                    }
                    patternString.append("[\\p{Lower}\\p{Digit}]*");
                }
                Pattern pattern = Pattern.compile(patternString.toString());
                this.regExpSearch(pattern, DocumentUtil.simpleNameTerm(Character.toString(startChar)), in, toSearch);
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                if (name.length() == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
                    throw new IllegalArgumentException();
                }
                Pattern pattern = Pattern.compile(name, 2);
                this.regExpSearch(pattern, DocumentUtil.caseInsensitiveNameTerm(name.toLowerCase()), in, toSearch);
                break;
            }
            case REGEXP: {
                if (name.length() == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
                    throw new IllegalArgumentException();
                }
                Pattern pattern = Pattern.compile(name);
                this.regExpSearch(pattern, DocumentUtil.simpleNameTerm(name), in, toSearch);
                break;
            }
            default: {
                throw new UnsupportedOperationException(kind.toString());
            }
        }
        TermDocs tds = in.termDocs();
        LOGGER.fine(String.format("LuceneIndex.getDeclaredTypes[%s] returned %d elements\n", this.toString(), toSearch.size()));
        Iterator it = toSearch.iterator();
        ElementKind[] kindHolder = new ElementKind[1];
        TreeSet<Integer> docNums = new TreeSet<Integer>();
        while (it.hasNext()) {
            tds.seek((Term)it.next());
            while (tds.next()) {
                docNums.add(tds.doc());
            }
        }
        for (Integer docNum : docNums) {
            Document doc = in.document(docNum);
            String binaryName = DocumentUtil.getBinaryName(doc, kindHolder);
            result.add(convertor.convert(kindHolder[0], binaryName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regExpSearch(Pattern pattern, Term startTerm, IndexReader in, Set<Term> toSearch) throws IOException {
        char c;
        String startText = startTerm.text();
        StringBuilder startBuilder = new StringBuilder();
        startBuilder.append(startText.charAt(0));
        for (int i = 1; i < startText.length() && Character.isJavaIdentifierPart(c = startText.charAt(i)); ++i) {
            startBuilder.append(c);
        }
        String startPrefix = startBuilder.toString();
        String camelField = startTerm.field();
        TermEnum en = in.terms(startTerm);
        try {
            Term term;
            while ((term = en.term()) != null && camelField == term.field() && term.text().startsWith(startPrefix)) {
                Matcher m = pattern.matcher(term.text());
                if (m.matches()) {
                    toSearch.add(term);
                }
                if (en.next()) continue;
                break;
            }
        }
        finally {
            en.close();
        }
    }

    private <T> void emptyPrefixSearch(IndexReader in, ResultConvertor<T> convertor, Set<? super T> result) throws IOException {
        int bound = in.maxDoc();
        ElementKind[] kindHolder = new ElementKind[1];
        for (int i = 0; i < bound; ++i) {
            String binaryName;
            Document doc;
            if (in.isDeleted(i) || (doc = in.document(i)) == null || (binaryName = DocumentUtil.getBinaryName(doc, kindHolder)) == null) continue;
            result.add(convertor.convert(kindHolder[0], binaryName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefixSearh(Term nameTerm, IndexReader in, Set<Term> toSearch) throws IOException {
        String prefixField = nameTerm.field();
        String name = nameTerm.text();
        TermEnum en = in.terms(nameTerm);
        try {
            Term term;
            while ((term = en.term()) != null && prefixField == term.field() && term.text().startsWith(name)) {
                toSearch.add(term);
                if (en.next()) continue;
                break;
            }
        }
        finally {
            en.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getPackageNames(String prefix, boolean directOnly, Set<String> result) throws IOException {
        if (!this.isValid(false)) {
            return;
        }
        IndexReader in = this.getReader();
        Term pkgTerm = DocumentUtil.packageNameTerm(prefix);
        String prefixField = pkgTerm.field();
        if (prefix.length() == 0) {
            if (directOnly && this.rootPkgCache != null) {
                result.addAll(this.rootPkgCache);
            } else {
                if (directOnly) {
                    this.rootPkgCache = new HashSet<String>();
                }
                TermEnum terms = in.terms();
                try {
                    do {
                        Term currentTerm;
                        if ((currentTerm = terms.term()) == null || prefixField != currentTerm.field()) continue;
                        String pkgName = currentTerm.text();
                        if (directOnly) {
                            int index = pkgName.indexOf(46, prefix.length());
                            if (index > 0) {
                                pkgName = pkgName.substring(0, index);
                            }
                            this.rootPkgCache.add(pkgName);
                        }
                        result.add(pkgName);
                    } while (terms.next());
                }
                finally {
                    terms.close();
                }
            }
        } else {
            TermEnum terms = in.terms(pkgTerm);
            try {
                Term currentTerm;
                while ((currentTerm = terms.term()) != null && prefixField == currentTerm.field() && currentTerm.text().startsWith(prefix)) {
                    int index;
                    String pkgName = currentTerm.text();
                    if (directOnly && (index = pkgName.indexOf(46, prefix.length())) > 0) {
                        pkgName = pkgName.substring(0, index);
                    }
                    result.add(pkgName);
                    if (terms.next()) continue;
                    break;
                }
            }
            finally {
                terms.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUpToDate(String resourceName, long timeStamp) throws IOException {
        if (!this.isValid(false)) {
            return false;
        }
        try {
            IndexSearcher searcher = new IndexSearcher(this.getReader());
            try {
                Hits hits;
                if (resourceName == null) {
                    LuceneIndex luceneIndex = this;
                    synchronized (luceneIndex) {
                        if (this.rootTimeStamp != null) {
                            boolean bl = this.rootTimeStamp >= timeStamp;
                            return bl;
                        }
                    }
                    hits = searcher.search(new TermQuery(DocumentUtil.rootDocumentTerm()));
                } else {
                    hits = searcher.search(DocumentUtil.binaryNameQuery(resourceName));
                }
                assert (hits.length() <= 1);
                if (hits.length() == 0) {
                    boolean bl = false;
                    return bl;
                }
                Hit hit = (Hit)hits.iterator().next();
                long cacheTime = DocumentUtil.getTimeStamp(hit.getDocument());
                if (resourceName == null) {
                    LuceneIndex luceneIndex = this;
                    synchronized (luceneIndex) {
                        this.rootTimeStamp = new Long(cacheTime);
                    }
                }
                boolean bl = cacheTime >= timeStamp;
                return bl;
            }
            finally {
                ((Searcher)searcher).close();
            }
        }
        catch (FileNotFoundException fnf) {
            this.clear();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Map<String, List<String>> refs, List<String> topLevels) throws IOException {
        this.rootPkgCache = null;
        boolean create = !this.isValid(false);
        long timeStamp = System.currentTimeMillis();
        if (!create) {
            IndexReader in = this.getReader();
            IndexSearcher searcher = new IndexSearcher(in);
            try {
                for (String topLevel : topLevels) {
                    Hits hits = searcher.search(DocumentUtil.binaryContentNameQuery(topLevel));
                    for (int i = 0; i < hits.length(); ++i) {
                        in.deleteDocument(hits.id(i));
                    }
                }
                in.deleteDocuments(DocumentUtil.rootDocumentTerm());
            }
            finally {
                ((Searcher)searcher).close();
            }
        }
        this.storeData(refs, create, timeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Map<String, List<String>> refs, Set<String> toDelete) throws IOException {
        this.rootPkgCache = null;
        boolean create = !this.isValid(false);
        long timeStamp = System.currentTimeMillis();
        if (!create) {
            IndexReader in = this.getReader();
            IndexSearcher searcher = new IndexSearcher(in);
            try {
                for (String toDeleteItem : toDelete) {
                    Hits hits = searcher.search(DocumentUtil.binaryNameQuery(toDeleteItem));
                    if (hits.length() > 1) {
                        LOGGER.warning("Multiple index entries for binaryName: " + toDeleteItem);
                    }
                    for (int i = 0; i < hits.length(); ++i) {
                        in.deleteDocument(hits.id(i));
                    }
                }
                in.deleteDocuments(DocumentUtil.rootDocumentTerm());
            }
            finally {
                ((Searcher)searcher).close();
            }
        }
        this.storeData(refs, create, timeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeData(Map<String, List<String>> refs, boolean create, long timeStamp) throws IOException {
        IndexWriter out = this.getWriter(create);
        try {
            LuceneIndexMBeanImpl indexSettings;
            if (debugIndexMerging) {
                out.setInfoStream(System.err);
            }
            if ((indexSettings = LuceneIndexMBeanImpl.getDefault()) != null) {
                out.setMergeFactor(indexSettings.getMergeFactor());
                out.setMaxMergeDocs(indexSettings.getMaxMergeDocs());
                out.setMaxBufferedDocs(indexSettings.getMaxBufferedDocs());
            }
            LowMemoryNotifier lm = LowMemoryNotifier.getDefault();
            LMListener lmListener = new LMListener();
            lm.addLowMemoryListener(lmListener);
            RAMDirectory memDir = null;
            IndexWriter activeOut = null;
            if (lmListener.lowMemory.getAndSet(false)) {
                activeOut = out;
            } else {
                memDir = new RAMDirectory();
                activeOut = new IndexWriter(memDir, (Analyzer)new KeywordAnalyzer(), true);
            }
            try {
                activeOut.addDocument(DocumentUtil.createRootTimeStampDocument(timeStamp));
                Iterator<Map.Entry<String, List<String>>> it = refs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, List<String>> refsEntry = it.next();
                    it.remove();
                    String cn = refsEntry.getKey();
                    List<String> cr = refsEntry.getValue();
                    Document newDoc = DocumentUtil.createDocument(cn, timeStamp, cr);
                    activeOut.addDocument(newDoc);
                    if (memDir == null || !lmListener.lowMemory.getAndSet(false)) continue;
                    activeOut.close();
                    out.addIndexes(new Directory[]{memDir});
                    memDir = new RAMDirectory();
                    activeOut = new IndexWriter(memDir, (Analyzer)new KeywordAnalyzer(), true);
                }
                if (memDir != null) {
                    activeOut.close();
                    out.addIndexes(new Directory[]{memDir});
                    activeOut = null;
                    memDir = null;
                }
                LuceneIndex luceneIndex = this;
                synchronized (luceneIndex) {
                    this.rootTimeStamp = new Long(timeStamp);
                }
            }
            finally {
                lm.removeLowMemoryListener(lmListener);
            }
        }
        finally {
            out.close();
        }
    }

    @Override
    public boolean isValid(boolean tryOpen) throws IOException {
        boolean res = IndexReader.indexExists(this.directory);
        if (res && tryOpen) {
            try {
                this.getReader();
            }
            catch (IOException e) {
                res = false;
                this.clear();
            }
        }
        return res;
    }

    @Override
    public synchronized void clear() throws IOException {
        String[] content;
        this.close();
        for (String file : content = this.directory.list()) {
            this.directory.deleteFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        finally {
            this.directory.close();
        }
    }

    public String toString() {
        return this.directory.toString();
    }

    private synchronized IndexReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = IndexReader.open(this.directory);
        }
        return this.reader;
    }

    private synchronized IndexWriter getWriter(boolean create) throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        IndexWriter writer = new IndexWriter(this.directory, (Analyzer)new KeywordAnalyzer(), create);
        return writer;
    }

    private static File getReferencesCacheFolder(File cacheRoot) throws IOException {
        File refRoot = new File(cacheRoot, REFERENCES);
        if (!refRoot.exists()) {
            refRoot.mkdir();
        }
        return refRoot;
    }

    private static class LMListener
    implements LowMemoryListener {
        private AtomicBoolean lowMemory = new AtomicBoolean(false);

        private LMListener() {
        }

        public void lowMemory(LowMemoryEvent event) {
            this.lowMemory.set(true);
        }
    }
}

