/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.SymbolDumper;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceAnalyser {
    private final Index index;
    private final Map<String, List<String>> references;
    private final Set<String> toDelete;

    public SourceAnalyser(Index index) {
        assert (index != null);
        this.index = index;
        this.references = new HashMap<String, List<String>>();
        this.toDelete = new HashSet<String>();
    }

    public void store() throws IOException {
        if (this.references.size() > 0 || this.toDelete.size() > 0) {
            this.index.store(this.references, this.toDelete);
            this.references.clear();
            this.toDelete.clear();
        }
    }

    public boolean isValid() throws IOException {
        return this.index.isValid(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyse(Iterable<? extends CompilationUnitTree> data, JavacTaskImpl jt, JavaFileManager manager, JavaFileObject sibling, Set<? super ElementHandle<TypeElement>> newTypes) throws IOException {
        HashMap<String, Map<String, Set<ClassIndexImpl.UsageType>>> usages = new HashMap<String, Map<String, Set<ClassIndexImpl.UsageType>>>();
        for (CompilationUnitTree compilationUnitTree : data) {
            UsagesVisitor uv = new UsagesVisitor(jt, compilationUnitTree, manager, sibling, newTypes);
            uv.scan((Tree)compilationUnitTree, (Map<String, Map<String, Set<ClassIndexImpl.UsageType>>>)usages);
            if (uv.rsList == null || uv.rsList.size() <= 0) continue;
            int index = uv.sourceName.lastIndexOf(46);
            String pkg = index == -1 ? "" : uv.sourceName.substring(0, index);
            String rsName = (index == -1 ? uv.sourceName : uv.sourceName.substring(index + 1)) + '.' + "rs";
            FileObject fo = manager.getFileForOutput(StandardLocation.CLASS_OUTPUT, pkg, rsName, sibling);
            assert (fo != null);
            BufferedReader in = new BufferedReader(fo.openReader(false));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    uv.rsList.add(line);
                }
            }
            finally {
                in.close();
            }
            PrintWriter rsOut = new PrintWriter(fo.openWriter());
            try {
                for (String sig : uv.rsList) {
                    rsOut.println(sig);
                }
            }
            finally {
                rsOut.close();
            }
        }
        for (Map.Entry entry : usages.entrySet()) {
            List<String> ru = this.getClassReferences((String)entry.getKey());
            Map oeValue = (Map)entry.getValue();
            for (Map.Entry ue : oeValue.entrySet()) {
                ru.add(DocumentUtil.encodeUsage((String)ue.getKey(), (Set)ue.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyseUnitAndStore(CompilationUnitTree cu, JavacTaskImpl jt) throws IOException {
        try {
            HashMap<String, Map<String, Set<ClassIndexImpl.UsageType>>> usages = new HashMap<String, Map<String, Set<ClassIndexImpl.UsageType>>>();
            ArrayList<String> topLevels = new ArrayList<String>();
            UsagesVisitor uv = new UsagesVisitor(jt, cu, topLevels);
            uv.scan((Tree)cu, (Map<String, Map<String, Set<ClassIndexImpl.UsageType>>>)usages);
            for (Map.Entry oe : usages.entrySet()) {
                String className = (String)oe.getKey();
                List<String> ru = this.getClassReferences(className);
                Map oeValue = (Map)oe.getValue();
                for (Map.Entry ue : oeValue.entrySet()) {
                    ru.add(DocumentUtil.encodeUsage((String)ue.getKey(), (Set)ue.getValue()));
                }
            }
            this.index.store(this.references, topLevels);
        }
        finally {
            this.references.clear();
        }
    }

    public void delete(String className) throws IOException {
        if (!this.index.isValid(false)) {
            return;
        }
        this.toDelete.add(className);
    }

    private List<String> getClassReferences(String className) {
        assert (className != null);
        List<String> result = this.references.get(className);
        if (result == null) {
            result = new LinkedList<String>();
            this.references.put(className, result);
        }
        return result;
    }

    private static void dumpUsages(Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> usages) throws IOException {
        assert (usages != null);
        for (Map.Entry<String, Map<String, Set<ClassIndexImpl.UsageType>>> oe : usages.entrySet()) {
            System.out.println("Usages in class: " + oe.getKey());
            for (Map.Entry<String, Set<ClassIndexImpl.UsageType>> ue : oe.getValue().entrySet()) {
                System.out.println("\t" + ue.getKey() + "\t: " + ue.getValue().toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UsagesVisitor
    extends TreeScanner<Void, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>>> {
        private final Stack<String> activeClass;
        private JavaFileManager manager;
        private final JavacTaskImpl jt;
        private final Name errorName;
        private final CompilationUnitTree cu;
        private final Types types;
        private final JavaFileObject sibling;
        private final String sourceName;
        private final boolean signatureFiles;
        private final List<? super String> topLevels;
        private final Set<? super ElementHandle<TypeElement>> newTypes;
        private State state;
        private Element enclosingElement = null;
        private Set<String> rsList;

        public UsagesVisitor(JavacTaskImpl jt, CompilationUnitTree cu, JavaFileManager manager, JavaFileObject sibling, Set<? super ElementHandle<TypeElement>> newTypes) {
            assert (jt != null);
            assert (cu != null);
            assert (manager != null);
            assert (sibling != null);
            this.activeClass = new Stack();
            this.jt = jt;
            this.errorName = Name.Table.instance((Context)jt.getContext()).error;
            this.state = State.OTHER;
            this.types = Types.instance(jt.getContext());
            this.cu = cu;
            this.signatureFiles = true;
            this.manager = manager;
            this.sibling = sibling;
            this.sourceName = this.manager.inferBinaryName(StandardLocation.SOURCE_PATH, this.sibling);
            this.topLevels = null;
            this.newTypes = newTypes;
        }

        protected UsagesVisitor(JavacTaskImpl jt, CompilationUnitTree cu, List<? super String> topLevels) {
            assert (jt != null);
            assert (cu != null);
            this.activeClass = new Stack();
            this.jt = jt;
            this.errorName = Name.Table.instance((Context)jt.getContext()).error;
            this.state = State.OTHER;
            this.types = Types.instance(jt.getContext());
            this.cu = cu;
            this.signatureFiles = false;
            this.manager = null;
            this.sibling = null;
            this.sourceName = "";
            this.topLevels = topLevels;
            this.newTypes = null;
        }

        final Types getTypes() {
            return this.types;
        }

        @Override
        public Void scan(Tree node, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> p) {
            if (node == null) {
                return null;
            }
            super.scan(node, p);
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> p) {
            this.handleVisitIdentSelect(((JCTree.JCFieldAccess)node).sym, p);
            State oldState = this.state;
            this.state = State.OTHER;
            Void ret = (Void)super.visitMemberSelect(node, p);
            this.state = oldState;
            return ret;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> p) {
            this.handleVisitIdentSelect(((JCTree.JCIdent)node).sym, p);
            return (Void)super.visitIdentifier(node, p);
        }

        private void handleVisitIdentSelect(Symbol sym, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> p) {
            if (!this.activeClass.empty() && sym != null) {
                Symbol owner;
                String className;
                if (sym.getKind().isClass() || sym.getKind().isInterface()) {
                    String className2 = UsagesVisitor.encodeClassName(sym);
                    if (className2 != null) {
                        switch (this.state) {
                            case EXTENDS: {
                                this.addUsage(this.activeClass.peek(), className2, p, ClassIndexImpl.UsageType.SUPER_CLASS);
                                break;
                            }
                            case IMPLEMENTS: {
                                this.addUsage(this.activeClass.peek(), className2, p, ClassIndexImpl.UsageType.SUPER_INTERFACE);
                                break;
                            }
                            case OTHER: 
                            case GT: {
                                this.addUsage(this.activeClass.peek(), className2, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                            }
                        }
                    }
                } else if (sym.getKind().isField()) {
                    Symbol owner2 = sym.getEnclosingElement();
                    String className3 = UsagesVisitor.encodeClassName(owner2);
                    if (className3 != null) {
                        this.addUsage(this.activeClass.peek(), className3, p, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                    }
                } else if ((sym.getKind() == ElementKind.CONSTRUCTOR || sym.getKind() == ElementKind.METHOD) && (className = UsagesVisitor.encodeClassName(owner = sym.getEnclosingElement())) != null) {
                    this.addUsage(this.activeClass.peek(), className, p, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                }
            }
        }

        @Override
        public Void visitParameterizedType(ParameterizedTypeTree node, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> p) {
            this.scan(node.getType(), p);
            State currState = this.state;
            this.state = State.GT;
            this.scan(node.getTypeArguments(), p);
            this.state = currState;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dump(TypeElement clazz, String className, Element enclosingElement) {
            PrintWriter output = null;
            if (this.rsList != null) {
                this.rsList.add(className);
            }
            try {
                JavaFileObject jfo = this.manager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, className, JavaFileObject.Kind.CLASS, this.sibling);
                output = new PrintWriter(new OutputStreamWriter(jfo.openOutputStream(), "UTF-8"));
                SymbolDumper.dump(output, this.types, clazz, enclosingElement);
                output.close();
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }

        protected boolean shouldGenerate(String binaryName, Symbol.ClassSymbol sym) {
            if (!this.signatureFiles || binaryName == null) {
                return false;
            }
            if (sym.getQualifiedName().isEmpty()) {
                return true;
            }
            for (Element enclosing = sym.getEnclosingElement(); enclosing != null && ((Symbol)enclosing).getKind() != ElementKind.PACKAGE; enclosing = ((Symbol)enclosing).getEnclosingElement()) {
                if (((Symbol)enclosing).getKind().isClass() || ((Symbol)enclosing).getKind().isInterface()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitClass(ClassTree node, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> p) {
            Symbol.ClassSymbol sym = ((JCTree.JCClassDecl)node).sym;
            boolean errorInDecl = false;
            boolean errorIgnorSubtree = true;
            String className = null;
            if (sym != null) {
                errorInDecl = this.hasErrorName(sym);
                if (errorInDecl) {
                    if (this.activeClass.size() > 0) {
                        this.activeClass.push((String)this.activeClass.get(0));
                        errorIgnorSubtree = false;
                    } else {
                        URI uri;
                        JavaFileObject jfo;
                        if (this.cu instanceof JCTree.JCCompilationUnit && (jfo = ((JCTree.JCCompilationUnit)this.cu).sourcefile) != null && (uri = jfo.toUri()) != null && uri.isAbsolute()) {
                            try {
                                ClassPath cp;
                                org.openide.filesystems.FileObject fo = URLMapper.findFileObject((URL)uri.toURL());
                                if (fo != null && (cp = ClassPath.getClassPath((org.openide.filesystems.FileObject)fo, (String)"classpath/source")) != null) {
                                    className = cp.getResourceName(fo, '.', false);
                                }
                            }
                            catch (MalformedURLException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                        if (className != null) {
                            String classNameType = className + DocumentUtil.encodeKind(ElementKind.CLASS);
                            if (this.topLevels != null && this.activeClass.isEmpty()) {
                                this.topLevels.add(className);
                            }
                            this.activeClass.push(classNameType);
                            errorIgnorSubtree = false;
                            this.addUsage(classNameType, className, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                            if (this.newTypes != null) {
                                this.newTypes.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, className));
                            }
                        } else {
                            Logger.getLogger("global").warning(String.format("Cannot resolve %s, ignoring whole subtree.\n", sym.toString()));
                        }
                    }
                } else {
                    StringBuilder classNameBuilder = new StringBuilder();
                    ClassFileUtil.encodeClassName(sym, classNameBuilder, '.');
                    className = classNameBuilder.toString();
                    ElementKind kind = sym.getKind();
                    classNameBuilder.append(DocumentUtil.encodeKind(kind));
                    String classNameType = classNameBuilder.toString();
                    if (this.signatureFiles && this.activeClass.isEmpty() && !className.equals(this.sourceName)) {
                        this.rsList = new HashSet<String>();
                    }
                    if (this.topLevels != null && this.activeClass.isEmpty()) {
                        this.topLevels.add(className);
                    }
                    this.activeClass.push(classNameType);
                    errorIgnorSubtree = false;
                    this.addUsage(classNameType, className, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    if (this.newTypes != null) {
                        this.newTypes.add(ElementHandleAccessor.INSTANCE.create(kind, className));
                    }
                }
            }
            if (!errorIgnorSubtree) {
                Element old = this.enclosingElement;
                try {
                    this.enclosingElement = sym;
                    this.scan((Tree)node.getModifiers(), p);
                    this.scan(node.getTypeParameters(), p);
                    this.state = errorInDecl ? State.OTHER : State.EXTENDS;
                    this.scan(node.getExtendsClause(), p);
                    this.state = errorInDecl ? State.OTHER : State.IMPLEMENTS;
                    this.scan(node.getImplementsClause(), p);
                    this.state = State.OTHER;
                    this.scan(node.getMembers(), p);
                    this.activeClass.pop();
                }
                finally {
                    this.enclosingElement = old;
                }
            }
            if (!errorInDecl && this.shouldGenerate(className, sym)) {
                this.dump(sym, className, this.enclosingElement);
            }
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree node, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> p) {
            String className;
            Symbol owner;
            Symbol sym = ((JCTree.JCNewClass)node).constructor;
            if (sym != null && (owner = sym.getEnclosingElement()) != null && owner.getKind().isClass() && (className = UsagesVisitor.encodeClassName(owner)) != null) {
                this.addUsage(this.activeClass.peek(), className, p, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            return (Void)super.visitNewClass(node, p);
        }

        @Override
        public Void visitErroneous(ErroneousTree tree, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> p) {
            List<? extends Tree> trees = tree.getErrorTrees();
            for (Tree tree2 : trees) {
                this.scan(tree2, p);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitMethod(MethodTree node, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> p) {
            Element old = this.enclosingElement;
            try {
                this.enclosingElement = ((JCTree.JCMethodDecl)node).sym;
                Void void_ = (Void)super.visitMethod(node, p);
                return void_;
            }
            finally {
                this.enclosingElement = old;
            }
        }

        private void addUsage(String ownerName, String className, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map, ClassIndexImpl.UsageType type) {
            Set<ClassIndexImpl.UsageType> usageType;
            assert (className != null);
            assert (map != null);
            assert (type != null);
            Map<String, Set<ClassIndexImpl.UsageType>> tUsages = map.get(ownerName);
            if (tUsages == null) {
                tUsages = new HashMap<String, Set<ClassIndexImpl.UsageType>>();
                map.put(ownerName, tUsages);
            }
            if ((usageType = tUsages.get(className)) == null) {
                usageType = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
                tUsages.put(className, usageType);
            }
            usageType.add(type);
        }

        private boolean hasErrorName(Symbol cs) {
            while (cs != null) {
                if (cs.name == this.errorName) {
                    return true;
                }
                cs = cs.getEnclosingElement();
            }
            return false;
        }

        private static String encodeClassName(Symbol sym) {
            assert (sym instanceof Symbol.ClassSymbol);
            TypeElement toEncode = null;
            TypeMirror type = ((Symbol.ClassSymbol)sym).asType();
            if (sym.getEnclosingElement().getKind() == ElementKind.TYPE_PARAMETER) {
                TypeMirror ctype;
                if (type.getKind() == TypeKind.ARRAY && (ctype = ((ArrayType)type).getComponentType()).getKind() == TypeKind.DECLARED) {
                    toEncode = (TypeElement)((DeclaredType)ctype).asElement();
                }
            } else {
                toEncode = (TypeElement)((Object)sym);
            }
            return toEncode == null ? null : ClassFileUtil.encodeClassName(toEncode);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            EXTENDS,
            IMPLEMENTS,
            GT,
            OTHER;

        }
    }
}

