/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.netbeans.modules.java.source.usages.ClassFileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolDumper
extends SimpleTypeVisitor6<Void, Boolean> {
    private PrintWriter output;
    private Types types;

    public SymbolDumper(PrintWriter output, Types types) {
        this.output = output;
        this.types = types;
    }

    @Override
    public Void visitPrimitive(PrimitiveType t, Boolean p) {
        switch (t.getKind()) {
            case BOOLEAN: {
                this.output.append('Z');
                break;
            }
            case BYTE: {
                this.output.append('B');
                break;
            }
            case SHORT: {
                this.output.append('S');
                break;
            }
            case INT: {
                this.output.append('I');
                break;
            }
            case LONG: {
                this.output.append('J');
                break;
            }
            case CHAR: {
                this.output.append('C');
                break;
            }
            case FLOAT: {
                this.output.append('F');
                break;
            }
            case DOUBLE: {
                this.output.append('D');
                break;
            }
            default: {
                throw new IllegalArgumentException("Should not happend. Or can it?");
            }
        }
        return null;
    }

    @Override
    public Void visitNoType(NoType t, Boolean p) {
        switch (t.getKind()) {
            case VOID: {
                this.output.append('V');
                break;
            }
            case PACKAGE: {
                new Exception("what should be printed here?").printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Void visitNull(NullType t, Boolean p) {
        new Exception("what should be printed here?").printStackTrace();
        return null;
    }

    @Override
    public Void visitArray(ArrayType t, Boolean p) {
        this.output.append('[');
        this.visit(t.getComponentType());
        return null;
    }

    @Override
    public Void visitDeclared(DeclaredType t, Boolean p) {
        if (t.getEnclosingType() != null && t.getEnclosingType().getKind() == TypeKind.DECLARED) {
            this.visit(t.getEnclosingType(), Boolean.TRUE);
            this.output.append('$');
            this.output.append(t.asElement().getSimpleName());
        } else {
            this.output.append('L');
            this.output.append(ClassFileUtil.encodeClassName((TypeElement)t.asElement()));
        }
        List<? extends TypeMirror> actualTypeParameters = t.getTypeArguments();
        if (!actualTypeParameters.isEmpty()) {
            this.output.append('<');
            for (TypeMirror typeMirror : actualTypeParameters) {
                this.visit(typeMirror);
            }
            this.output.append('>');
        }
        if (p != Boolean.TRUE) {
            this.output.append(';');
        }
        return null;
    }

    @Override
    public Void visitError(ErrorType t, Boolean p) {
        TypeElement te = (TypeElement)t.asElement();
        this.output.append('R');
        if (te != null) {
            this.output.append(te.getSimpleName().toString());
        }
        this.output.append(';');
        return null;
    }

    @Override
    public Void visitTypeVariable(TypeVariable t, Boolean p) {
        if (p == Boolean.TRUE) {
            this.output.append(t.asElement().getSimpleName().toString());
            this.output.append(':');
            assert (t.getLowerBound().getKind() == TypeKind.NULL) : "currently not handled!";
            Type boundImpl = (Type)t.getUpperBound();
            if (boundImpl.isCompound()) {
                if (boundImpl.getKind() == TypeKind.EXECUTABLE || boundImpl.getKind() == TypeKind.PACKAGE) {
                    throw new IllegalArgumentException(boundImpl.toString());
                }
                Type sup = this.types.supertype(boundImpl);
                this.visit(sup == Type.noType || sup == boundImpl || sup == null ? this.types.interfaces(boundImpl) : this.types.interfaces(boundImpl).prepend(sup));
            } else {
                this.visit(t.getUpperBound());
            }
            this.output.append(';');
        } else {
            this.output.append('Q');
            this.output.append(t.asElement().getSimpleName().toString());
            this.output.append(';');
        }
        return null;
    }

    @Override
    public Void visitWildcard(WildcardType t, Boolean p) {
        boolean wasSomething = false;
        if (t.getExtendsBound() != null) {
            this.output.append("+");
            this.visit(t.getExtendsBound());
            wasSomething = true;
        }
        if (t.getSuperBound() != null) {
            this.output.append("-");
            this.visit(t.getSuperBound());
            wasSomething = true;
        }
        if (!wasSomething) {
            this.output.append('?');
        }
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableType t, Boolean p) {
        throw new IllegalStateException("This cannot be handled correctly, and should hopefully never happen...");
    }

    @Override
    public Void visitUnknown(TypeMirror t, Boolean p) {
        new Exception("what should be printed here?").printStackTrace();
        return null;
    }

    public void visit(List<? extends TypeMirror> l) {
        for (TypeMirror typeMirror : l) {
            this.visit(typeMirror);
        }
    }

    public void visit(List<? extends TypeMirror> l, Boolean p) {
        for (TypeMirror typeMirror : l) {
            this.visit(typeMirror, p);
        }
    }

    public static void dump(PrintWriter output, Types types, TypeElement type, Element enclosingElement) {
        SymbolDumper.dumpImpl(output, types, type, enclosingElement);
        output.append('\n');
        for (Element element : type.getEnclosedElements()) {
            if (element.getKind().isClass() || element.getKind().isInterface()) continue;
            SymbolDumper.dumpImpl(output, types, element);
        }
        output.append('W');
        SymbolDumper.dumpAnnotations(new SymbolDumper(output, types), type);
    }

    private static void dumpImpl(PrintWriter output, Types types, TypeElement type, Element enclosingElement) {
        SymbolDumper d = new SymbolDumper(output, types);
        output.append('G');
        SymbolDumper.dumpFlags(output, ((Symbol)((Object)type)).flags_field & 0xFFFFFF7FEFFFFFFFL);
        List<? extends TypeParameterElement> params = type.getTypeParameters();
        if (!params.isEmpty()) {
            output.append('<');
            for (TypeParameterElement typeParameterElement : params) {
                d.visit(typeParameterElement.asType(), Boolean.TRUE);
            }
            output.append('>');
        }
        SymbolDumper.dumpName(output, ClassFileUtil.encodeClassName(type));
        SymbolDumper.dumpEnclosingElement(d, enclosingElement);
        TypeMirror tm = type.getSuperclass();
        if (tm.getKind() != TypeKind.NONE) {
            d.visit(tm);
        } else if (!"java.lang.Object".equals(type.getQualifiedName().toString())) {
            output.append("Ljava.lang.Object;");
        } else {
            output.append(";");
        }
        d.visit(type.getInterfaces());
        output.append(';');
        SymbolDumper.dumpInnerclasses(output, ElementFilter.typesIn(type.getEnclosedElements()));
    }

    private static void dumpEnclosingElement(SymbolDumper dumper, Element enclosingElement) {
        if (enclosingElement != null) {
            if (enclosingElement.getKind().isClass() || enclosingElement.getKind().isInterface()) {
                SymbolDumper.dumpName(dumper.output, ClassFileUtil.encodeClassName((TypeElement)enclosingElement));
            } else {
                SymbolDumper.dumpName(dumper.output, ClassFileUtil.encodeClassName((TypeElement)enclosingElement.getEnclosingElement()));
                ExecutableElement enclosingMethod = (ExecutableElement)enclosingElement;
                SymbolDumper.dumpName(dumper.output, enclosingMethod.getSimpleName());
                ExecutableType enclosingMethodType = (ExecutableType)((Object)((Symbol)((Object)enclosingMethod)).externalType(dumper.types));
                dumper.output.append('(');
                dumper.visit(enclosingMethodType.getParameterTypes());
                dumper.output.append(')');
                dumper.output.append('(');
                dumper.visit(enclosingMethodType.getThrownTypes());
                dumper.output.append(')');
                dumper.visit(enclosingMethodType.getReturnType());
            }
        }
        dumper.output.append(';');
    }

    private static void dumpInnerclasses(PrintWriter output, List<TypeElement> innerClasses) {
        for (TypeElement innerClass : innerClasses) {
            SymbolDumper.dumpName(output, innerClass.getSimpleName());
            SymbolDumper.dumpFlags(output, ((Symbol)((Object)innerClass)).flags_field & 0xFFFFFF7FEFFFFFFFL);
        }
        output.append(';');
    }

    private static void dumpImpl(PrintWriter output, Types types, Element el) {
        if (el.getKind().isField()) {
            SymbolDumper.dumpImpl(output, types, (VariableElement)el);
            output.append('\n');
            return;
        }
        if (el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR) {
            SymbolDumper.dumpImpl(output, types, (ExecutableElement)el);
            output.append('\n');
            return;
        }
        Logger.getLogger(SymbolDumper.class.getName()).info("Unhandled ElementKind: " + (Object)((Object)el.getKind()));
    }

    private static void dumpImpl(PrintWriter output, Types types, VariableElement variable) {
        SymbolDumper d;
        block13: {
            block12: {
                d = new SymbolDumper(output, types);
                output.append('A');
                SymbolDumper.dumpFlags(output, ((Symbol)((Object)variable)).flags_field);
                d.visit(variable.asType());
                SymbolDumper.dumpName(output, variable.getSimpleName());
                if (!variable.getModifiers().contains((Object)Modifier.STATIC) || variable.getConstantValue() == null) break block12;
                switch (variable.asType().getKind()) {
                    case BOOLEAN: {
                        output.append('Z');
                        output.append(String.valueOf(variable.getConstantValue()));
                        break;
                    }
                    case BYTE: {
                        output.append('B');
                        output.append(String.valueOf(variable.getConstantValue()));
                        break;
                    }
                    case SHORT: {
                        output.append('S');
                        output.append(String.valueOf(variable.getConstantValue()));
                        break;
                    }
                    case INT: {
                        output.append('I');
                        output.append(String.valueOf(variable.getConstantValue()));
                        break;
                    }
                    case LONG: {
                        output.append('J');
                        output.append(String.valueOf(variable.getConstantValue()));
                        break;
                    }
                    case CHAR: {
                        output.append('C');
                        SymbolDumper.appendEscapedString(output, String.valueOf(variable.getConstantValue()));
                        break;
                    }
                    case FLOAT: {
                        output.append('F');
                        output.append(String.valueOf(variable.getConstantValue()));
                        break;
                    }
                    case DOUBLE: {
                        output.append('D');
                        output.append(String.valueOf(variable.getConstantValue()));
                        break;
                    }
                    case DECLARED: {
                        output.append('L');
                        TypeMirror varType = variable.asType();
                        if (varType.getKind() == TypeKind.DECLARED && "java.lang.String".equals(((TypeElement)((DeclaredType)varType).asElement()).getQualifiedName().toString())) {
                            SymbolDumper.appendEscapedString(output, String.valueOf(variable.getConstantValue()));
                            break;
                        }
                        break block13;
                    }
                    default: {
                        output.append("X");
                        break;
                    }
                }
                break block13;
            }
            output.append("X");
        }
        output.append(";");
        SymbolDumper.dumpAnnotations(d, variable);
    }

    private static void dumpImpl(PrintWriter output, Types types, ExecutableElement executable) {
        SymbolDumper d = new SymbolDumper(output, types);
        ExecutableType type = (ExecutableType)executable.asType();
        output.append('E');
        SymbolDumper.dumpFlags(output, ((Symbol)((Object)executable)).flags_field);
        SymbolDumper.dumpTypeVariables(d, type.getTypeVariables());
        SymbolDumper.dumpName(output, executable.getSimpleName());
        output.append('(');
        List<? extends TypeMirror> paramTypes = type.getParameterTypes();
        List<? extends VariableElement> paramElems = executable.getParameters();
        assert (paramElems.size() == paramTypes.size());
        for (int cntr = 0; cntr < paramTypes.size(); ++cntr) {
            SymbolDumper.dumpFlags(output, ((Symbol)((Object)paramElems.get((int)cntr))).flags_field);
            d.visit(paramTypes.get(cntr), Boolean.FALSE);
            SymbolDumper.dumpName(output, paramElems.get(cntr).getSimpleName());
        }
        output.append(')');
        output.append('(');
        for (TypeMirror typeMirror : executable.getThrownTypes()) {
            d.visit(typeMirror);
        }
        output.append(')');
        d.visit(type.getReturnType());
        SymbolDumper.dumpAnnotations(d, executable);
        AnnotationValue value = executable.getDefaultValue();
        if (value != null) {
            new AnnotationValueVisitorImpl().visit(value, d);
        } else {
            output.append(';');
        }
    }

    private static void appendEscapedString(PrintWriter output, String value) {
        value = value.replaceAll("\\\\", "\\\\\\\\");
        value = value.replaceAll("@", "\\\\a");
        value = value.replaceAll(";", "\\\\b");
        StringBuffer result = new StringBuffer();
        for (int cntr = 0; cntr < value.length(); ++cntr) {
            char c = value.charAt(cntr);
            if (c < ' ') {
                result.append('\\');
                String v = Integer.toHexString(c);
                result.append("0000".substring(0, 4 - v.length()));
                result.append(v);
                continue;
            }
            result.append(c);
        }
        output.append(result.toString());
    }

    private static void dumpName(PrintWriter output, CharSequence name) {
        output.append('N');
        output.append(((Object)name).toString());
        output.append(';');
    }

    private static void dumpTypeVariables(SymbolDumper dumper, List<? extends TypeVariable> params) {
        if (params.isEmpty()) {
            return;
        }
        dumper.output.append('<');
        dumper.visit(params, Boolean.TRUE);
        dumper.output.append('>');
    }

    private static void dumpFlags(PrintWriter output, long flags) {
        output.append('M');
        output.append(Long.toHexString(flags));
        output.append(';');
    }

    private static void dumpAnnotations(SymbolDumper d, Element e) {
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            SymbolDumper.dumpAnnotation(d, annotationMirror);
        }
        d.output.append(';');
    }

    private static void dumpAnnotation(SymbolDumper d, AnnotationMirror m) {
        d.visit(m.getAnnotationType());
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : m.getElementValues().entrySet()) {
            SymbolDumper.dumpName(d.output, entry.getKey().getSimpleName().toString());
            new AnnotationValueVisitorImpl().visit(entry.getValue(), d);
        }
        d.output.append(';');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationValueVisitorImpl
    extends SimpleAnnotationValueVisitor6<Void, SymbolDumper> {
        private AnnotationValueVisitorImpl() {
        }

        @Override
        public Void visitBoolean(boolean b, SymbolDumper d) {
            d.output.append('Z');
            d.output.append(String.valueOf(b));
            d.output.append(';');
            return null;
        }

        @Override
        public Void visitByte(byte b, SymbolDumper d) {
            d.output.append('B');
            d.output.append(String.valueOf(b));
            d.output.append(';');
            return null;
        }

        @Override
        public Void visitChar(char c, SymbolDumper d) {
            d.output.append('C');
            SymbolDumper.appendEscapedString(d.output, String.valueOf(c));
            d.output.append(';');
            return null;
        }

        @Override
        public Void visitDouble(double v, SymbolDumper d) {
            d.output.append('D');
            d.output.append(String.valueOf(v));
            d.output.append(';');
            return null;
        }

        @Override
        public Void visitFloat(float f, SymbolDumper d) {
            d.output.append('F');
            d.output.append(String.valueOf(f));
            d.output.append(';');
            return null;
        }

        @Override
        public Void visitInt(int i, SymbolDumper d) {
            d.output.append('I');
            d.output.append(String.valueOf(i));
            d.output.append(';');
            return null;
        }

        @Override
        public Void visitLong(long i, SymbolDumper d) {
            d.output.append('J');
            d.output.append(String.valueOf(i));
            d.output.append(';');
            return null;
        }

        @Override
        public Void visitShort(short s, SymbolDumper d) {
            d.output.append('S');
            d.output.append(String.valueOf(s));
            d.output.append(';');
            return null;
        }

        @Override
        public Void visitString(String s, SymbolDumper d) {
            d.output.append('L');
            SymbolDumper.appendEscapedString(d.output, String.valueOf(s));
            d.output.append(';');
            return null;
        }

        @Override
        public Void visitType(TypeMirror t, SymbolDumper p) {
            p.output.append('Y');
            p.visit(t);
            return null;
        }

        @Override
        public Void visitEnumConstant(VariableElement c, SymbolDumper d) {
            d.output.append('O');
            d.visit(c.getEnclosingElement().asType());
            SymbolDumper.dumpName(d.output, c.getSimpleName());
            return null;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a, SymbolDumper d) {
            d.output.append('P');
            SymbolDumper.dumpAnnotation(d, a);
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> vals, SymbolDumper d) {
            d.output.append('[');
            for (AnnotationValue annotationValue : vals) {
                this.visit(annotationValue, d);
            }
            d.output.append(';');
            return null;
        }

        @Override
        public Void visitUnknown(AnnotationValue av, SymbolDumper p) {
            throw new UnsupportedOperationException("SymbolDumper should be fixed to incorporate unknown value: " + av);
        }
    }
}

