/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.ui.FmtOptions;
import org.netbeans.modules.java.ui.FormatingOptionsPanel;
import org.openide.util.NbBundle;

public class FmtSpaces
extends JPanel
implements TreeCellRenderer,
MouseListener,
KeyListener {
    private static Controller controller;
    private DefaultTreeModel model;
    private DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();
    private JCheckBox renderer = new JCheckBox();
    private JTree cfgTree;
    private JScrollPane jScrollPane1;

    public FmtSpaces() {
        this.initComponents();
        this.model = this.createModel();
        this.cfgTree.setModel(this.model);
        this.cfgTree.setRootVisible(false);
        this.cfgTree.setShowsRootHandles(true);
        this.cfgTree.setCellRenderer(this);
        this.cfgTree.setEditable(false);
        this.cfgTree.addMouseListener(this);
        this.cfgTree.addKeyListener(this);
        this.dr.setIcon(null);
        this.dr.setOpenIcon(null);
        this.dr.setClosedIcon(null);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.model.getRoot();
        for (int i = root.getChildCount(); i >= 0; --i) {
            this.cfgTree.expandRow(i);
        }
    }

    public static FormatingOptionsPanel.Category getController() {
        if (controller == null) {
            controller = new Controller();
        }
        return controller;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.cfgTree = new JTree();
        this.setLayout(new GridBagLayout());
        this.cfgTree.setRootVisible(false);
        this.jScrollPane1.setViewportView(this.cfgTree);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Item item;
        this.renderer.setBackground(selected ? this.dr.getBackgroundSelectionColor() : this.dr.getBackgroundNonSelectionColor());
        this.renderer.setForeground(selected ? this.dr.getTextSelectionColor() : this.dr.getTextNonSelectionColor());
        this.renderer.setEnabled(true);
        Object data = ((DefaultMutableTreeNode)value).getUserObject();
        if (data instanceof Item) {
            item = (Item)data;
            if (((DefaultMutableTreeNode)value).getAllowsChildren()) {
                Component c = this.dr.getTreeCellRendererComponent(tree, value, leaf, expanded, leaf, row, hasFocus);
                return c;
            }
        } else {
            Component c = this.dr.getTreeCellRendererComponent(tree, value, leaf, expanded, leaf, row, hasFocus);
            return c;
        }
        this.renderer.setText(item.displayName);
        this.renderer.setSelected(item.value);
        return this.renderer;
    }

    public void mouseClicked(MouseEvent e) {
        Rectangle r;
        Point p = e.getPoint();
        TreePath path = this.cfgTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
        if (path != null && (r = this.cfgTree.getPathBounds(path)) != null) {
            r.width = r.height;
            if (r.contains(p)) {
                this.toggle(path);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        JTree tree;
        TreePath path;
        if ((e.getKeyCode() == 32 || e.getKeyCode() == 10) && e.getSource() instanceof JTree && this.toggle(path = (tree = (JTree)e.getSource()).getSelectionPath())) {
            e.consume();
        }
    }

    private DefaultTreeModel createModel() {
        Item[] categories = new Item[]{new Item("BeforeKeywords", new Item("spaceBeforeWhile", new Item[0]), new Item("spaceBeforeElse", new Item[0]), new Item("spaceBeforeCatch", new Item[0]), new Item("spaceBeforeFinally", new Item[0])), new Item("BeforeParentheses", new Item("spaceBeforeMethodDeclParen", new Item[0]), new Item("spaceBeforeMethodCallParen", new Item[0]), new Item("spaceBeforeIfParen", new Item[0]), new Item("spaceBeforeForParen", new Item[0]), new Item("spaceBeforeWhileParen", new Item[0]), new Item("spaceBeforeCatchParen", new Item[0]), new Item("spaceBeforeSwitchParen", new Item[0]), new Item("spaceBeforeSynchronizedParen", new Item[0]), new Item("spaceBeforeAnnotationParen", new Item[0])), new Item("AroundOperators", new Item("spaceAroundUnaryOps", new Item[0]), new Item("spaceAroundBinaryOps", new Item[0]), new Item("spaceAroundTernaryOps", new Item[0]), new Item("spaceAroundAssignOps", new Item[0])), new Item("BeforeLeftBraces", new Item("spaceBeforeClassDeclLeftBrace", new Item[0]), new Item("spaceBeforeMethodDeclLeftBrace", new Item[0]), new Item("spaceBeforeIfLeftBrace", new Item[0]), new Item("spaceBeforeElseLeftBrace", new Item[0]), new Item("spaceBeforeWhileLeftBrace", new Item[0]), new Item("spaceBeforeForLeftBrace", new Item[0]), new Item("spaceBeforeDoLeftBrace", new Item[0]), new Item("spaceBeforeSwitchLeftBrace", new Item[0]), new Item("spaceBeforeTryLeftBrace", new Item[0]), new Item("spaceBeforeCatchLeftBrace", new Item[0]), new Item("spaceBeforeFinallyLeftBrace", new Item[0]), new Item("spaceBeforeSynchronizedLeftBrace", new Item[0]), new Item("spaceBeforeStaticInitLeftBrace", new Item[0]), new Item("spaceBeforeArrayInitLeftBrace", new Item[0])), new Item("WithinParentheses", new Item("spaceWithinParens", new Item[0]), new Item("spaceWithinMethodDeclParens", new Item[0]), new Item("spaceWithinMethodCallParens", new Item[0]), new Item("spaceWithinIfParens", new Item[0]), new Item("spaceWithinForParens", new Item[0]), new Item("spaceWithinWhileParens", new Item[0]), new Item("spaceWithinSwitchParens", new Item[0]), new Item("spaceWithinCatchParens", new Item[0]), new Item("spaceWithinSynchronizedParens", new Item[0]), new Item("spaceWithinTypeCastParens", new Item[0]), new Item("spaceWithinAnnotationParens", new Item[0]), new Item("spaceWithinBraces", new Item[0]), new Item("spaceWithinArrayInitBrackets", new Item[0])), new Item("Other", new Item("spaceBeforeComma", new Item[0]), new Item("spaceAfterComma", new Item[0]), new Item("spaceBeforeSemi", new Item[0]), new Item("spaceAfterSemi", new Item[0]), new Item("spaceBeforeColon", new Item[0]), new Item("spaceAfterColon", new Item[0]), new Item("spaceAfterTypeCast", new Item[0]))};
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root", true);
        DefaultTreeModel model = new DefaultTreeModel(root);
        for (Item item : categories) {
            DefaultMutableTreeNode cn = new DefaultMutableTreeNode(item, true);
            root.add(cn);
            for (Item si : item.items) {
                DefaultMutableTreeNode in = new DefaultMutableTreeNode(si, false);
                cn.add(in);
            }
        }
        return model;
    }

    private boolean toggle(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object o = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        DefaultTreeModel model = (DefaultTreeModel)this.cfgTree.getModel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (o instanceof Item) {
            Item item = (Item)o;
            if (node.getAllowsChildren()) {
                return false;
            }
            item.value = !item.value;
            model.nodeChanged(node);
            model.nodeChanged(node.getParent());
            controller.changed();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Controller
    extends FmtOptions.CategorySupport {
        FmtSpaces panel = (FmtSpaces)this.getComponent(null);

        public Controller() {
            super("LBL_Spaces", new FmtSpaces(), NbBundle.getMessage(FmtSpaces.class, (String)"SAMPLE_Spaces"), {"placeCatchOnNewLine", Boolean.FALSE.toString()}, {"placeElseOnNewLine", Boolean.FALSE.toString()}, {"placeWhileOnNewLine", Boolean.FALSE.toString()}, {"placeFinallyOnNewLine", Boolean.FALSE.toString()});
            this.update();
        }

        @Override
        protected void addListeners() {
        }

        @Override
        public void update() {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.panel.model.getRoot();
            List<Item> items = this.getAllItems();
            Preferences node = FmtOptions.getPreferences(FmtOptions.getCurrentProfileId());
            for (Item item : items) {
                boolean df = Boolean.parseBoolean(FmtOptions.defaults.get(item.id));
                item.value = node.getBoolean(item.id, df);
            }
        }

        @Override
        public void applyChanges() {
            this.storeTo(FmtOptions.getPreferences(FmtOptions.getCurrentProfileId()));
        }

        @Override
        public void storeTo(Preferences preferences) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.panel.model.getRoot();
            List<Item> items = this.getAllItems();
            for (Item item : items) {
                preferences.putBoolean(item.id, item.value);
            }
        }

        private List<Item> getAllItems() {
            LinkedList<Item> result = new LinkedList<Item>();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.panel.model.getRoot();
            Enumeration<TreeNode> children = root.depthFirstEnumeration();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
                Object o = node.getUserObject();
                if (!(o instanceof Item)) continue;
                Item item = (Item)o;
                if (item.items != null && item.items.length != 0) continue;
                result.add(item);
            }
            return result;
        }
    }

    private static class Item {
        String id;
        String displayName;
        boolean value;
        Item[] items;

        public Item(String id, Item ... items) {
            this.id = id;
            this.items = items;
            this.displayName = NbBundle.getMessage(FmtSpaces.class, (String)("LBL_" + id));
        }

        public String toString() {
            return this.displayName;
        }
    }
}

