/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.lib.editor.bookmarks.actions.BookmarksKitInstallAction;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.bookmarks.PersistentBookmarks;
import org.openide.modules.ModuleInstall;

public class EditorBookmarksModule
extends ModuleInstall {
    private PropertyChangeListener openProjectsListener;
    private static List listeners = new ArrayList();
    private PropertyChangeListener annotationTypesListener;
    private List lastOpenProjects;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;

    public void restored() {
        Settings.addInitializer((Settings.Initializer)new BookmarksSettingsInitializer());
        this.openProjectsListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                List<Project> openProjects = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
                EditorBookmarksModule.this.lastOpenProjects.removeAll(openProjects);
                Iterator it = EditorBookmarksModule.this.lastOpenProjects.iterator();
                while (it.hasNext()) {
                    Project prj = (Project)it.next();
                    PersistentBookmarks.saveProjectBookmarks(prj);
                }
                EditorBookmarksModule.this.lastOpenProjects = new ArrayList<Project>(openProjects);
            }
        };
        OpenProjects op = OpenProjects.getDefault();
        this.lastOpenProjects = new ArrayList<Project>(Arrays.asList(op.getOpenProjects()));
        op.addPropertyChangeListener(this.openProjectsListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final Iterator it = Registry.getDocumentIterator();
                if (!it.hasNext()) {
                    return;
                }
                AnnotationType type = AnnotationTypes.getTypes().getType("editor-bookmark");
                if (type == null) {
                    AnnotationTypes.getTypes().addPropertyChangeListener(EditorBookmarksModule.this.annotationTypesListener = new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            AnnotationType type = AnnotationTypes.getTypes().getType("editor-bookmark");
                            if (type != null) {
                                AnnotationTypes.getTypes().removePropertyChangeListener(EditorBookmarksModule.this.annotationTypesListener);
                                while (it.hasNext()) {
                                    Document doc = (Document)it.next();
                                    BookmarkList.get(doc);
                                }
                            }
                        }
                    });
                } else {
                    while (it.hasNext()) {
                        Document doc = (Document)it.next();
                        BookmarkList.get(doc);
                    }
                }
            }
        });
    }

    public void close() {
        this.finish();
    }

    public void uninstalled() {
        this.finish();
    }

    private void finish() {
        OpenProjects.getDefault().removePropertyChangeListener(this.openProjectsListener);
        Settings.removeInitializer((String)"bookmarks-settings-initializer");
        Settings.reset();
        PersistentBookmarks.saveAllProjectBookmarks();
        EditorBookmarksModule.fireChange();
    }

    public static synchronized void addChangeListener(ChangeListener l) {
        listeners.add(l);
    }

    public static synchronized void removeChangeListener(ChangeListener l) {
        listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireChange() {
        ChangeListener[] ls;
        ChangeEvent ev = new ChangeEvent(EditorBookmarksModule.class);
        Class clazz = EditorBookmarksModule.class;
        synchronized (clazz) {
            ls = listeners.toArray(new ChangeListener[listeners.size()]);
        }
        for (int i = 0; i < ls.length; ++i) {
            ls[i].stateChanged(ev);
        }
    }

    private static final class BookmarksSettingsInitializer
    extends Settings.AbstractInitializer {
        static final String NAME = "bookmarks-settings-initializer";

        BookmarksSettingsInitializer() {
            super(NAME);
        }

        public void updateSettingsMap(Class kitClass, Map settingsMap) {
            if (kitClass == (class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = EditorBookmarksModule.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit)) {
                SettingsUtil.updateListSetting((Map)settingsMap, (String)"custom-action-list", (Object[])new Object[]{BookmarksKitInstallAction.INSTANCE});
                SettingsUtil.updateListSetting((Map)settingsMap, (String)"kit-install-action-name-list", (Object[])new Object[]{BookmarksKitInstallAction.INSTANCE.getValue("Name")});
            }
        }
    }
}

