/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.bookmarks.BookmarksXMLHandler;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.FileBookmarksMap;
import org.netbeans.modules.editor.bookmarks.NbBookmarkManager;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.w3c.dom.Element;

public class PersistentBookmarks {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Map project2bookmarksMap = new WeakHashMap();

    static synchronized void loadBookmarks(NbBookmarkManager manager) {
        FileBookmarksMap map;
        Document doc = manager.getDocument();
        FileObject fo = NbEditorUtilities.getFileObject((Document)doc);
        if (fo != null && (map = PersistentBookmarks.findOwningBookmarksMap(fo)) != null) {
            FileBookmarks fileBookmarks;
            URL url;
            try {
                url = fo.getURL();
            }
            catch (FileStateInvalidException e) {
                url = null;
            }
            if (url != null && (fileBookmarks = map.get(url)) != null) {
                int bookmarkCount = fileBookmarks.getBookmarkCount();
                for (int i = 0; i < bookmarkCount; ++i) {
                    int lineIndex = fileBookmarks.getBookmarkLineIndex(i);
                    manager.addLoadedBookmark(lineIndex);
                }
            }
        }
    }

    static synchronized void saveBookmarks(NbBookmarkManager manager) {
        Document doc = manager.getDocument();
        FileObject fo = NbEditorUtilities.getFileObject((Document)doc);
        if (fo != null) {
            URL url;
            int[] bookmarkLineIndexes = PersistentBookmarks.getLineIndexes(doc);
            try {
                url = fo.getURL();
            }
            catch (FileStateInvalidException e) {
                url = null;
            }
            if (url != null) {
                FileBookmarks bookmarks = new FileBookmarks(url, bookmarkLineIndexes);
                Project owner = FileOwnerQuery.getOwner((FileObject)fo);
                FileBookmarksMap fileBookmarksMap = PersistentBookmarks.findBookmarksMap(owner);
                if (fileBookmarksMap != null) {
                    fileBookmarksMap.put(bookmarks);
                }
            }
        }
    }

    static synchronized void saveAllProjectBookmarks() {
        ArrayList allPrjs = new ArrayList(project2bookmarksMap.keySet());
        Iterator it = allPrjs.iterator();
        while (it.hasNext()) {
            PersistentBookmarks.saveProjectBookmarks((Project)it.next());
        }
    }

    static void saveProjectBookmarks(Project prj) {
        if (!ProjectManager.getDefault().isValid(prj)) {
            return;
        }
        FileBookmarksMap fileBookmarksMap = PersistentBookmarks.findBookmarksMap(prj);
        if (fileBookmarksMap != null && fileBookmarksMap.isModified()) {
            PersistentBookmarks.saveBookmarksMap(prj, fileBookmarksMap);
        }
    }

    private static int[] getLineIndexes(Document doc) {
        BookmarkList bookmarkList = BookmarkList.get(doc);
        int bookmarkCount = bookmarkList.getBookmarkCount();
        int[] lineIndexesArray = new int[bookmarkCount];
        for (int i = 0; i < bookmarkCount; ++i) {
            Bookmark bookmark = bookmarkList.getBookmark(i);
            lineIndexesArray[i] = bookmark.getLineIndex();
        }
        return lineIndexesArray;
    }

    private static FileBookmarksMap findOwningBookmarksMap(FileObject fo) {
        return PersistentBookmarks.findBookmarksMap(FileOwnerQuery.getOwner((FileObject)fo));
    }

    private static FileBookmarksMap findBookmarksMap(Project project) {
        FileBookmarksMap map = null;
        if (project != null && (map = (FileBookmarksMap)project2bookmarksMap.get(project)) == null && (map = PersistentBookmarks.loadBookmarksMap(project)) != null) {
            project2bookmarksMap.put(project, map);
        }
        return map;
    }

    private static FileBookmarksMap loadBookmarksMap(Project project) {
        AuxiliaryConfiguration ac = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        FileBookmarksMap projectBookmarksMap = new FileBookmarksMap();
        if (ac != null) {
            URL projectFolderURL;
            Element bookmarksElem = ac.getConfigurationFragment("editor-bookmarks", "http://www.netbeans.org/ns/editor-bookmarks/1", false);
            try {
                projectFolderURL = project.getProjectDirectory().getURL();
            }
            catch (FileStateInvalidException e) {
                projectFolderURL = null;
            }
            if (bookmarksElem != null) {
                BookmarksXMLHandler.loadFileBookmarksMap(projectBookmarksMap, bookmarksElem, projectFolderURL);
            }
        }
        return projectBookmarksMap;
    }

    private static void saveBookmarksMap(Project project, FileBookmarksMap fileBookmarksMap) {
        AuxiliaryConfiguration ac = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        if (ac != null) {
            URI baseURI;
            try {
                baseURI = new URI(project.getProjectDirectory().getURL().toExternalForm());
            }
            catch (FileStateInvalidException e) {
                baseURI = null;
            }
            catch (URISyntaxException e) {
                baseURI = null;
            }
            Element bookmarksElem = BookmarksXMLHandler.saveFileBookmarksMap(fileBookmarksMap, baseURI);
            ac.putConfigurationFragment(bookmarksElem, false);
        }
    }
}

