/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class ProjectMenuItem
extends AbstractAction
implements Presenter.Popup {
    public JMenuItem getPopupPresenter() {
        return new DynamicDummyItem();
    }

    public void actionPerformed(ActionEvent e) {
    }

    private JComponent[] createItems() {
        Node[] nodes = this.getActivatedNodes();
        if (nodes.length > 0) {
            VersioningSystem owner = VersioningManager.getInstance().getOwner(this.toFile(nodes[0]));
            for (int i = 1; i < nodes.length; ++i) {
                Node node = nodes[i];
                VersioningSystem vs = VersioningManager.getInstance().getOwner(this.toFile(node));
                if (vs == owner) continue;
                return new JComponent[0];
            }
            ArrayList<JMenu> popups = new ArrayList<JMenu>();
            if (owner != null) {
                JMenu localHistoryMenu;
                VersioningSystem localHistory;
                JMenu menu = this.createVersioningSystemPopup(owner, nodes);
                if (menu != null) {
                    popups.add(menu);
                }
                if ((localHistory = VersioningManager.getInstance().getLocalHistory(this.toFile(nodes[0]))) != null && (localHistoryMenu = this.createVersioningSystemPopup(localHistory, nodes)) != null) {
                    popups.add(localHistoryMenu);
                }
            } else {
                Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(VersioningSystem.class));
                Collection vcs = result.allInstances();
                for (VersioningSystem vs : vcs) {
                    JMenu menu = this.createVersioningSystemPopup(vs, nodes);
                    if (menu == null) continue;
                    popups.add(menu);
                }
            }
            return popups.toArray(new JComponent[popups.size()]);
        }
        return new JComponent[0];
    }

    private JMenu createVersioningSystemPopup(VersioningSystem owner, Node[] nodes) {
        VCSAnnotator an = owner.getVCSAnnotator();
        if (an == null) {
            return null;
        }
        JMenu menu = new JMenu(Utils.getDisplayName(owner));
        VCSContext ctx = VCSContext.forNodes(nodes);
        Action[] actions = an.getActions(ctx, VCSAnnotator.ActionDestination.PopupMenu);
        JComponent[] items = new JComponent[actions.length];
        int i = 0;
        for (Action action : actions) {
            if (action == null) {
                items[i++] = new JSeparator();
            } else {
                JMenuItem item = new JMenuItem(action);
                Mnemonics.setLocalizedText((AbstractButton)item, (String)((String)action.getValue("Name")));
                items[i++] = item;
            }
            menu.add(items[i - 1]);
        }
        return menu;
    }

    private Node[] getActivatedNodes() {
        return TopComponent.getRegistry().getActivatedNodes();
    }

    private File toFile(Node node) {
        VCSContext ctx = VCSContext.forNodes(new Node[]{node});
        return ctx.getRootFiles().iterator().next();
    }

    private class DynamicDummyItem
    extends JMenuItem
    implements DynamicMenuContent {
        private DynamicDummyItem() {
        }

        public JComponent[] getMenuPresenters() {
            return ProjectMenuItem.this.createItems();
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return ProjectMenuItem.this.createItems();
        }
    }
}

