/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningAnnotationProvider
extends AnnotationProvider {
    static VersioningAnnotationProvider instance;

    public VersioningAnnotationProvider() {
        instance = this;
    }

    private VersioningSystem getOwner(File file) {
        return file == null ? null : VersioningManager.getInstance().getOwner(file);
    }

    public Image annotateIcon(Image icon, int iconType, Set files) {
        FileObject fo = (FileObject)files.iterator().next();
        VersioningSystem vs = this.getOwner(FileUtil.toFile((FileObject)fo));
        if (vs == null) {
            return null;
        }
        VCSAnnotator an = vs.getVCSAnnotator();
        if (an == null) {
            return null;
        }
        VCSContext context = Utils.contextForFileObjects(files);
        return an.annotateIcon(icon, context);
    }

    public String annotateNameHtml(String name, Set files) {
        FileObject fo = (FileObject)files.iterator().next();
        VersioningSystem vs = this.getOwner(FileUtil.toFile((FileObject)fo));
        if (vs == null) {
            return null;
        }
        VCSAnnotator an = vs.getVCSAnnotator();
        if (an == null) {
            return null;
        }
        VCSContext context = Utils.contextForFileObjects(files);
        return an.annotateName(name, context);
    }

    public Action[] actions(Set files) {
        VersioningSystem localHistory;
        FileObject fo = (FileObject)files.iterator().next();
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            return new Action[0];
        }
        VersioningSystem vs = this.getOwner(file);
        ArrayList<AbstractVersioningSystemActions> actions = new ArrayList<AbstractVersioningSystemActions>();
        VCSAnnotator an = null;
        if (vs != null) {
            an = vs.getVCSAnnotator();
        }
        if (an != null) {
            VersioningSystemActions action = (VersioningSystemActions)SystemAction.get(VersioningSystemActions.class);
            action.setVersioninSystem(vs);
            actions.add(action);
        }
        if ((localHistory = VersioningManager.getInstance().getLocalHistory(file)) != null && localHistory.getVCSAnnotator() != null) {
            LocalHistoryActions localHistoryAction = (LocalHistoryActions)SystemAction.get(LocalHistoryActions.class);
            localHistoryAction.setVersioninSystem(localHistory);
            actions.add(localHistoryAction);
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public InterceptionListener getInterceptionListener() {
        return VersioningManager.getInstance().getInterceptionListener();
    }

    public String annotateName(String name, Set files) {
        return name;
    }

    public void refreshAllAnnotations(boolean icon, boolean text) {
        HashSet<FileSystem> filesystems = new HashSet<FileSystem>(1);
        File[] allRoots = File.listRoots();
        for (int i = 0; i < allRoots.length; ++i) {
            File root = allRoots[i];
            FileObject fo = FileUtil.toFileObject((File)root);
            if (fo == null) continue;
            try {
                filesystems.add(fo.getFileSystem());
                continue;
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        for (FileSystem fileSystem : filesystems) {
            this.fireFileStatusChanged(new FileStatusEvent(fileSystem, icon, text));
        }
    }

    void refreshAnnotations(Set<File> filesToRefresh) {
        if (filesToRefresh == null) {
            this.refreshAllAnnotations(true, true);
            return;
        }
        HashMap<FileSystem, HashSet<FileObject>> folders = new HashMap<FileSystem, HashSet<FileObject>>();
        for (File file : filesToRefresh) {
            for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                try {
                    FileObject fo;
                    try {
                        fo = FileUtil.toFileObject((File)parent);
                    }
                    catch (IllegalArgumentException e) {
                        Logger.getLogger(VersioningAnnotationProvider.class.getName()).log(Level.INFO, "Issue #73233 log begins:");
                        Logger.getLogger(VersioningAnnotationProvider.class.getName()).log(Level.INFO, "Original File: " + file.getAbsolutePath());
                        Logger.getLogger(VersioningAnnotationProvider.class.getName()).log(Level.INFO, "Illegal file: " + parent.getAbsolutePath());
                        RuntimeException ex = new RuntimeException("Please report this and append your messages.log file to issue http://www.netbeans.org/issues/show_bug.cgi?id=73233");
                        ex.initCause(e);
                        throw ex;
                    }
                    if (fo == null) continue;
                    FileSystem fs = fo.getFileSystem();
                    HashSet<FileObject> fsFolders = (HashSet<FileObject>)folders.get(fs);
                    if (fsFolders == null) {
                        fsFolders = new HashSet<FileObject>();
                        folders.put(fs, fsFolders);
                    }
                    fsFolders.add(fo);
                    continue;
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
            }
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            try {
                this.fireFileStatusChanged(new FileStatusEvent(fo.getFileSystem(), fo, fo.isFolder(), true));
            }
            catch (FileStateInvalidException e) {}
        }
        for (FileSystem fs : folders.keySet()) {
            Set files = (Set)folders.get(fs);
            this.fireFileStatusChanged(new FileStatusEvent(fs, files, true, false));
        }
    }

    public static abstract class AbstractVersioningSystemActions
    extends SystemAction
    implements ContextAwareAction {
        private VersioningSystem system;

        public String getName() {
            return Utils.getDisplayName(this.system);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.system.getClass());
        }

        public void actionPerformed(ActionEvent ev) {
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new RealVersioningSystemActions(this.system, Utils.contextForLookup(actionContext));
        }

        public void setVersioninSystem(VersioningSystem system) {
            this.system = system;
        }
    }

    public static class LocalHistoryActions
    extends AbstractVersioningSystemActions {
    }

    private static class RealVersioningSystemActions
    extends AbstractAction
    implements Presenter.Popup {
        private final VersioningSystem system;
        private final VCSContext context;

        public RealVersioningSystemActions(VersioningSystem system, VCSContext context) {
            super(Utils.getDisplayName(system));
            this.system = system;
            this.context = context;
        }

        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            return new VersioningSystemMenuItem();
        }

        private class VersioningSystemMenuItem
        extends JMenu {
            private boolean popupContructed;

            public VersioningSystemMenuItem() {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)Utils.getDisplayName(RealVersioningSystemActions.this.system));
            }

            public void setSelected(boolean selected) {
                if (selected && !this.popupContructed) {
                    Action[] actions = RealVersioningSystemActions.this.system.getVCSAnnotator().getActions(RealVersioningSystemActions.this.context, VCSAnnotator.ActionDestination.PopupMenu);
                    for (int i = 0; i < actions.length; ++i) {
                        Action action = actions[i];
                        if (action == null) {
                            this.add(new JSeparator());
                            continue;
                        }
                        JMenuItem item = Utils.toMenuItem(action);
                        this.add(item);
                    }
                    this.popupContructed = true;
                }
                super.setSelected(selected);
            }
        }
    }

    public static class VersioningSystemActions
    extends AbstractVersioningSystemActions {
    }
}

