/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.versioning.diff.DiffSidebar;
import org.netbeans.modules.versioning.diff.DiffTooltipActionsPanel;
import org.netbeans.modules.versioning.diff.DiffTooltipContentPanel;

class DiffActionTooltipWindow
implements AWTEventListener {
    private static final int SCREEN_BORDER = 20;
    private JWindow actionsWindow;
    private JWindow contentWindow;
    private final DiffSidebar master;
    private final Difference diff;

    public DiffActionTooltipWindow(DiffSidebar master, Difference diff) {
        this.master = master;
        this.diff = diff;
        Window w = SwingUtilities.windowForComponent(master.getTextComponent());
        this.actionsWindow = new JWindow(w);
        if (diff.getType() != 1) {
            this.contentWindow = new JWindow(w);
        }
    }

    DiffSidebar getMaster() {
        return this.master;
    }

    public void show(Point location) {
        DiffTooltipActionsPanel tp = new DiffTooltipActionsPanel(this, this.diff);
        this.actionsWindow.add(tp);
        this.actionsWindow.pack();
        this.actionsWindow.setLocation(location);
        if (this.contentWindow != null) {
            DiffTooltipContentPanel cp = new DiffTooltipContentPanel(this.master.getTextComponent(), this.master.getMimeType(), this.diff);
            this.contentWindow.add(cp);
            this.contentWindow.pack();
            Dimension dim = this.contentWindow.getSize();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (location.y + this.actionsWindow.getHeight() + dim.height + 20 > screenSize.height) {
                dim.height = screenSize.height - (location.y + this.actionsWindow.getHeight() + 20);
            }
            if (location.x + dim.width + 20 > screenSize.width) {
                dim.width = screenSize.width - (location.x + 20);
            }
            this.contentWindow.setSize(dim);
            this.contentWindow.setLocation(location.x, location.y + this.actionsWindow.getHeight() - 1);
            this.contentWindow.setVisible(true);
        }
        this.actionsWindow.setVisible(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
    }

    public void eventDispatched(AWTEvent event) {
        if (event.getID() == 501) {
            this.onClick(event);
        }
    }

    private void onClick(AWTEvent event) {
        Component component = (Component)event.getSource();
        Window w = SwingUtilities.windowForComponent(component);
        if (w != this.actionsWindow && (this.contentWindow == null || w != this.contentWindow)) {
            this.shutdown();
        }
    }

    void shutdown() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.actionsWindow.dispose();
        if (this.contentWindow != null) {
            this.contentWindow.dispose();
        }
    }
}

