/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.diff.DiffActionTooltipWindow;
import org.netbeans.modules.versioning.diff.DiffMark;
import org.netbeans.modules.versioning.diff.DiffSidebarManager;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

class DiffSidebar
extends JComponent
implements DocumentListener,
ComponentListener,
FoldHierarchyListener,
FileChangeListener {
    private static final int BAR_WIDTH = 9;
    private final JTextComponent textComponent;
    private final FileObject fileObject;
    private final EditorUI editorUI;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument document;
    private boolean sidebarVisible;
    private Difference[] currentDiff;
    private DiffMarkProvider markProvider;
    private Color colorAdded = new Color(150, 255, 150);
    private Color colorChanged = new Color(160, 200, 255);
    private Color colorRemoved = new Color(255, 160, 180);
    private Color colorBorder = new Color(102, 102, 102);
    private int originalContentSerial;
    private int originalContentBufferSerial = -1;
    private String originalContentBuffer;
    private RequestProcessor.Task refreshDiffTask;
    private VersioningSystem ownerVersioningSystem;

    public DiffSidebar(JTextComponent target, File file) {
        this.textComponent = target;
        this.fileObject = FileUtil.toFileObject((File)file);
        this.editorUI = Utilities.getEditorUI((JTextComponent)target);
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)this.editorUI.getComponent());
        this.document = this.editorUI.getDocument();
        this.markProvider = new DiffMarkProvider();
        this.setToolTipText("");
        this.refreshDiffTask = DiffSidebarManager.getInstance().createDiffSidebarTask(new RefreshDiffTask());
        this.setMaximumSize(new Dimension(9, Integer.MAX_VALUE));
    }

    FileObject getFileObject() {
        return this.fileObject;
    }

    private void refreshOriginalContent() {
        File file = FileUtil.toFile((FileObject)this.fileObject);
        this.ownerVersioningSystem = VersioningManager.getInstance().getOwner(file);
        ++this.originalContentSerial;
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    Difference[] getCurrentDiff() {
        return this.currentDiff;
    }

    public String getToolTipText(MouseEvent event) {
        Difference diff = this.getDifferenceAt(event);
        return DiffSidebar.getShortDescription(diff);
    }

    static String getShortDescription(Difference diff) {
        if (diff == null) {
            return null;
        }
        switch (diff.getType()) {
            case 1: {
                int n = diff.getSecondEnd() - diff.getSecondStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesAdded")).format(n), n);
            }
            case 2: {
                int n = diff.getFirstEnd() - diff.getFirstStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesChanged")).format(n), n);
            }
            case 0: {
                int n = diff.getFirstEnd() - diff.getFirstStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesDeleted")).format(n), n);
            }
        }
        throw new IllegalStateException("Unknown difference type: " + diff.getType());
    }

    protected void processMouseEvent(MouseEvent event) {
        super.processMouseEvent(event);
        Difference diff = this.getDifferenceAt(event);
        if (diff == null) {
            return;
        }
        if (event.getID() == 500) {
            this.onClick(event, diff);
        }
    }

    private void onClick(MouseEvent event, Difference diff) {
        Point p = new Point(event.getPoint());
        SwingUtilities.convertPointToScreen(p, this);
        Point p2 = new Point(p);
        SwingUtilities.convertPointFromScreen(p2, this.textComponent);
        this.showTooltipWindow(new Point(p.x - p2.x, p.y), diff);
    }

    private void showTooltipWindow(Point p, Difference diff) {
        DiffActionTooltipWindow ttw = new DiffActionTooltipWindow(this, diff);
        ttw.show(new Point(p.x, p.y));
    }

    private Difference getDifferenceAt(MouseEvent event) {
        if (this.currentDiff == null) {
            return null;
        }
        int line = this.getLineFromMouseEvent(event);
        if (line == -1) {
            return null;
        }
        Difference diff = this.getDifference(line + 1);
        if (diff == null && (diff = this.getDifference(line)) != null && diff.getType() != 0) {
            diff = null;
        }
        return diff;
    }

    void onDiff(Difference diff) {
        try {
            DiffView view = Diff.getDefault().createDiff((StreamSource)new SidebarStreamSource(true), (StreamSource)new SidebarStreamSource(false));
            JComponent c = (JComponent)view.getComponent();
            DiffTopComponent tc = new DiffTopComponent(c);
            tc.setName(this.fileObject.getNameExt() + " [Diff]");
            tc.open();
            tc.requestActive();
            view.setCurrentDifference(this.getDiffIndex(diff));
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private int getDiffIndex(Difference diff) {
        for (int i = 0; i < this.currentDiff.length; ++i) {
            if (diff != this.currentDiff[i]) continue;
            return i;
        }
        return -1;
    }

    void onRollback(Difference diff) {
        try {
            if (diff.getType() == 1) {
                int start = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)(diff.getSecondStart() - 1));
                int end = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)diff.getSecondEnd());
                this.document.remove(start, end - start);
            } else if (diff.getType() == 2) {
                int start = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)(diff.getSecondStart() - 1));
                int end = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)diff.getSecondEnd());
                this.document.replace(start, end - start, diff.getFirstText(), null);
            } else {
                int start = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)diff.getSecondStart());
                this.document.insertString(start, diff.getFirstText(), null);
            }
            this.refreshDiff();
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    boolean canRollback(Difference diff) {
        int start;
        int end;
        if (!(this.document instanceof GuardedDocument)) {
            return true;
        }
        if (diff.getType() == 0) {
            start = end = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)diff.getSecondStart());
        } else {
            start = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)(diff.getSecondStart() - 1));
            end = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)diff.getSecondEnd());
        }
        MarkBlockChain mbc = ((GuardedDocument)this.document).getGuardedBlockChain();
        return (mbc.compareBlock(start, end) & 1) == 0;
    }

    void onPrevious(Difference diff) {
        diff = this.currentDiff[this.getDiffIndex(diff) - 1];
        Point location = this.scrollToDifference(diff);
        this.showTooltipWindow(location, diff);
        this.textComponent.repaint();
    }

    void onNext(Difference diff) {
        diff = this.currentDiff[this.getDiffIndex(diff) + 1];
        Point location = this.scrollToDifference(diff);
        this.showTooltipWindow(location, diff);
        this.textComponent.repaint();
    }

    private Point scrollToDifference(Difference diff) {
        int lineStart = diff.getSecondStart() - 1;
        int lineEnd = diff.getSecondEnd() - 1;
        if (diff.getType() == 0) {
            lineEnd = lineStart;
        }
        try {
            int visibleBorder = this.editorUI.getLineHeight() * 5;
            int startOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.textComponent.getDocument()), (int)lineStart);
            int endOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.textComponent.getDocument()), (int)lineEnd);
            Rectangle startRect = this.textComponent.getUI().modelToView(this.textComponent, startOffset);
            Rectangle endRect = this.textComponent.getUI().modelToView(this.textComponent, endOffset);
            Rectangle visibleRect = new Rectangle(startRect.x - visibleBorder, startRect.y - visibleBorder, startRect.x, endRect.y - startRect.y + endRect.height + visibleBorder * 2);
            this.textComponent.scrollRectToVisible(visibleRect);
            Point p = new Point(endRect.x, endRect.y + endRect.height + 1);
            SwingUtilities.convertPointToScreen(p, this.textComponent);
            return p;
        }
        catch (BadLocationException e) {
            Logger.getLogger(DiffSidebar.class.getName()).log(Level.WARNING, "scrollToDifference", e);
            return null;
        }
    }

    String getMimeType() {
        if (this.textComponent instanceof JEditorPane) {
            return ((JEditorPane)this.textComponent).getContentType();
        }
        return "text/plain";
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffSidebar.this.refresh();
            }
        });
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private int getLineFromMouseEvent(MouseEvent e) {
        int line = -1;
        if (this.editorUI != null) {
            try {
                JTextComponent component = this.editorUI.getComponent();
                BaseTextUI textUI = (BaseTextUI)component.getUI();
                int clickOffset = textUI.viewToModel(component, new Point(0, e.getY()));
                line = Utilities.getLineOffset((BaseDocument)this.document, (int)clickOffset);
            }
            catch (BadLocationException ble) {
                Logger.getLogger(DiffSidebar.class.getName()).log(Level.WARNING, "getLineFromMouseEvent", ble);
            }
        }
        return line;
    }

    void refresh() {
        this.shutdown();
        this.initialize();
        this.refreshDiff();
        this.revalidate();
    }

    public void setSidebarVisible(boolean visible) {
        if (this.sidebarVisible == visible) {
            return;
        }
        this.sidebarVisible = visible;
        this.refreshDiff();
        this.revalidate();
    }

    public void addNotify() {
        super.addNotify();
        this.initialize();
    }

    public void removeNotify() {
        this.shutdown();
        super.removeNotify();
    }

    private void initialize() {
        assert (SwingUtilities.isEventDispatchThread());
        this.document.addDocumentListener((DocumentListener)this);
        this.textComponent.addComponentListener(this);
        this.foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this);
        this.refreshOriginalContent();
        if (this.fileObject != null) {
            this.fileObject.addFileChangeListener((FileChangeListener)this);
        }
    }

    private void shutdown() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.fileObject != null) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this);
        }
        this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)this);
        this.textComponent.removeComponentListener(this);
        this.document.removeDocumentListener((DocumentListener)this);
    }

    private Reader getDocumentReader() {
        JTextComponent component = this.editorUI.getComponent();
        if (component == null) {
            return null;
        }
        return Utils.getDocumentReader(component.getDocument());
    }

    private void refreshDiff() {
        this.refreshDiffTask.schedule(50);
    }

    MarkProvider getMarkProvider() {
        return this.markProvider;
    }

    private static void copyStreamsCloseAll(Writer writer, Reader reader) throws IOException {
        int n;
        char[] buffer = new char[2048];
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        writer.close();
        reader.close();
    }

    static void copyStreamsCloseAll(OutputStream writer, InputStream reader) throws IOException {
        int n;
        byte[] buffer = new byte[2048];
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        writer.close();
        reader.close();
    }

    public Dimension getPreferredSize() {
        Dimension dim = this.textComponent.getSize();
        dim.width = this.sidebarVisible ? 9 : 0;
        return dim;
    }

    public void paintComponent(Graphics g) {
        block13: {
            JTextComponent component;
            super.paintComponent(g);
            Rectangle clip = g.getClipBounds();
            if (clip.y >= 16) {
                clip.y -= 16;
                clip.height += 16;
            }
            if ((component = this.editorUI.getComponent()) == null) {
                return;
            }
            BaseTextUI textUI = (BaseTextUI)component.getUI();
            View rootView = Utilities.getDocumentView((JTextComponent)component);
            if (rootView == null) {
                return;
            }
            g.setColor(this.backgroundColor());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            Difference[] paintDiff = this.currentDiff;
            if (paintDiff == null || paintDiff.length == 0) {
                return;
            }
            try {
                int startPos = textUI.getPosFromY(clip.y);
                int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
                int rootViewCount = rootView.getViewCount();
                if (startViewIndex < 0 || startViewIndex >= rootViewCount) break block13;
                Rectangle rec = textUI.modelToView(component, rootView.getView(startViewIndex).getStartOffset());
                int y = rec == null ? 0 : rec.y;
                int[] yCoords = new int[3];
                int clipEndY = clip.y + clip.height;
                Element rootElem = textUI.getRootView(component).getElement();
                View view = rootView.getView(startViewIndex);
                int line = rootElem.getElementIndex(view.getStartOffset());
                if (++line == 1 && paintDiff[0].getSecondStart() == 0 && paintDiff[0].getType() == 0) {
                    g.setColor(this.getColor(paintDiff[0]));
                    yCoords[0] = y - this.editorUI.getLineAscent() / 2;
                    yCoords[1] = y;
                    yCoords[2] = y + this.editorUI.getLineAscent() / 2;
                    g.fillPolygon(new int[]{0, 9, 0}, yCoords, 3);
                }
                for (int i = startViewIndex; i < rootViewCount; ++i) {
                    Difference ad;
                    view = rootView.getView(i);
                    line = rootElem.getElementIndex(view.getStartOffset());
                    if ((ad = this.getDifference(++line)) != null) {
                        g.setColor(this.getColor(ad));
                        if (ad.getType() == 0) {
                            yCoords[0] = y + this.editorUI.getLineAscent();
                            yCoords[1] = y + this.editorUI.getLineAscent() * 3 / 2;
                            yCoords[2] = y + this.editorUI.getLineAscent() * 2;
                            g.fillPolygon(new int[]{2, 9, 2}, yCoords, 3);
                            g.setColor(this.colorBorder);
                            g.drawLine(2, yCoords[0], 2, yCoords[2] - 1);
                        } else {
                            g.fillRect(3, y, 6, this.editorUI.getLineHeight());
                            g.setColor(this.colorBorder);
                            int y1 = y + this.editorUI.getLineHeight();
                            g.drawLine(2, y, 2, y1);
                            if (ad.getSecondStart() == line) {
                                g.drawLine(2, y, 8, y);
                            }
                            g.drawLine(2, y1, 8, y1);
                        }
                    }
                    if ((y += this.editorUI.getLineHeight()) < clipEndY) {
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
        }
    }

    private Color getColor(Difference ad) {
        if (ad.getType() == 1) {
            return this.colorAdded;
        }
        if (ad.getType() == 2) {
            return this.colorChanged;
        }
        return this.colorRemoved;
    }

    private Difference getDifference(int line) {
        if (line < 0) {
            return null;
        }
        for (int i = 0; i < this.currentDiff.length; ++i) {
            Difference difference = this.currentDiff[i];
            if (line < difference.getSecondStart()) {
                return null;
            }
            if (difference.getType() == 0 && line == difference.getSecondStart()) {
                return difference;
            }
            if (line > difference.getSecondEnd()) continue;
            return difference;
        }
        return null;
    }

    private Color backgroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return Color.WHITE;
    }

    public void insertUpdate(DocumentEvent e) {
        this.refreshDiff();
    }

    public void removeUpdate(DocumentEvent e) {
        this.refreshDiff();
    }

    public void changedUpdate(DocumentEvent e) {
        this.refreshDiff();
    }

    public void componentResized(ComponentEvent e) {
        this.revalidate();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void foldHierarchyChanged(FoldHierarchyEvent evt) {
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader getText(VersioningSystem vs) {
        File mainFile = FileUtil.toFile((FileObject)this.fileObject);
        if (mainFile == null) {
            return null;
        }
        File tempFolder = Utils.getTempFolder();
        HashSet<File> filesToCheckout = new HashSet<File>(2);
        filesToCheckout.add(mainFile);
        DataObject dao = null;
        try {
            dao = DataObject.find((FileObject)this.fileObject);
            Set fileObjects = dao.files();
            for (FileObject fileObject : fileObjects) {
                File file = FileUtil.toFile((FileObject)fileObject);
                filesToCheckout.add(file);
            }
        }
        catch (DataObjectNotFoundException e) {
            // empty catch block
        }
        try {
            for (File file : filesToCheckout) {
                File originalFile = new File(tempFolder, file.getName());
                vs.getOriginalFile(file, originalFile);
            }
            Reader i$ = this.createReader(new File(tempFolder, this.fileObject.getNameExt()));
            return i$;
        }
        catch (Exception e) {
            Reader reader = null;
            return reader;
        }
        finally {
            Utils.deleteRecursively(tempFolder);
        }
    }

    private Reader createReader(File file) {
        try {
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            DataObject dao = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)dao.getCookie(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            return new StringReader(doc.getText(0, doc.getLength()));
        }
        catch (Exception e) {
            try {
                return new FileReader(file);
            }
            catch (FileNotFoundException e2) {
                return null;
            }
        }
    }

    static /* synthetic */ Difference[] access$002(DiffSidebar x0, Difference[] x1) {
        x0.currentDiff = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiffMarkProvider
    extends MarkProvider {
        private List<DiffMark> marks = this.getMarksForDifferences();

        public List getMarks() {
            return this.marks;
        }

        void refresh() {
            List<DiffMark> oldMarks = this.marks;
            this.marks = this.getMarksForDifferences();
            this.firePropertyChange("marks", oldMarks, this.marks);
        }

        private List<DiffMark> getMarksForDifferences() {
            if (DiffSidebar.this.currentDiff == null || !DiffSidebar.this.isVisible() || DiffSidebar.this.getWidth() <= 0) {
                return Collections.emptyList();
            }
            ArrayList<DiffMark> marks = new ArrayList<DiffMark>(DiffSidebar.this.currentDiff.length);
            for (int i = 0; i < DiffSidebar.this.currentDiff.length; ++i) {
                Difference difference = DiffSidebar.this.currentDiff[i];
                marks.add(new DiffMark(difference, DiffSidebar.this.getColor(difference)));
            }
            return marks;
        }
    }

    private static class DiffTopComponent
    extends TopComponent {
        private JComponent diffView;

        public DiffTopComponent() {
        }

        public DiffTopComponent(JComponent c) {
            this.diffView = c;
            this.setLayout(new BorderLayout());
            c.putClientProperty(TopComponent.class, (Object)this);
            this.add(c, "Center");
        }

        public UndoRedo getUndoRedo() {
            UndoRedo undoredo = (UndoRedo)this.diffView.getClientProperty(UndoRedo.class);
            return undoredo == null ? UndoRedo.NONE : undoredo;
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return "DiffSidebarTopComponent";
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(((Object)((Object)this)).getClass());
        }
    }

    public class RefreshDiffTask
    implements Runnable {
        public void run() {
            this.computeDiff();
            DiffSidebar.this.repaint();
            DiffSidebar.this.markProvider.refresh();
        }

        private void computeDiff() {
            if (!DiffSidebar.this.sidebarVisible) {
                DiffSidebar.access$002(DiffSidebar.this, null);
                return;
            }
            this.fetchOriginalContent();
            if (DiffSidebar.this.originalContentBuffer == null) {
                DiffSidebar.access$002(DiffSidebar.this, null);
                return;
            }
            Reader working = DiffSidebar.this.getDocumentReader();
            if (working == null) {
                return;
            }
            DiffProvider diff = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
            if (diff == null) {
                DiffSidebar.access$002(DiffSidebar.this, null);
                return;
            }
            try {
                DiffSidebar.access$002(DiffSidebar.this, diff.computeDiff((Reader)new StringReader(DiffSidebar.this.originalContentBuffer), working));
            }
            catch (IOException e) {
                DiffSidebar.access$002(DiffSidebar.this, null);
            }
        }

        private void fetchOriginalContent() {
            int serial = DiffSidebar.this.originalContentSerial;
            if (DiffSidebar.this.ownerVersioningSystem == null || DiffSidebar.this.originalContentBuffer != null && DiffSidebar.this.originalContentBufferSerial == serial) {
                return;
            }
            DiffSidebar.this.originalContentBufferSerial = serial;
            Reader r = DiffSidebar.this.getText(DiffSidebar.this.ownerVersioningSystem);
            if (r == null) {
                DiffSidebar.this.originalContentBuffer = null;
                return;
            }
            StringWriter w = new StringWriter(2048);
            try {
                DiffSidebar.copyStreamsCloseAll(w, r);
                DiffSidebar.this.originalContentBuffer = w.toString();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private class SidebarStreamSource
    extends StreamSource {
        private final boolean isFirst;

        public SidebarStreamSource(boolean isFirst) {
            this.isFirst = isFirst;
        }

        public boolean isEditable() {
            return !this.isFirst;
        }

        public Lookup getLookup() {
            if (this.isFirst) {
                return super.getLookup();
            }
            return Lookups.fixed((Object[])new Object[]{DiffSidebar.this.document});
        }

        public String getName() {
            return DiffSidebar.this.fileObject.getNameExt();
        }

        public String getTitle() {
            if (this.isFirst) {
                return NbBundle.getMessage(DiffSidebar.class, (String)"LBL_DiffPane_Original");
            }
            return NbBundle.getMessage(DiffSidebar.class, (String)"LBL_DiffPane_WorkingCopy");
        }

        public String getMIMEType() {
            return DiffSidebar.this.getMimeType();
        }

        public Reader createReader() throws IOException {
            return this.isFirst ? new StringReader(DiffSidebar.this.originalContentBuffer) : DiffSidebar.this.getDocumentReader();
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            return null;
        }
    }
}

