/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.spi;

import java.io.File;
import java.io.FileFilter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.versioning.FlatFolder;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VCSContext {
    public static final VCSContext EMPTY = new VCSContext(null, VCSContext.emptySet(), VCSContext.emptySet());
    private static Reference<VCSContext> contextCached = new WeakReference<Object>(null);
    private static Reference<Node[]> contextNodesCached = new WeakReference<Object>(null);
    private final Lookup elements;
    private final Set<File> rootFiles;
    private final Set<File> exclusions;

    public static VCSContext forFiles(Set<File> rootFiles) {
        return new VCSContext(null, Collections.unmodifiableSet(new HashSet<File>(rootFiles)), VCSContext.emptySet());
    }

    public static synchronized VCSContext forNodes(Node[] nodes) {
        VCSContext ctx;
        if (Arrays.equals(contextNodesCached.get(), nodes) && (ctx = contextCached.get()) != null) {
            return ctx;
        }
        HashSet<File> files = new HashSet<File>(nodes.length);
        HashSet<File> rootFiles = new HashSet<File>(nodes.length);
        HashSet<File> rootFileExclusions = new HashSet<File>(5);
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            File aFile = (File)node.getLookup().lookup(File.class);
            if (aFile != null) {
                files.add(aFile);
                rootFiles.add(aFile);
                continue;
            }
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) {
                VCSContext.addProjectFiles(rootFiles, rootFileExclusions, project);
                continue;
            }
            VCSContext.addFileObjects(node, files, rootFiles);
        }
        VCSContext ctx2 = new VCSContext(nodes, rootFiles, rootFileExclusions);
        contextCached = new WeakReference<VCSContext>(ctx2);
        contextNodesCached = new WeakReference<Node[]>(nodes);
        return ctx2;
    }

    public Set<File> computeFiles(FileFilter filter) {
        return VCSContext.substract(this.rootFiles, this.exclusions, filter);
    }

    public Lookup getElements() {
        return this.elements;
    }

    public Set<File> getRootFiles() {
        return this.rootFiles;
    }

    public Set<File> getExclusions() {
        return this.exclusions;
    }

    public boolean contains(File file) {
        block0: for (File root : this.rootFiles) {
            if (!Utils.isAncestorOrEqual(root, file)) continue;
            for (File excluded : this.exclusions) {
                if (!Utils.isAncestorOrEqual(excluded, file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private static void addProjectFiles(Collection<File> rootFiles, Collection<File> rootFilesExclusions, Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        for (int j = 0; j < sourceGroups.length; ++j) {
            SourceGroup sourceGroup = sourceGroups[j];
            FileObject srcRootFo = sourceGroup.getRootFolder();
            File rootFile = FileUtil.toFile((FileObject)srcRootFo);
            rootFiles.add(rootFile);
            FileObject[] rootChildren = srcRootFo.getChildren();
            for (int i = 0; i < rootChildren.length; ++i) {
                FileObject rootChildFo = rootChildren[i];
                File child = FileUtil.toFile((FileObject)rootChildFo);
                if (sourceGroup.contains(rootChildFo) || SharabilityQuery.getSharability((File)child) == 2) continue;
                rootFilesExclusions.add(child);
            }
        }
    }

    private static void addFileObjects(Node node, Set<File> files, Set<File> rootFiles) {
        Collection folders = node.getLookup().lookup(new Lookup.Template(NonRecursiveFolder.class)).allInstances();
        ArrayList<File> nodeFiles = new ArrayList<File>();
        if (folders.size() > 0) {
            for (NonRecursiveFolder nonRecursiveFolder : folders) {
                nodeFiles.add(new FlatFolder(FileUtil.toFile((FileObject)nonRecursiveFolder.getFolder()).getAbsolutePath()));
            }
        } else {
            Collection fileObjects = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (fileObjects.size() > 0) {
                nodeFiles.addAll(VCSContext.toFileCollection(fileObjects));
            } else {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (dataObject != null) {
                    Collection<File> doFiles = VCSContext.toFileCollection(dataObject.files());
                    nodeFiles.addAll(doFiles);
                }
            }
        }
        files.addAll(nodeFiles);
        rootFiles.addAll(nodeFiles);
    }

    private static Collection<File> toFileCollection(Collection<? extends FileObject> fileObjects) {
        HashSet<File> files = new HashSet<File>(fileObjects.size() * 4 / 3 + 1);
        for (FileObject fileObject : fileObjects) {
            files.add(FileUtil.toFile((FileObject)fileObject));
        }
        files.remove(null);
        return files;
    }

    private VCSContext(Node[] nodes, Set<File> rootFiles, Set<File> exclusions) {
        this.elements = nodes != null ? Lookups.fixed((Object[])nodes) : Lookups.fixed((Object[])new Node[0]);
        HashSet<File> tempRootFiles = new HashSet<File>(rootFiles);
        HashSet<File> tempExclusions = new HashSet<File>(exclusions);
        this.removeDuplicates(tempRootFiles);
        this.removeDuplicates(tempExclusions);
        this.rootFiles = Collections.unmodifiableSet(tempRootFiles);
        this.exclusions = Collections.unmodifiableSet(tempExclusions);
    }

    private static Set<File> substract(Set<File> roots, Set<File> exclusions, FileFilter filter) {
        HashSet<File> files = new HashSet<File>(roots);
        for (File exclusion : exclusions) {
            do {
                VCSContext.addSiblings(files, exclusion, filter);
                exclusion = exclusion.getParentFile();
                files.remove(exclusion);
            } while (!roots.contains(exclusion));
        }
        files.removeAll(exclusions);
        return files;
    }

    private static void addSiblings(Set<File> files, File exclusion, FileFilter filter) {
        File[] siblings;
        for (File sibling : siblings = exclusion.getParentFile().listFiles()) {
            if (!filter.accept(sibling)) continue;
            files.add(sibling);
        }
        files.remove(exclusion);
    }

    private static final Set<File> emptySet() {
        return Collections.emptySet();
    }

    private void removeDuplicates(Set<File> files) {
        ArrayList<File> newFiles = new ArrayList<File>();
        block0: for (File file : files) {
            Iterator j = newFiles.iterator();
            while (j.hasNext()) {
                File includedFile = (File)j.next();
                if (Utils.isAncestorOrEqual(includedFile, file) && (file.isFile() || !VersioningSupport.isFlat(includedFile))) continue block0;
                if (!Utils.isAncestorOrEqual(file, includedFile) || !includedFile.isFile() && VersioningSupport.isFlat(file)) continue;
                j.remove();
            }
            newFiles.add(file);
        }
        files.clear();
        files.addAll(newFiles);
    }
}

