/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.refactoring.api.AccessorImpl;
import org.netbeans.modules.refactoring.api.Context;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.api.impl.APIAccessor;
import org.netbeans.modules.refactoring.api.impl.ProgressSupport;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandler;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandlerFactory;
import org.netbeans.modules.refactoring.spi.ProgressProvider;
import org.netbeans.modules.refactoring.spi.ReadOnlyFilesHandler;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.lookup.InstanceContent;

public abstract class AbstractRefactoring {
    public static final int INIT = 0;
    public static final int PRE_CHECK = 1;
    public static final int PARAMETERS_CHECK = 2;
    public static final int PREPARE = 3;
    private int currentState = 0;
    private static final int PLUGIN_STEPS = 30;
    private ArrayList plugins;
    private ArrayList pluginsWithProgress;
    private ArrayList gbHandlers;
    private ProgressListener progressListener = new ProgressL();
    private ProgressSupport progressSupport;
    AbstractRefactoring caller;
    Lookup refactoringSource;
    private Context scope;

    protected AbstractRefactoring(Lookup refactoringSource) {
        this.refactoringSource = refactoringSource;
    }

    private Collection getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(RefactoringPluginFactory.class));
            for (RefactoringPluginFactory factory : result.allInstances()) {
                RefactoringPlugin plugin = factory.createInstance(this);
                if (plugin == null || this.caller != null && !factory.getClass().getClassLoader().equals(this.getClass().getClassLoader()) && factory.createInstance(this.caller) != null) continue;
                this.plugins.add(plugin);
            }
        }
        return this.plugins;
    }

    Collection getGBHandlers() {
        if (this.gbHandlers == null) {
            this.gbHandlers = new ArrayList();
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(GuardedBlockHandlerFactory.class));
            Iterator it = result.allInstances().iterator();
            while (it.hasNext()) {
                GuardedBlockHandler handler = ((GuardedBlockHandlerFactory)it.next()).createInstance(this);
                if (handler == null) continue;
                this.gbHandlers.add(handler);
            }
        }
        return this.gbHandlers;
    }

    public final Problem preCheck() {
        this.currentState = 1;
        return this.pluginsPreCheck(null);
    }

    public final Problem prepare(RefactoringSession session) {
        Problem p = null;
        if (this.currentState < 2) {
            p = this.checkParameters();
        }
        if (p != null && p.isFatal()) {
            return p;
        }
        p = this.pluginsPrepare(p, session);
        return p;
    }

    public final Problem checkParameters() {
        Problem p = this.fastCheckParameters();
        if (p != null && p.isFatal()) {
            return p;
        }
        this.currentState = 2;
        return this.pluginsCheckParams(p);
    }

    public final Problem fastCheckParameters() {
        Problem p = null;
        if (this.currentState < 1) {
            p = this.preCheck();
        }
        if (p != null && p.isFatal()) {
            return p;
        }
        return this.pluginsFastCheckParams(p);
    }

    public final synchronized void addProgressListener(ProgressListener listener) {
        if (this.progressSupport == null) {
            this.progressSupport = new ProgressSupport();
        }
        this.progressSupport.addProgressListener(listener);
        if (this.pluginsWithProgress == null) {
            this.pluginsWithProgress = new ArrayList();
            for (RefactoringPlugin plugin : this.getPlugins()) {
                if (!(plugin instanceof ProgressProvider)) continue;
                ((ProgressProvider)((Object)plugin)).addProgressListener(this.progressListener);
                this.pluginsWithProgress.add(plugin);
            }
        }
    }

    public final synchronized void removeProgressListener(ProgressListener listener) {
        if (this.progressSupport != null) {
            this.progressSupport.removeProgressListener(listener);
        }
        if (this.pluginsWithProgress != null) {
            for (ProgressProvider plugin : this.pluginsWithProgress) {
                plugin.removeProgressListener(this.progressListener);
            }
            this.pluginsWithProgress.clear();
            this.pluginsWithProgress = null;
        }
    }

    public final Context getContext() {
        if (this.scope == null) {
            this.scope = new Context(new InstanceContent());
        }
        return this.scope;
    }

    public final Lookup getRefactoringSource() {
        return this.refactoringSource;
    }

    public final void cancelRequest() {
        for (RefactoringPlugin plugin : this.getPlugins()) {
            plugin.cancelRequest();
        }
    }

    private Problem pluginsPreCheck(Problem problem) {
        for (RefactoringPlugin plugin : this.getPlugins()) {
            problem = AbstractRefactoring.chainProblems(plugin.preCheck(), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    private Problem pluginsPrepare(Problem problem, RefactoringSession session) {
        ReadOnlyFilesHandler handler;
        RefactoringElementsBag elements = session.getElementsBag();
        for (RefactoringPlugin plugin : this.getPlugins()) {
            problem = AbstractRefactoring.chainProblems(plugin.prepare(elements), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        if (!(this instanceof WhereUsedQuery) && (handler = this.getROHandler()) != null) {
            Collection files = SPIAccessor.DEFAULT.getReadOnlyFiles(elements);
            HashSet<FileObject> allFiles = new HashSet<FileObject>();
            for (FileObject f : files) {
                try {
                    DataObject dob = DataObject.find((FileObject)f);
                    for (FileObject file : dob.files()) {
                        if (SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)file)) != 1) continue;
                        allFiles.add(file);
                    }
                }
                catch (DataObjectNotFoundException e) {
                    allFiles.add(f);
                }
            }
            problem = AbstractRefactoring.chainProblems(handler.createProblem(session, allFiles), problem);
        }
        return problem;
    }

    private ReadOnlyFilesHandler getROHandler() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ReadOnlyFilesHandler.class));
        List handlers = (List)result.allInstances();
        if (handlers.size() == 0) {
            return null;
        }
        if (handlers.size() > 1) {
            ErrorManager.getDefault().log(16, "Multiple instances of ReadOnlyFilesHandler found in Lookup; only using first one: " + handlers);
        }
        return (ReadOnlyFilesHandler)handlers.get(0);
    }

    private Problem pluginsCheckParams(Problem problem) {
        for (RefactoringPlugin plugin : this.getPlugins()) {
            problem = AbstractRefactoring.chainProblems(plugin.checkParameters(), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    private Problem pluginsFastCheckParams(Problem problem) {
        for (RefactoringPlugin plugin : this.getPlugins()) {
            problem = AbstractRefactoring.chainProblems(plugin.fastCheckParameters(), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    static Problem chainProblems(Problem p, Problem p1) {
        if (p == null) {
            return p1;
        }
        if (p1 == null) {
            return p;
        }
        Problem problem = p;
        while (problem.getNext() != null) {
            problem = problem.getNext();
        }
        problem.setNext(p1);
        return p;
    }

    static {
        APIAccessor.DEFAULT = new AccessorImpl();
    }

    private class ProgressL
    implements ProgressListener {
        private float progressStep;
        private float current;

        private ProgressL() {
        }

        public void start(ProgressEvent event) {
            this.progressStep = 30.0f / (float)event.getCount();
            if (AbstractRefactoring.this.pluginsWithProgress.indexOf(event.getSource()) == 0) {
                this.current = 0.0f;
                if (event.getCount() == -1) {
                    this.fireProgressListenerStart(event.getOperationType(), -1);
                } else {
                    this.fireProgressListenerStart(event.getOperationType(), 30 * AbstractRefactoring.this.pluginsWithProgress.size());
                }
            } else {
                this.current = AbstractRefactoring.this.pluginsWithProgress.indexOf(event.getSource()) * 30;
                this.fireProgressListenerStep((int)this.current);
            }
        }

        public void step(ProgressEvent event) {
            this.current += this.progressStep;
            this.fireProgressListenerStep((int)this.current);
        }

        public void stop(ProgressEvent event) {
            if (AbstractRefactoring.this.pluginsWithProgress.indexOf(event.getSource()) == AbstractRefactoring.this.pluginsWithProgress.size() - 1) {
                this.fireProgressListenerStop();
            }
        }

        private void fireProgressListenerStart(int type, int count) {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStart(this, type, count);
            }
        }

        private void fireProgressListenerStep() {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStep(this);
            }
        }

        private void fireProgressListenerStep(int count) {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStep(this, count);
            }
        }

        private void fireProgressListenerStop() {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStop(this);
            }
        }
    }
}

