/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.IOException;
import java.net.URL;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.plugins.FileHandlingFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;

public class FileCopyPlugin
implements RefactoringPlugin {
    private SingleCopyRefactoring refactoring;

    public FileCopyPlugin(SingleCopyRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        elements.add(this.refactoring, new CopyFile((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class), elements.getSession()));
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    private class CopyFile
    extends SimpleRefactoringElementImplementation {
        private FileObject fo;
        private RefactoringSession session;
        private DataObject newOne;

        public CopyFile(FileObject fo, RefactoringSession session) {
            this.fo = fo;
            this.session = session;
        }

        public String getText() {
            return "Copy file " + this.fo.getNameExt();
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                FileObject fo = FileHandlingFactory.getOrCreateFolder((URL)FileCopyPlugin.this.refactoring.getTarget().lookup(URL.class));
                FileObject source = (FileObject)FileCopyPlugin.this.refactoring.getRefactoringSource().lookup(FileObject.class);
                DataObject dob = DataObject.find((FileObject)source);
                this.newOne = dob.copy(DataFolder.findFolder((FileObject)fo));
                this.newOne.rename(FileCopyPlugin.this.refactoring.getNewName());
                FileCopyPlugin.this.refactoring.getContext().add(this.newOne.getPrimaryFile());
            }
            catch (Exception ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }

        public void undoChange() {
            try {
                this.newOne.delete();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

