/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.plugins.FileHandlingFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;

public class FileMovePlugin
implements RefactoringPlugin {
    private MoveRefactoring refactoring;

    public FileMovePlugin(MoveRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        for (FileObject o : this.refactoring.getRefactoringSource().lookupAll(FileObject.class)) {
            elements.addFileChange(this.refactoring, new MoveFile(o, elements));
        }
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    private class MoveFile
    extends SimpleRefactoringElementImplementation {
        private FileObject fo;
        DataFolder sourceFolder;
        DataObject source;

        public MoveFile(FileObject fo, RefactoringElementsBag session) {
            this.fo = fo;
        }

        public String getText() {
            return "Move file " + this.fo.getNameExt();
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                FileObject target = FileHandlingFactory.getOrCreateFolder((URL)FileMovePlugin.this.refactoring.getTarget().lookup(URL.class));
                DataFolder targetFolder = DataFolder.findFolder((FileObject)target);
                if (!this.fo.isValid()) {
                    this.fo = FileUtil.toFileObject((File)FileUtil.toFile((FileObject)this.fo));
                }
                this.source = DataObject.find((FileObject)this.fo);
                this.sourceFolder = this.source.getFolder();
                this.source.move(targetFolder);
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public void undoChange() {
            try {
                this.source.move(this.sourceFolder);
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

