/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

final class ExternalUtil {
    private static Repository repository;
    private static Logger LOG;

    ExternalUtil() {
    }

    public static Repository getRepository() {
        ExternalUtil.initialize();
        return repository;
    }

    public static void exception(Exception ex) {
        LOG.log(Level.WARNING, null, ex);
    }

    public static Throwable copyAnnotation(Throwable newEx, Throwable oldEx) {
        return newEx.initCause(oldEx);
    }

    public static void annotate(Throwable ex, String msg) {
        Exceptions.attachLocalizedMessage((Throwable)ex, (String)msg);
    }

    public static Throwable annotate(Throwable ex, Throwable stack) {
        Throwable orig = ex;
        while (ex.getCause() != null) {
            ex = ex.getCause();
        }
        ex.initCause(stack);
        return orig;
    }

    public static void log(String msg) {
        LOG.fine(msg);
    }

    public static Class findClass(String name) throws ClassNotFoundException {
        ExternalUtil.initialize();
        ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (c == null) {
            return Class.forName(name);
        }
        return Class.forName(name, true, c);
    }

    private static void initialize() {
        if (!ExternalUtil.isInitialized()) {
            Lookup l = Lookup.getDefault();
            Repository rep = (Repository)l.lookup(Repository.class);
            ExternalUtil.setRepository(rep);
        }
    }

    private static synchronized boolean isInitialized() {
        return repository != null;
    }

    private static synchronized void setRepository(Repository rep) {
        repository = rep;
        if (repository == null) {
            repository = new Repository(new MainFS());
        }
    }

    static {
        LOG = Logger.getLogger("org.openide.filesystems");
    }

    private static final class MainFS
    extends MultiFileSystem
    implements LookupListener {
        private static final Lookup.Result<FileSystem> ALL = Lookup.getDefault().lookupResult(FileSystem.class);
        private static final FileSystem MEMORY = FileUtil.createMemoryFileSystem();

        public MainFS() {
            ALL.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        private static FileSystem[] computeDelegates() {
            ArrayList<FileSystem> arr = new ArrayList<FileSystem>();
            arr.add(MEMORY);
            arr.addAll(ALL.allInstances());
            return arr.toArray(new FileSystem[0]);
        }

        public void resultChanged(LookupEvent ev) {
            this.setDelegates(MainFS.computeDelegates());
        }
    }
}

