/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.ListenerList;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileObject
implements Serializable {
    static final long serialVersionUID = 85305031923497718L;

    public abstract String getName();

    public abstract String getExt();

    public abstract void rename(FileLock var1, String var2, String var3) throws IOException;

    public FileObject copy(FileObject target, String name, String ext) throws IOException {
        if (this.isFolder()) {
            throw new IOException(NbBundle.getBundle(FileObject.class).getString("EXC_FolderCopy"));
        }
        FileObject dest = FileUtil.copyFileImpl(this, target, name, ext);
        return dest;
    }

    public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
        if (this.getParent().equals(target)) {
            this.rename(lock, name, ext);
            return this;
        }
        FileObject dest = this.copy(target, name, ext);
        this.delete(lock);
        return dest;
    }

    public String toString() {
        String cname = this.getClass().getName();
        String cnameShort = cname.substring(cname.lastIndexOf(46) + 1);
        try {
            return cnameShort + '@' + Integer.toHexString(System.identityHashCode(this)) + '[' + (this.isRoot() ? "root of " + this.getFileSystem() : this.getPath()) + ']';
        }
        catch (FileStateInvalidException x) {
            return cnameShort + '@' + Integer.toHexString(System.identityHashCode(this)) + "[???]";
        }
    }

    public String getPath() {
        StringBuilder sb = new StringBuilder();
        this.constructName(sb, '/');
        return sb.toString();
    }

    @Deprecated
    public String getPackageNameExt(char separatorChar, char extSepChar) {
        assert (FileUtil.assertDeprecatedMethod());
        StringBuilder sb = new StringBuilder();
        if (this.isRoot() || this.getParent().isRoot()) {
            return this.getNameExt();
        }
        this.getParent().constructName(sb, separatorChar);
        String ext = this.getExt();
        if (ext == null || ext.equals("")) {
            sb.append(separatorChar).append(this.getNameExt());
        } else {
            sb.append(separatorChar).append(this.getName()).append(extSepChar).append(this.getExt());
        }
        return sb.toString();
    }

    @Deprecated
    public String getPackageName(char separatorChar) {
        assert (FileUtil.assertDeprecatedMethod());
        StringBuilder sb = new StringBuilder();
        if (this.isRoot() || this.getParent().isRoot()) {
            return this.isFolder() ? this.getNameExt() : this.getName();
        }
        this.getParent().constructName(sb, separatorChar);
        sb.append(separatorChar).append(this.getName());
        return sb.toString();
    }

    public String getNameExt() {
        String n = this.getName();
        String e = this.getExt();
        return e == null || e.length() == 0 ? n : n + '.' + e;
    }

    private void constructName(StringBuilder sb, char sepChar) {
        FileObject parent = this.getParent();
        if (parent != null && !parent.isRoot()) {
            parent.constructName(sb, sepChar);
            sb.append(sepChar);
        }
        sb.append(this.getNameExt());
    }

    public abstract FileSystem getFileSystem() throws FileStateInvalidException;

    public abstract FileObject getParent();

    public abstract boolean isFolder();

    public abstract Date lastModified();

    public abstract boolean isRoot();

    public abstract boolean isData();

    public abstract boolean isValid();

    public boolean existsExt(String ext) {
        FileObject parent = this.getParent();
        return parent != null && parent.getFileObject(this.getName(), ext) != null;
    }

    public abstract void delete(FileLock var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete() throws IOException {
        FileLock lock = this.lock();
        try {
            this.delete(lock);
        }
        finally {
            lock.releaseLock();
        }
    }

    public abstract Object getAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2) throws IOException;

    public abstract Enumeration<String> getAttributes();

    public final boolean hasExt(String ext) {
        if (this.isHasExtOverride()) {
            return this.hasExtOverride(ext);
        }
        return this.getExt().equals(ext);
    }

    boolean isHasExtOverride() {
        return false;
    }

    boolean hasExtOverride(String ext) {
        return false;
    }

    public abstract void addFileChangeListener(FileChangeListener var1);

    public abstract void removeFileChangeListener(FileChangeListener var1);

    protected void fireFileDataCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.dispatchEvent(FCLSupport.Op.DATA_CREATED, en, fe);
    }

    protected void fireFileFolderCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.dispatchEvent(FCLSupport.Op.FOLDER_CREATED, en, fe);
    }

    protected void fireFileChangedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.dispatchEvent(FCLSupport.Op.FILE_CHANGED, en, fe);
    }

    protected void fireFileDeletedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.dispatchEvent(FCLSupport.Op.FILE_DELETED, en, fe);
    }

    protected void fireFileAttributeChangedEvent(Enumeration<FileChangeListener> en, FileAttributeEvent fe) {
        this.dispatchEvent(FCLSupport.Op.ATTR_CHANGED, en, fe);
    }

    protected void fireFileRenamedEvent(Enumeration<FileChangeListener> en, FileRenameEvent fe) {
        this.dispatchEvent(FCLSupport.Op.FILE_RENAMED, en, fe);
    }

    private final void dispatchEvent(FCLSupport.Op op, Enumeration<FileChangeListener> en, FileEvent fe) {
        try {
            FileSystem fs = this.getFileSystem();
            fs.dispatchEvent(new ED(op, en, fe));
        }
        catch (FileStateInvalidException ex) {
            // empty catch block
        }
    }

    final void dispatchEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        try {
            this.getFileSystem().dispatchEvent(new ED(en, fe));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public String getMIMEType() {
        return FileUtil.getMIMETypeOrDefault(this);
    }

    public abstract long getSize();

    public abstract InputStream getInputStream() throws FileNotFoundException;

    public abstract OutputStream getOutputStream(FileLock var1) throws IOException;

    public final OutputStream getOutputStream() throws FileAlreadyLockedException, IOException {
        final FileLock lock = this.lock();
        try {
            OutputStream os = this.getOutputStream(lock);
            return new FilterOutputStream(os){

                public void close() throws IOException {
                    try {
                        super.close();
                        lock.releaseLock();
                    }
                    catch (IOException iex) {
                        if (lock.isValid()) {
                            lock.releaseLock();
                        }
                        throw iex;
                    }
                }
            };
        }
        catch (IOException iex) {
            if (lock.isValid()) {
                lock.releaseLock();
            }
            throw iex;
        }
    }

    public abstract FileLock lock() throws IOException;

    @Deprecated
    public abstract void setImportant(boolean var1);

    public abstract FileObject[] getChildren();

    public Enumeration<? extends FileObject> getChildren(final boolean rec) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WithChildren
        implements Enumerations.Processor<FileObject, FileObject> {
            WithChildren() {
            }

            public FileObject process(FileObject fo, Collection<FileObject> toAdd) {
                if (rec && fo.isFolder()) {
                    toAdd.addAll(Arrays.asList(fo.getChildren()));
                }
                return fo;
            }
        }
        return Enumerations.queue((Enumeration)Enumerations.array((Object[])this.getChildren()), (Enumerations.Processor)new WithChildren());
    }

    public Enumeration<? extends FileObject> getFolders(boolean rec) {
        return Enumerations.filter(this.getChildren(rec), (Enumerations.Processor)new OnlyFolders(true));
    }

    public Enumeration<? extends FileObject> getData(boolean rec) {
        return Enumerations.filter(this.getChildren(rec), (Enumerations.Processor)new OnlyFolders(false));
    }

    public abstract FileObject getFileObject(String var1, String var2);

    public FileObject getFileObject(String relativePath) {
        String nameExt;
        FileObject myObj;
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        StringTokenizer st = new StringTokenizer(relativePath, "/");
        for (myObj = this; myObj != null && st.hasMoreTokens(); myObj = myObj.getFileObject(nameExt, null)) {
            nameExt = st.nextToken();
        }
        return myObj;
    }

    public abstract FileObject createFolder(String var1) throws IOException;

    public abstract FileObject createData(String var1, String var2) throws IOException;

    public FileObject createData(String name) throws IOException {
        return this.createData(name, "");
    }

    @Deprecated
    public abstract boolean isReadOnly();

    public boolean canWrite() {
        File f = FileUtil.toFile(this);
        if (f != null) {
            return f.canWrite();
        }
        return !this.isReadOnly();
    }

    public boolean canRead() {
        File f = FileUtil.toFile(this);
        if (f != null) {
            return f.canRead();
        }
        return true;
    }

    public void refresh(boolean expected) {
    }

    public void refresh() {
        this.refresh(false);
    }

    public final URL getURL() throws FileStateInvalidException {
        return URLMapper.findURL(this, 0);
    }

    public boolean isVirtual() {
        return false;
    }

    static boolean isPriorityListener(FileChangeListener fcl) {
        return fcl instanceof PriorityFileChangeListener;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ED
    extends FileSystem.EventDispatcher {
        private FCLSupport.Op op;
        private Enumeration<FileChangeListener> en;
        private final List<FileChangeListener> fsList;
        private final List<FileChangeListener> repList;
        private FileEvent fe;

        public ED(FCLSupport.Op op, Enumeration<FileChangeListener> en, FileEvent fe) {
            this.op = op;
            this.en = en;
            this.fe = fe;
            FileSystem fs = null;
            try {
                fs = this.fe.getFile().getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                ExternalUtil.exception(ex);
            }
            ListenerList<FileChangeListener> fsll = fs != null ? fs.getFCLSupport().listeners : null;
            ListenerList<FileChangeListener> repll = fs != null && fs.getRepository() != null ? fs.getRepository().getFCLSupport().listeners : null;
            this.fsList = fsll != null ? new ArrayList<FileChangeListener>(fsll.getAllListeners()) : new ArrayList();
            this.repList = repll != null ? new ArrayList<FileChangeListener>(repll.getAllListeners()) : new ArrayList();
        }

        public ED(Enumeration<FileChangeListener> en, FileEvent fe) {
            this(null, en, fe);
        }

        @Override
        protected void dispatch(boolean onlyPriority) {
            if (this.op == null) {
                this.op = this.fe.getFile().isFolder() ? FCLSupport.Op.FOLDER_CREATED : FCLSupport.Op.DATA_CREATED;
            }
            LinkedList<FileChangeListener> newEnum = new LinkedList<FileChangeListener>();
            while (this.en.hasMoreElements()) {
                FileChangeListener fcl = this.en.nextElement();
                if (onlyPriority && !FileObject.isPriorityListener(fcl)) {
                    newEnum.add(fcl);
                    continue;
                }
                FCLSupport.dispatchEvent(fcl, this.fe, this.op);
            }
            if (onlyPriority) {
                this.en = Collections.enumeration(newEnum);
            }
            FileObject fo = this.fe.getFile();
            boolean transmit = false;
            if (fo != null) {
                switch (this.op) {
                    case FILE_CHANGED: {
                        transmit = fo.equals(this.fe.getSource());
                        break;
                    }
                    default: {
                        boolean bl = transmit = !fo.equals(this.fe.getSource());
                    }
                }
            }
            if (!this.en.hasMoreElements() && transmit && !onlyPriority) {
                FileSystem fs = null;
                Repository rep = null;
                try {
                    fs = this.fe.getFile().getFileSystem();
                    rep = fs.getRepository();
                }
                catch (FileStateInvalidException fsix) {
                    return;
                }
                if (fs != null && this.fsList != null) {
                    for (FileChangeListener fcl : this.fsList) {
                        fs.getFCLSupport();
                        FCLSupport.dispatchEvent(fcl, this.fe, this.op);
                    }
                }
                if (rep != null && this.repList != null) {
                    for (FileChangeListener fcl : this.repList) {
                        rep.getFCLSupport();
                        FCLSupport.dispatchEvent(fcl, this.fe, this.op);
                    }
                }
            }
        }

        @Override
        protected void setAtomicActionLink(EventControl.AtomicActionLink propID) {
            this.fe.setAtomicActionLink(propID);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OnlyFolders
    implements Enumerations.Processor<FileObject, FileObject> {
        private boolean folders;

        public OnlyFolders(boolean folders) {
            this.folders = folders;
        }

        public FileObject process(FileObject obj, Collection<FileObject> coll) {
            FileObject fo = obj;
            if (this.folders) {
                return fo.isFolder() ? fo : null;
            }
            return fo.isData() ? fo : null;
        }
    }

    static interface PriorityFileChangeListener
    extends FileChangeListener {
    }
}

