/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileObject;
import org.openide.util.Enumerations;
import org.openide.util.NbCollections;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFileSystem
extends FileSystem {
    static final long serialVersionUID = -767493828111559560L;
    static final String MASK = "_hidden";
    private static final int WRITE_SYSTEM_INDEX = 0;
    private FileSystem[] systems;
    private boolean propagateMasks = false;
    private transient MultiFileObject root;

    protected MultiFileSystem() {
        this(new FileSystem[0]);
    }

    public MultiFileSystem(FileSystem[] fileSystems) {
        this.systems = (FileSystem[])fileSystems.clone();
    }

    @Override
    public void refresh(boolean expected) {
        Enumeration<AbstractFolder> en = this.getMultiRoot().existingSubFiles(true);
        while (en.hasMoreElements()) {
            FileObject fo = en.nextElement();
            fo.refresh(expected);
        }
    }

    protected final void setDelegates(FileSystem ... fileSystems) {
        if (Arrays.equals(fileSystems, this.systems)) {
            return;
        }
        FileSystem[] oldSystems = this.systems;
        this.systems = fileSystems;
        this.getMultiRoot().updateAllAfterSetDelegates(oldSystems);
        List<FileSystem> oldList = Arrays.asList(oldSystems);
        List<FileSystem> newList = Arrays.asList(this.systems);
        HashSet<FileSystem> toRemove = new HashSet<FileSystem>(oldList);
        toRemove.removeAll(newList);
        for (FileSystem fs : toRemove) {
            if (fs == null) continue;
            fs.removeNotify();
        }
        HashSet<FileSystem> toAdd = new HashSet<FileSystem>(newList);
        toAdd.removeAll(oldList);
        for (FileSystem fs : toAdd) {
            if (fs == null) continue;
            fs.addNotify();
        }
    }

    protected final FileSystem[] getDelegates() {
        return this.systems;
    }

    public final boolean getPropagateMasks() {
        return this.propagateMasks;
    }

    protected final void setPropagateMasks(boolean pm) {
        this.propagateMasks = pm;
    }

    @Override
    public boolean isReadOnly() {
        return 0 >= this.systems.length || this.systems[0] == null || this.systems[0].isReadOnly();
    }

    @Override
    public String getDisplayName() {
        return MultiFileSystem.getString("CTL_MultiFileSystem");
    }

    @Override
    public FileObject getRoot() {
        return this.getMultiRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiFileObject getMultiRoot() {
        Class<MultiFileSystem> clazz = MultiFileSystem.class;
        synchronized (MultiFileSystem.class) {
            if (this.root == null) {
                this.root = new MultiFileObject(this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.root;
        }
    }

    @Override
    public SystemAction[] getActions() {
        ArrayList<SystemAction> al = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> uniq = new HashSet<SystemAction>(101);
        FileSystem[] del = this.getDelegates();
        for (int i = 0; i < del.length; ++i) {
            if (del[i] == null) continue;
            SystemAction[] acts = del[i].getActions();
            for (int j = 0; j < acts.length; ++j) {
                if (!uniq.add(acts[j])) continue;
                al.add(acts[j]);
            }
        }
        return al.toArray(new SystemAction[al.size()]);
    }

    @Override
    public SystemAction[] getActions(Set<FileObject> foSet) {
        ArrayList<SystemAction> al = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> uniq = new HashSet<SystemAction>(101);
        FileSystem[] del = this.getDelegates();
        for (int i = 0; i < del.length; ++i) {
            if (del[i] == null) continue;
            SystemAction[] acts = del[i].getActions(foSet);
            for (int j = 0; j < acts.length; ++j) {
                if (!uniq.add(acts[j])) continue;
                al.add(acts[j]);
            }
        }
        return al.toArray(new SystemAction[al.size()]);
    }

    @Override
    @Deprecated
    public FileObject find(String aPackage, String name, String ext) {
        Enumeration st = NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(aPackage, "."), String.class, (boolean)true);
        Enumeration en = name == null || ext == null ? st : Enumerations.concat((Enumeration)st, (Enumeration)Enumerations.singleton((Object)(name + '.' + ext)));
        return this.getMultiRoot().find(en);
    }

    @Override
    public FileObject findResource(String name) {
        if (name.length() == 0) {
            return this.getMultiRoot();
        }
        Enumeration tok = NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(name, "/"), String.class, (boolean)true);
        return this.getMultiRoot().find(tok);
    }

    protected final FileSystem findSystem(FileObject fo) throws IllegalArgumentException {
        try {
            if (fo instanceof MultiFileObject) {
                MultiFileObject mfo = (MultiFileObject)fo;
                return mfo.getLeaderFileSystem();
            }
        }
        catch (FileStateInvalidException ex) {
            return this;
        }
        throw new IllegalArgumentException(fo.getPath());
    }

    protected final void hideResource(String res, boolean hide) throws IOException {
        if (hide) {
            this.maskFile(this.createWritableOn(res), res);
        } else {
            this.unmaskFile(this.createWritableOn(res), res);
        }
    }

    protected static Enumeration<String> hiddenFiles(FileObject folder, boolean rec) {
        Enumeration<? extends FileObject> allFiles = folder.getChildren(rec);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class OnlyHidden
        implements Enumerations.Processor<FileObject, String> {
            OnlyHidden() {
            }

            public String process(FileObject obj, Collection<FileObject> ignore) {
                String sf = obj.getPath();
                if (sf.endsWith(MultiFileSystem.MASK)) {
                    return sf.substring(0, sf.length() - MultiFileSystem.MASK.length());
                }
                return null;
            }
        }
        return Enumerations.filter(allFiles, (Enumerations.Processor)new OnlyHidden());
    }

    protected FileObject findResourceOn(FileSystem fs, String res) {
        return fs.findResource(res);
    }

    protected FileSystem createWritableOn(String name) throws IOException {
        if (this.isReadOnly()) {
            FSException.io("EXC_FSisRO", this.getDisplayName());
        }
        return this.systems[0];
    }

    protected FileSystem createWritableOnForRename(String oldName, String newName) throws IOException {
        return this.createWritableOn(newName);
    }

    protected Set createLocksOn(String name) throws IOException {
        FileSystem writable = this.createWritableOn(name);
        return Collections.singleton(writable);
    }

    protected void notifyMigration(FileObject fo) {
    }

    protected void markUnimportant(FileObject fo) {
    }

    @Override
    @Deprecated
    public void prepareEnvironment(FileSystem.Environment env) throws EnvironmentNotSupportedException {
        FileSystem[] layers = this.getDelegates();
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i] == null) continue;
            try {
                layers[i].prepareEnvironment(env);
                continue;
            }
            catch (EnvironmentNotSupportedException ense) {
                // empty catch block
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        for (int i = 0; i < this.systems.length; ++i) {
            if (this.systems[i] == null) continue;
            this.systems[i].addNotify();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        for (int i = 0; i < this.systems.length; ++i) {
            if (this.systems[i] == null) continue;
            this.systems[i].removeNotify();
        }
    }

    private static String[] split(String res, String[] store) {
        if (store == null) {
            store = new String[3];
        }
        int file = res.lastIndexOf(47);
        int dot = res.lastIndexOf(46);
        store[0] = file == -1 ? "" : res.substring(0, file);
        ++file;
        if (dot == -1) {
            store[1] = res.substring(file);
            store[2] = "";
        } else {
            store[1] = res.substring(file, dot);
            store[2] = res.substring(dot + 1);
        }
        return store;
    }

    Enumeration<FileObject> delegates(final String name) {
        Enumeration en = Enumerations.array((Object[])this.systems);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Resources
        implements Enumerations.Processor<FileSystem, FileObject> {
            Resources() {
            }

            public FileObject process(FileSystem fs, Collection<FileSystem> ignore) {
                if (fs == null) {
                    return null;
                }
                return MultiFileSystem.this.findResourceOn(fs, name);
            }
        }
        return Enumerations.filter((Enumeration)en, (Enumerations.Processor)new Resources());
    }

    void maskFile(FileSystem fs, String res) throws IOException {
        FileObject where = this.findResourceOn(fs, fs.getRoot().getPath());
        FileUtil.createData(where, res + MASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmaskFile(FileSystem fs, String res) throws IOException {
        FileObject fo = this.findResourceOn(fs, res + MASK);
        if (fo != null) {
            FileLock lock = fo.lock();
            try {
                fo.delete(lock);
            }
            finally {
                lock.releaseLock();
            }
        }
    }

    void unmaskFileOnAll(FileSystem fs, String res) throws IOException {
        FileSystem[] fss = this.getDelegates();
        for (int i = 0; i < fss.length; ++i) {
            if (fss[i] == null || fss[i].isReadOnly()) continue;
            this.unmaskFile(fss[i], res);
            if (fss[i] != fs) continue;
            return;
        }
    }

    static boolean isMaskFile(FileObject fo) {
        return fo.getExt().endsWith(MASK);
    }
}

