/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StreamPool {
    private static final boolean ANNOTATE_UNCLOSED_STREAMS = Boolean.getBoolean("org.openide.filesystems.annotateUnclosedStreams");
    private static Map<FileObject, StreamPool> fo2StreamPool = new WeakHashMap<FileObject, StreamPool>();
    private static Map<FileSystem, StreamPool> fs2StreamPool = new WeakHashMap<FileSystem, StreamPool>();
    private Set<InputStream> iStreams;
    private Set<OutputStream> oStreams;

    private StreamPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream createInputStream(final AbstractFolder fo) throws FileNotFoundException {
        InputStream retVal = null;
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            try {
                StreamPool.get(fo).waitForOutputStreamsClosed(2000);
                retVal = new NotifyInputStream(fo);
                StreamPool.get(fo).iStream().add(retVal);
                StreamPool.get(fo.getFileSystem()).iStream().add(retVal);
            }
            catch (InterruptedException e) {
                ExternalUtil.exception(e);
            }
            if (retVal != null && retVal instanceof NotifyInputStream) {
                AbstractFileSystem abstractFileSystem = (AbstractFileSystem)fo.getFileSystem();
                ((NotifyInputStream)retVal).setOriginal(abstractFileSystem.info.inputStream(fo.getPath()));
            } else {
                retVal = new InputStream(){

                    public int read() throws IOException {
                        FileAlreadyLockedException alreadyLockedEx = new FileAlreadyLockedException(fo.getPath());
                        StreamPool.get(fo).annotate(alreadyLockedEx);
                        throw alreadyLockedEx;
                    }
                };
            }
            return retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream createOutputStream(final AbstractFolder fo, boolean fireFileChanged) throws IOException {
        OutputStream retVal = null;
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            try {
                StreamPool.get(fo).waitForInputStreamsClosed(2000);
                StreamPool.get(fo).waitForOutputStreamsClosed(2000);
                retVal = new NotifyOutputStream(fo, fireFileChanged);
                StreamPool.get(fo).oStream().add(retVal);
                StreamPool.get(fo.getFileSystem()).oStream().add(retVal);
            }
            catch (InterruptedException e) {
                ExternalUtil.exception(e);
            }
            if (retVal != null && retVal instanceof NotifyOutputStream) {
                AbstractFileSystem abstractFileSystem = (AbstractFileSystem)fo.getFileSystem();
                ((NotifyOutputStream)retVal).setOriginal(abstractFileSystem.info.outputStream(fo.getPath()));
            } else {
                retVal = new OutputStream(){

                    public void write(int b) throws IOException {
                        FileAlreadyLockedException alreadyLockedEx = new FileAlreadyLockedException(fo.getPath());
                        StreamPool.get(fo).annotate(alreadyLockedEx);
                        throw alreadyLockedEx;
                    }
                };
            }
            return retVal;
        }
    }

    public static synchronized StreamPool find(FileObject fo) {
        return fo2StreamPool.get(fo);
    }

    public static synchronized StreamPool find(FileSystem fs) {
        return fs2StreamPool.get(fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Exception ex) {
        if (!ANNOTATE_UNCLOSED_STREAMS) {
            return;
        }
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            Exception annotation;
            if (this.iStreams != null) {
                for (NotifyInputStream notifyInputStream : this.iStreams) {
                    annotation = notifyInputStream.getException();
                    if (annotation == null) continue;
                    ExternalUtil.annotate((Throwable)ex, annotation);
                }
            }
            if (this.oStreams != null) {
                for (NotifyOutputStream notifyOutputStream : this.oStreams) {
                    annotation = notifyOutputStream.getException();
                    if (annotation == null) continue;
                    ExternalUtil.annotate((Throwable)ex, annotation);
                }
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    public boolean isInputStreamOpen() {
        return this.iStreams != null && !this.iStreams.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInputStreamsClosed(int timeInMs) throws InterruptedException {
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            if (this.isInputStreamOpen()) {
                StreamPool.class.wait((long)timeInMs);
                if (this.isInputStreamOpen()) {
                    throw new InterruptedException();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutputStreamsClosed(int timeInMs) throws InterruptedException {
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            if (this.isOutputStreamOpen()) {
                StreamPool.class.wait((long)timeInMs);
                if (this.isOutputStreamOpen()) {
                    throw new InterruptedException();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean isOutputStreamOpen() {
        return this.oStreams != null && !this.oStreams.isEmpty();
    }

    private static StreamPool get(FileObject fo) {
        StreamPool strPool = fo2StreamPool.get(fo);
        if (strPool == null) {
            strPool = new StreamPool();
            fo2StreamPool.put(fo, strPool);
        }
        return strPool;
    }

    private static StreamPool get(FileSystem fs) {
        StreamPool strPool = fs2StreamPool.get(fs);
        if (strPool == null) {
            strPool = new StreamPool();
            fs2StreamPool.put(fs, strPool);
        }
        return strPool;
    }

    private Set<InputStream> iStream() {
        if (this.iStreams == null) {
            this.iStreams = new WeakSet();
        }
        return this.iStreams;
    }

    private Set<OutputStream> oStream() {
        if (this.oStreams == null) {
            this.oStreams = new WeakSet();
        }
        return this.oStreams;
    }

    private static void closeOutputStream(AbstractFolder fo, OutputStream os, boolean fireFileChanged) {
        StreamPool foPool = StreamPool.find(fo);
        StreamPool fsPool = StreamPool.find(fo.getFileSystem());
        Set<OutputStream> foSet = foPool != null ? foPool.oStreams : null;
        Set<OutputStream> fsSet = fsPool != null ? fsPool.oStreams : null;
        StreamPool.removeStreams(fsSet, foSet, os);
        StreamPool.removeStreamPools(fsPool, foPool, fo);
        fo.outputStreamClosed(fireFileChanged);
    }

    private static void closeInputStream(AbstractFolder fo, InputStream is) {
        StreamPool foPool = StreamPool.find(fo);
        StreamPool fsPool = StreamPool.find(fo.getFileSystem());
        Set<InputStream> foSet = foPool != null ? foPool.iStreams : null;
        Set<InputStream> fsSet = fsPool != null ? fsPool.iStreams : null;
        StreamPool.removeStreams(fsSet, foSet, is);
        StreamPool.removeStreamPools(fsPool, foPool, fo);
    }

    private static synchronized void removeStreams(Set fsSet, Set foSet, Object stream) {
        if (foSet != null) {
            foSet.remove(stream);
        }
        if (fsSet != null) {
            fsSet.remove(stream);
        }
    }

    private static synchronized void removeStreamPools(StreamPool fsPool, StreamPool foPool, AbstractFolder fo) {
        boolean isOStreamEmpty;
        boolean isIStreamEmpty = foPool == null || foPool.iStreams == null || foPool.iStreams.isEmpty();
        boolean bl = isOStreamEmpty = foPool == null || foPool.oStreams == null || foPool.oStreams.isEmpty();
        if (isIStreamEmpty && isOStreamEmpty) {
            fo2StreamPool.remove(fo);
        }
        isIStreamEmpty = fsPool == null || fsPool.iStreams == null || fsPool.iStreams.isEmpty();
        boolean bl2 = isOStreamEmpty = fsPool == null || fsPool.oStreams == null || fsPool.oStreams.isEmpty();
        if (isIStreamEmpty && isOStreamEmpty) {
            fs2StreamPool.remove(fo.getFileSystem());
        }
    }

    private static final class NotifyInputStream
    extends FilterInputStream {
        private static final InputStream emptyIs = new ByteArrayInputStream(new byte[0]);
        private Exception ex;
        AbstractFolder fo;
        private boolean closed = false;

        public NotifyInputStream(AbstractFolder fo) {
            super(emptyIs);
            this.fo = fo;
            if (ANNOTATE_UNCLOSED_STREAMS) {
                this.ex = new Exception();
            }
        }

        private void setOriginal(InputStream is) {
            this.in = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            if (this.closed) return;
            this.closed = true;
            this.ex = null;
            super.close();
            StreamPool.closeInputStream(this.fo, this);
            Class<StreamPool> clazz = StreamPool.class;
            synchronized (StreamPool.class) {
                if (StreamPool.get(this.fo).isInputStreamOpen()) return;
                StreamPool.class.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }

    private static final class NotifyOutputStream
    extends FilterOutputStream {
        private static final OutputStream emptyOs = new ByteArrayOutputStream();
        private Exception ex;
        private boolean closed = false;
        AbstractFolder fo;
        private boolean fireFileChanged;

        public NotifyOutputStream(AbstractFolder fo, boolean fireFileChanged) {
            super(emptyOs);
            this.fo = fo;
            if (ANNOTATE_UNCLOSED_STREAMS) {
                this.ex = new Exception();
            }
            this.fireFileChanged = fireFileChanged;
        }

        private void setOriginal(OutputStream os) {
            this.out = os;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            if (this.closed) return;
            this.closed = true;
            this.ex = null;
            this.out.flush();
            super.close();
            StreamPool.closeOutputStream(this.fo, this, this.fireFileChanged);
            Class<StreamPool> clazz = StreamPool.class;
            synchronized (StreamPool.class) {
                StreamPool.class.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }
}

