/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.IOException;
import org.openide.ErrorManager;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class OutputLogger
implements ISVNNotifyListener {
    private InputOutput log;
    private boolean ignoreCommand = false;
    private String repositoryRootString;

    public static OutputLogger getLogger(SVNUrl repositoryRoot) {
        if (repositoryRoot != null) {
            return new OutputLogger(repositoryRoot);
        }
        return new NullLogger();
    }

    private OutputLogger(SVNUrl repositoryRoot) {
        this.repositoryRootString = repositoryRoot.toString();
        this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
    }

    private OutputLogger() {
    }

    public void logCommandLine(String commandLine) {
        this.logln(commandLine, false);
        this.flushLog();
    }

    public void logCompleted(String message) {
        this.logln(message, this.ignoreCommand);
        this.flushLog();
    }

    public void logError(String message) {
        this.logln(message, false);
        this.flushLog();
    }

    public void logMessage(String message) {
        this.logln(message, this.ignoreCommand);
        this.flushLog();
    }

    public void logRevision(long revision, String path) {
    }

    public void onNotify(File path, SVNNodeKind kind) {
    }

    public void setCommand(int command) {
        this.ignoreCommand = command == 19 || command == 12 || command == 25 || command == 13 || command == 11;
    }

    private void logln(String message, boolean ignore) {
        this.log(message + "\n", null, ignore);
    }

    private void log(String message, OutputListener hyperlinkListener, boolean ignore) {
        if (ignore) {
            return;
        }
        if (this.log.isClosed()) {
            this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
            try {
                this.log.getOut().reset();
            }
            catch (IOException e) {
                ErrorManager err = ErrorManager.getDefault();
                err.notify((Throwable)e);
            }
        }
        if (hyperlinkListener != null) {
            try {
                this.log.getOut().println(message, hyperlinkListener);
            }
            catch (IOException e) {
                this.log.getOut().write(message);
            }
        } else {
            this.log.getOut().write(message);
        }
    }

    public void closeLog() {
        this.log.getOut().flush();
        this.log.getOut().close();
    }

    public void flushLog() {
        this.log.getOut().flush();
    }

    private static class NullLogger
    extends OutputLogger {
        private NullLogger() {
        }

        public void logCommandLine(String commandLine) {
        }

        public void logCompleted(String message) {
        }

        public void logError(String message) {
        }

        public void logMessage(String message) {
        }

        public void logRevision(long revision, String path) {
        }

        public void onNotify(File path, SVNNodeKind kind) {
        }

        public void setCommand(int command) {
        }

        public void closeLog() {
        }

        public void flushLog() {
        }
    }
}

