/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.util.NbBundle;

public class SubversionVCS
extends VersioningSystem
implements VersioningListener,
PreferenceChangeListener,
PropertyChangeListener {
    public SubversionVCS() {
        this.putProperty("String VCS.DisplayName", NbBundle.getMessage(SubversionVCS.class, (String)"CTL_Subversion_DisplayName"));
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(SubversionVCS.class, (String)"CTL_Subversion_MainMenu"));
        Subversion.getInstance().getStatusCache().addVersioningListener(this);
        Subversion.getInstance().addPropertyChangeListener(this);
        SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public File getTopmostManagedAncestor(File file) {
        return Subversion.getInstance().getTopmostManagedParent(file);
    }

    public VCSAnnotator getVCSAnnotator() {
        return Subversion.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return Subversion.getInstance().getVCSInterceptor();
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        Subversion.getInstance().getOriginalFile(workingCopy, originalFile);
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)event.getParams()[0];
            this.fireStatusChanged(file);
        }
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        } else if (evt.getKey().startsWith("textAnnotations")) {
            this.fireAnnotationsChanged(null);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("annotationsChanged")) {
            this.fireAnnotationsChanged((Set)evt.getNewValue());
        } else if (evt.getPropertyName().equals("versionedFilesChanged")) {
            this.fireVersionedFilesChanged();
        }
    }
}

