/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class VersionsCache {
    private static VersionsCache instance;

    private VersionsCache() {
    }

    public static synchronized VersionsCache getInstance() {
        if (instance == null) {
            instance = new VersionsCache();
        }
        return instance;
    }

    public File getFileRevision(File base, String revision) throws IOException {
        if ("BASE".equals(revision)) {
            try {
                File svnDir = this.getMetadataDir(base.getParentFile());
                if (svnDir == null) {
                    return null;
                }
                File svnBase = new File(svnDir, "text-base/" + base.getName() + ".svn-base");
                if (!svnBase.exists()) {
                    return null;
                }
                File expanded = new File(svnDir, "text-base/" + base.getName() + ".netbeans-base");
                if (expanded.canRead() && svnBase.isFile() && expanded.lastModified() > svnBase.lastModified()) {
                    return expanded;
                }
                SvnClient client = Subversion.getInstance().getClient(base);
                InputStream in = client.getContent(base, SVNRevision.BASE);
                expanded = FileUtil.normalizeFile((File)expanded);
                expanded.deleteOnExit();
                FileUtils.copyStreamToFile(new BufferedInputStream(in), expanded);
                return expanded;
            }
            catch (SVNClientException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        if ("PRISTINE".equals(revision)) {
            String name = base.getName();
            File svnDir = this.getMetadataDir(base.getParentFile());
            if (svnDir != null) {
                File text_base = new File(svnDir, "text-base");
                File pristine = new File(text_base, name + ".svn-base");
                if (pristine.isFile()) {
                    return pristine;
                }
                return null;
            }
            return null;
        }
        if ("LOCAL".equals(revision)) {
            return base;
        }
        Object svnrevision = "HEAD".equals(revision) ? SVNRevision.HEAD : new SVNRevision.Number(Long.parseLong(revision));
        try {
            InputStream in;
            SvnClient client = Subversion.getInstance().getClient(base);
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            if ((cache.getStatus(base).getStatus() & 0x1DF8) != 0) {
                in = client.getContent(base, (SVNRevision)svnrevision);
            } else {
                SVNUrl url = SvnUtils.getRepositoryUrl(base);
                if (url != null) {
                    url = url.appendPath("@" + revision);
                    in = client.getContent(url, (SVNRevision)svnrevision);
                } else {
                    in = new ByteArrayInputStream(NbBundle.getMessage(VersionsCache.class, (String)"MSG_UnknownURL").getBytes());
                }
            }
            File tmp = File.createTempFile("nb-svn", base.getName());
            tmp = FileUtil.normalizeFile((File)tmp);
            tmp.deleteOnExit();
            FileUtils.copyStreamToFile(new BufferedInputStream(in), tmp);
            return tmp;
        }
        catch (SVNClientException ex) {
            IOException ioex = new IOException("Can not load: " + base.getAbsolutePath() + " in revision: " + revision);
            ioex.initCause(ex);
            throw ioex;
        }
    }

    private File getMetadataDir(File dir) {
        File svnDir = new File(dir, ".svn");
        if (!svnDir.isDirectory() && !(svnDir = new File(dir, "_svn")).isDirectory()) {
            return null;
        }
        return svnDir;
    }
}

