/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.parser.ParserSvnInfo;
import org.netbeans.modules.subversion.config.KVFile;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesClient {
    private final File file;

    public PropertiesClient(File file) {
        assert (file != null);
        this.file = file;
    }

    public Map<String, byte[]> getBaseProperties() throws IOException {
        File store;
        try {
            store = this.getPropertyFile(true);
        }
        catch (SVNClientException ex) {
            throw new IOException(ex.getMessage());
        }
        if (store != null && store.isFile()) {
            KVFile kv = new KVFile(store);
            return this.normalize(kv.getMap());
        }
        return new HashMap<String, byte[]>();
    }

    public Map<String, byte[]> getProperties() throws IOException {
        File store;
        try {
            store = this.getPropertyFile(false);
        }
        catch (SVNClientException ex) {
            throw new IOException(ex.getMessage());
        }
        if (store != null && store.isFile()) {
            KVFile kv = new KVFile(store);
            return this.normalize(kv.getMap());
        }
        return new HashMap<String, byte[]>();
    }

    private File getPropertyFile(boolean base) throws SVNClientException {
        SvnClient client = Subversion.getInstance().getClient(false);
        ISVNInfo info = null;
        info = client.getInfoFromWorkingCopy(this.file);
        if (info instanceof ParserSvnInfo) {
            if (base) {
                return ((ParserSvnInfo)info).getBasePropertyFile();
            }
            return ((ParserSvnInfo)info).getPropertyFile();
        }
        throw new SVNClientException("Unexpected value:" + info + " should be from type " + ParserSvnInfo.class);
    }

    private Map<String, byte[]> normalize(Map map) {
        HashMap<String, byte[]> ret = new HashMap<String, byte[]>(map.size());
        for (Map.Entry next : map.entrySet()) {
            ret.put(next.getKey().toString(), (byte[])next.getValue());
        }
        return ret;
    }

    public Map getProperties(int revision) throws IOException {
        throw new UnsupportedOperationException();
    }
}

