/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.awt.Dialog;
import javax.swing.JButton;
import org.netbeans.modules.subversion.client.AcceptCertificatePanel;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnClientCallback
implements ISVNPromptUserPassword {
    private final SVNUrl url;
    private final int handledExceptions;
    private String username = null;
    private String password = null;
    private final boolean prompt;

    public SvnClientCallback(SVNUrl url, int handledExceptions) {
        this.url = url;
        this.handledExceptions = handledExceptions;
        this.prompt = (4 & handledExceptions) == 4;
    }

    public boolean askYesNo(String string, String string0, boolean b) {
        return false;
    }

    public String getUsername() {
        if ((4 & this.handledExceptions) != 4) {
            return null;
        }
        if (this.username == null) {
            this.getAuthData();
        }
        String ret = this.username;
        this.username = null;
        return ret;
    }

    public String getPassword() {
        if ((4 & this.handledExceptions) != 4) {
            return null;
        }
        if (this.password == null) {
            this.getAuthData();
        }
        String ret = this.password;
        this.password = null;
        return ret;
    }

    public int askTrustSSLServer(String certMessage, boolean b) {
        if ((8 & this.handledExceptions) != 8) {
            return -1;
        }
        AcceptCertificatePanel acceptCertificatePanel = new AcceptCertificatePanel();
        acceptCertificatePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Error_CertFailed"));
        acceptCertificatePanel.certificatePane.setText(certMessage);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)acceptCertificatePanel, NbBundle.getMessage(SvnClientCallback.class, (String)"CTL_Error_CertFailed"));
        JButton permanentlyButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptPermanently"));
        JButton temporarilyButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptTemp"));
        JButton rejectButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_Reject"));
        dialogDescriptor.setOptions(new Object[]{permanentlyButton, temporarilyButton, rejectButton});
        this.showDialog(dialogDescriptor);
        if (dialogDescriptor.getValue() != permanentlyButton) {
            return 2;
        }
        if (dialogDescriptor.getValue() != temporarilyButton) {
            return 1;
        }
        return 0;
    }

    public boolean prompt(String string, String string0, boolean b) {
        return this.prompt;
    }

    public String askQuestion(String string, String string0, boolean b, boolean b0) {
        return null;
    }

    public boolean userAllowedSave() {
        return true;
    }

    public boolean promptSSH(String string, String string0, int i, boolean b) {
        return false;
    }

    public String getSSHPrivateKeyPath() {
        return null;
    }

    public String getSSHPrivateKeyPassphrase() {
        return null;
    }

    public int getSSHPort() {
        return -1;
    }

    public boolean promptSSL(String string, boolean b) {
        return false;
    }

    public String getSSLClientCertPassword() {
        return null;
    }

    public String getSSLClientCertPath() {
        return null;
    }

    private void showDialog(DialogDescriptor dialogDescriptor) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private void getAuthData() {
        boolean ret;
        String title = NbBundle.getMessage(SvnClientCallback.class, (String)"MSG_Error_ConnectionParameters");
        Repository repository = new Repository(title);
        repository.selectUrl(this.url, true);
        JButton retryButton = new JButton(NbBundle.getMessage(SvnClientCallback.class, (String)"CTL_Action_Retry"));
        Object option = repository.show(NbBundle.getMessage(SvnClientCallback.class, (String)"MSG_Error_AuthFailed"), new HelpCtx(this.getClass()), new Object[]{retryButton, NbBundle.getMessage(SvnClientCallback.class, (String)"CTL_Action_Cancel")});
        boolean bl = ret = option == retryButton;
        if (ret) {
            RepositoryConnection rc = repository.getSelectedRC();
            this.username = rc.getUsername();
            this.password = rc.getPassword();
        }
    }
}

