/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientCallback;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientInvocationHandler;
import org.netbeans.modules.subversion.client.SvnCmdLineClientInvocationHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;

public class SvnClientFactory {
    private static SvnClientFactory instance;
    private static ClientAdapterFactory factory;
    private static SVNClientException exception;

    private SvnClientFactory() {
    }

    public static synchronized SvnClientFactory getInstance() {
        SvnClientFactory.init();
        return instance;
    }

    public static synchronized void init() {
        if (instance == null) {
            instance = new SvnClientFactory();
            instance.setup();
        }
    }

    public SvnClient createSvnClient() throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
        return factory.createSvnClient();
    }

    public SvnClient createSvnClient(SVNUrl repositoryUrl, SvnProgressSupport support, String username, String password, int handledExceptions) throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
        return factory.createSvnClient(repositoryUrl, support, username, password, handledExceptions);
    }

    private void setup() {
        block6: {
            try {
                String factoryType = System.getProperty("svnClientAdapterFactory");
                if (factoryType == null || factoryType.trim().equals("") || factoryType.equals("commandline")) {
                    this.setupCommandline();
                    break block6;
                }
                if (factoryType.equals("javahl")) {
                    try {
                        this.setupJavaHl();
                    }
                    catch (Throwable t) {
                        String jhlErorrs = JhlClientAdapter.getLibraryLoadErrors();
                        ErrorManager.getDefault().notify(16, t);
                        ErrorManager.getDefault().log(16, jhlErorrs);
                        ErrorManager.getDefault().log(16, "Could not setup JavaHl. Falling back on the commandline client!");
                        this.setupCommandline();
                    }
                    break block6;
                }
                throw new SVNClientException("Unknown factory: " + factoryType);
            }
            catch (SVNClientException e) {
                exception = e;
            }
        }
    }

    public static void checkClientAvailable() throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
    }

    private void setupJavaHl() throws SVNClientException {
        JhlClientAdapterFactory.setup();
        factory = new ClientAdapterFactory(){

            protected ISVNClientAdapter createAdapter() {
                return SVNClientAdapterFactory.createSVNClient((String)"javahl");
            }

            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions) {
                return new SvnClientInvocationHandler(adapter, desc, support, handledExceptions);
            }

            protected ISVNPromptUserPassword createCallback(SVNUrl repositoryUrl, int handledExceptions) {
                return new SvnClientCallback(repositoryUrl, handledExceptions);
            }
        };
        ErrorManager.getDefault().log(1, "svnClientAdapter running on javahl");
    }

    private void setupCommandline() throws SVNClientException {
        String subversionPath = SvnModuleConfig.getDefault().getExecutableBinaryPath();
        CmdLineClientAdapterFactory.setup((String)subversionPath);
        factory = new ClientAdapterFactory(){

            protected ISVNClientAdapter createAdapter() {
                return SVNClientAdapterFactory.createSVNClient((String)"commandline");
            }

            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions) {
                return new SvnCmdLineClientInvocationHandler(adapter, desc, support, handledExceptions);
            }

            protected ISVNPromptUserPassword createCallback(SVNUrl repositoryUrl, int handledExceptions) {
                return null;
            }
        };
        ErrorManager.getDefault().log(1, "svnClientAdapter running on commandline client");
    }

    static {
        exception = null;
    }

    private abstract class ClientAdapterFactory {
        private ClientAdapterFactory() {
        }

        protected abstract ISVNClientAdapter createAdapter();

        protected abstract SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter var1, SvnClientDescriptor var2, SvnProgressSupport var3, int var4);

        protected abstract ISVNPromptUserPassword createCallback(SVNUrl var1, int var2);

        SvnClient createSvnClient() {
            SvnClientInvocationHandler handler = this.getInvocationHandler(this.createAdapter(), this.createDescriptor(null), null, -1);
            return this.createSvnClient(handler);
        }

        public SvnClient createSvnClient(SVNUrl repositoryUrl, SvnProgressSupport support, String username, String password, int handledExceptions) {
            ISVNClientAdapter adapter = this.createAdapter();
            SvnClientInvocationHandler handler = this.getInvocationHandler(adapter, this.createDescriptor(repositoryUrl), support, handledExceptions);
            this.setupAdapter(adapter, username, password, this.createCallback(repositoryUrl, handledExceptions));
            return this.createSvnClient(handler);
        }

        private SvnClientDescriptor createDescriptor(final SVNUrl repositoryUrl) {
            return new SvnClientDescriptor(){

                public SVNUrl getSvnUrl() {
                    return repositoryUrl;
                }
            };
        }

        private SvnClient createSvnClient(SvnClientInvocationHandler handler) {
            Class<?> proxyClass = Proxy.getProxyClass(SvnClient.class.getClassLoader(), SvnClient.class);
            Subversion.getInstance().cleanupFilesystem();
            try {
                return (SvnClient)proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return null;
            }
        }

        protected void setupAdapter(ISVNClientAdapter adapter, String username, String password, ISVNPromptUserPassword callback) {
            if (callback != null) {
                adapter.addPasswordCallback(callback);
            }
            try {
                File configDir = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath()));
                adapter.setConfigDirectory(configDir);
                adapter.setUsername(username);
                adapter.setPassword(password);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
        }
    }
}

