/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.text.DateFormat;
import java.util.Date;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.subversion.Diagnostics;
import org.netbeans.modules.subversion.OutputLogger;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class SvnProgressSupport
implements Runnable,
Cancellable {
    private Cancellable delegate;
    private volatile boolean canceled;
    private ProgressHandle progressHandle = null;
    private String displayName = "";
    private String originalDisplayName = "";
    private OutputLogger logger;
    private SVNUrl repositoryRoot;
    private RequestProcessor.Task task;

    public RequestProcessor.Task start(RequestProcessor rp, SVNUrl repositoryRoot, String displayName) {
        this.setDisplayName(displayName);
        this.repositoryRoot = repositoryRoot;
        this.task = rp.post((Runnable)this);
        this.task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                SvnProgressSupport.this.delegate = null;
                SvnProgressSupport.this.delegate = null;
            }
        });
        return this.task;
    }

    public void setRepositoryRoot(SVNUrl repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
        this.logger = null;
    }

    public void run() {
        this.startProgress();
        this.performIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performIntern() {
        try {
            Diagnostics.println("Start - " + this.displayName);
            if (!this.canceled) {
                this.perform();
            }
            Diagnostics.println("End - " + this.displayName);
        }
        finally {
            this.finnishProgress();
            this.getLogger().closeLog();
        }
    }

    protected abstract void perform();

    public synchronized boolean isCanceled() {
        return this.canceled;
    }

    public synchronized boolean cancel() {
        this.getLogger().flushLog();
        if (this.canceled) {
            return false;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.delegate != null) {
            this.delegate.cancel();
        }
        this.canceled = true;
        return true;
    }

    void setCancellableDelegate(Cancellable cancellable) {
        this.delegate = cancellable;
    }

    public void setDisplayName(String displayName) {
        if (this.originalDisplayName.equals("")) {
            this.originalDisplayName = displayName;
        }
        this.displayName = displayName;
        if (this.progressHandle != null) {
            this.progressHandle.progress(displayName);
        }
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected ProgressHandle getProgressHandle() {
        if (this.progressHandle == null) {
            this.progressHandle = ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)this);
        }
        return this.progressHandle;
    }

    protected void startProgress() {
        this.getProgressHandle().start();
        this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName);
    }

    protected void finnishProgress() {
        this.getProgressHandle().finish();
        if (!this.isCanceled()) {
            this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName + " " + NbBundle.getMessage(SvnProgressSupport.class, (String)"MSG_Progress_Finished"));
        } else {
            this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName + " " + NbBundle.getMessage(SvnProgressSupport.class, (String)"MSG_Progress_Canceled"));
        }
    }

    protected OutputLogger getLogger() {
        if (this.logger == null) {
            this.logger = Subversion.getInstance().getLogger(this.repositoryRoot);
        }
        return this.logger;
    }

    public void annotate(SVNClientException ex) {
        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), !this.isCanceled(), true);
    }
}

